/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import jenkins.SlaveToMasterFileCallable;
import jenkins.model.Jenkins;
import org.eclipse.jgit.lib.PersonIdent;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import ru.yandex.jenkins.plugins.debuilder.DebUtils;
import ru.yandex.jenkins.plugins.debuilder.DebianPackageBuilder;

public class GitCommitHelper
extends SlaveToMasterFileCallable<Boolean> {
    private static final long serialVersionUID = 1L;
    private final EnvVars environment;
    private final TaskListener listener;
    private final String gitExe;
    private final String gitPrefix;
    private final String accountName;
    private final String accountEmail;
    private final String commitMessage;
    private Collection<String> modules;

    public GitCommitHelper(AbstractBuild<?, ?> build, GitSCM scm, DebUtils.Runner runner, String commitMessage, Collection<String> modules) throws IOException, InterruptedException {
        this.commitMessage = commitMessage;
        this.modules = modules;
        this.environment = build.getEnvironment((TaskListener)runner.getListener());
        this.listener = runner.getListener();
        this.gitExe = scm.getGitExe(build.getBuiltOn(), this.listener);
        this.gitPrefix = scm.getRelativeTargetDir();
        DebianPackageBuilder.DescriptorImpl descriptor = (DebianPackageBuilder.DescriptorImpl)Jenkins.getInstance().getDescriptor(DebianPackageBuilder.class);
        this.accountName = descriptor.getAccountName();
        this.accountEmail = descriptor.getAccountEmail();
    }

    public Boolean invoke(File localWorkspace, VirtualChannel channel) throws IOException, InterruptedException {
        GitClient git;
        File gitClonePath = localWorkspace;
        if (this.gitPrefix != null) {
            gitClonePath = new File(localWorkspace, this.gitPrefix);
        }
        if ((git = Git.with((TaskListener)this.listener, (EnvVars)this.environment).in(gitClonePath).using(this.gitExe).getClient()).hasGitRepo()) {
            PersonIdent person = new PersonIdent(this.accountName, this.accountEmail);
            for (String module : this.modules) {
                git.add(new File(module, "debian/changelog").getCanonicalPath());
            }
            git.setAuthor(person);
            git.setCommitter(person);
            git.commit(this.commitMessage);
            return true;
        }
        return false;
    }
}

