/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.properties;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import ru.qatools.properties.Config;
import ru.qatools.properties.DefaultValue;
import ru.qatools.properties.Property;
import ru.qatools.properties.PropertyLoaderException;
import ru.qatools.properties.Required;
import ru.qatools.properties.Use;
import ru.qatools.properties.converters.ConversionException;
import ru.qatools.properties.converters.Converter;
import ru.qatools.properties.converters.ConverterManager;
import ru.qatools.properties.internal.PropertiesProxy;
import ru.qatools.properties.internal.PropertyInfo;
import ru.qatools.properties.providers.DefaultPropertyProvider;
import ru.qatools.properties.providers.PropertyProvider;

public class PropertyLoader {
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    protected Properties defaults = new Properties();
    protected Properties compiled = new Properties();
    protected PropertyProvider propertyProvider = new DefaultPropertyProvider();
    protected final ConverterManager manager = new ConverterManager();

    PropertyLoader() {
    }

    public void populate(Object bean) {
        Objects.requireNonNull(bean);
        this.compileProperties(bean.getClass());
        for (Class<?> clazz = bean.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Map propertyInfoMap = this.resolveProperties(clazz.getDeclaredFields());
            for (Field field : propertyInfoMap.keySet()) {
                PropertyInfo info = (PropertyInfo)propertyInfoMap.get(field);
                this.setValueToField(field, bean, info.getValue());
            }
        }
    }

    public <T> T populate(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        this.compileProperties(clazz);
        HashSet<Class> resolvedConfigs = new HashSet<Class>();
        resolvedConfigs.add(clazz);
        return this.populate(clazz, resolvedConfigs);
    }

    public <T> T populate(Class<T> clazz, Set<Class> resolvedConfigs) {
        return this.populate(null, clazz, resolvedConfigs);
    }

    public <T> T populate(String prefix, Class<T> clazz, Set<Class> resolvedConfigs) {
        this.checkConfigurationClass(clazz);
        HashMap<Method, PropertyInfo> properties = new HashMap<Method, PropertyInfo>();
        properties.putAll(this.resolveProperties(prefix, clazz.getMethods()));
        properties.putAll(this.resolveConfigs(clazz.getMethods(), resolvedConfigs));
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new PropertiesProxy(properties));
    }

    protected void setValueToField(Field field, Object bean, Object value) {
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (Exception e) {
            throw new PropertyLoaderException(String.format("Can not set bean <%s> field <%s> value", bean, field), e);
        }
    }

    protected void checkConfigurationClass(Class<?> clazz) {
        if (!clazz.isInterface()) {
            throw new PropertyLoaderException(clazz + " is not an interface");
        }
    }

    protected void compileProperties(Class<?> clazz) {
        this.compiled.putAll((Map<?, ?>)this.defaults);
        this.compiled.putAll((Map<?, ?>)this.propertyProvider.provide(this.classLoader, clazz));
    }

    protected <T extends AnnotatedElement> Map<T, PropertyInfo> resolveProperties(T[] elements) {
        return this.resolveProperties(null, (AnnotatedElement[])elements);
    }

    protected <T extends AnnotatedElement> Map<T, PropertyInfo> resolveProperties(String keyPrefix, T[] elements) {
        HashMap<T, PropertyInfo> result = new HashMap<T, PropertyInfo>();
        for (T element : elements) {
            String defaultValue;
            if (!this.shouldDecorate((AnnotatedElement)element)) continue;
            String key = this.getKey(keyPrefix, (AnnotatedElement)element);
            String stringValue = this.compiled.getProperty(key, defaultValue = this.getPropertyDefaultValue((AnnotatedElement)element));
            if (stringValue == null) {
                this.checkRequired(key, (AnnotatedElement)element);
                continue;
            }
            Object value = this.convertValue((AnnotatedElement)element, stringValue);
            result.put(element, new PropertyInfo(key, stringValue, value));
        }
        return result;
    }

    private Map<Method, PropertyInfo> resolveConfigs(Method[] methods, Set<Class> resolvedConfigs) {
        HashMap<Method, PropertyInfo> result = new HashMap<Method, PropertyInfo>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(Config.class)) continue;
            String prefix = method.getAnnotation(Config.class).prefix();
            Class<?> returnType = method.getReturnType();
            if (resolvedConfigs.contains(returnType)) {
                throw new PropertyLoaderException(String.format("Recursive configuration <%s> at <%s>", returnType, method));
            }
            resolvedConfigs.add(returnType);
            Object proxy = this.populate(prefix, returnType, resolvedConfigs);
            result.put(method, new PropertyInfo(proxy));
        }
        return result;
    }

    protected boolean shouldDecorate(AnnotatedElement element) {
        return element.isAnnotationPresent(Property.class);
    }

    protected void checkRequired(String key, AnnotatedElement element) {
        if (this.isRequired(element)) {
            throw new PropertyLoaderException(String.format("Required property <%s> for element <%s> doesn't exists", key, element));
        }
    }

    protected boolean isRequired(AnnotatedElement element) {
        return element.isAnnotationPresent(Required.class);
    }

    protected String getPropertyDefaultValue(AnnotatedElement element) {
        if (element.isAnnotationPresent(DefaultValue.class)) {
            return element.getAnnotation(DefaultValue.class).value();
        }
        return null;
    }

    protected String getKey(String prefix, AnnotatedElement element) {
        String value = element.getAnnotation(Property.class).value();
        return prefix == null ? value : String.format("%s.%s", prefix, value);
    }

    protected Object convertValue(AnnotatedElement element, String value) {
        Class<?> type = this.getValueType(element);
        Type genericType = this.getValueGenericType(element);
        try {
            if (element.isAnnotationPresent(Use.class)) {
                Converter converter = this.getConverterForElementWithUseAnnotation(element);
                return converter.convert(value);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return this.manager.convert(type, this.getCollectionElementType(genericType), value);
            }
            return this.manager.convert(type, value);
        }
        catch (Exception e) {
            throw new PropertyLoaderException(String.format("Can't convert value <%s> to type <%s> for <%s>", value, type, element), e);
        }
    }

    protected Class<?> getValueType(AnnotatedElement element) {
        if (element instanceof Field) {
            return ((Field)element).getType();
        }
        if (element instanceof Method) {
            return ((Method)element).getReturnType();
        }
        throw new PropertyLoaderException(String.format("Could not get type for %s", element));
    }

    protected Type getValueGenericType(AnnotatedElement element) {
        if (element instanceof Field) {
            return ((Field)element).getGenericType();
        }
        if (element instanceof Method) {
            return ((Method)element).getGenericReturnType();
        }
        throw new PropertyLoaderException(String.format("Could not get generic type for %s", element));
    }

    protected Class<?> getCollectionElementType(Type genericType) throws ConversionException {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new ConversionException("Types with more then one generic are not supported");
            }
            Type type = typeArguments[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            throw new ConversionException(String.format("Could not resolve generic type <%s>", type));
        }
        return String.class;
    }

    protected Converter getConverterForElementWithUseAnnotation(AnnotatedElement element) {
        Class<? extends Converter> clazz = element.getAnnotation(Use.class).value();
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PropertyLoaderException(String.format("Can't instance converter <%s> for element <%s>", clazz, element), e);
        }
    }

    public <T> PropertyLoader register(Converter<T> converter, Class<T> type) {
        this.manager.register(type, converter);
        return this;
    }

    public Properties getCompiled() {
        return this.compiled;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public PropertyLoader withClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        return this;
    }

    public Properties getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Properties defaults) {
        this.defaults = defaults;
    }

    public PropertyLoader withDefaults(Properties defaults) {
        this.setDefaults(defaults);
        return this;
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public PropertyLoader withPropertyProvider(PropertyProvider propertyProvider) {
        this.setPropertyProvider(propertyProvider);
        return this;
    }

    public static PropertyLoader newInstance() {
        return new PropertyLoader();
    }
}

