/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.html.impl.jsoup.nodes;

import java.util.Arrays;
import java.util.Iterator;
import ru.noties.markwon.html.impl.jsoup.helper.Normalizer;
import ru.noties.markwon.html.impl.jsoup.helper.Validate;
import ru.noties.markwon.html.impl.jsoup.nodes.Attribute;

public class Attributes
implements Iterable<Attribute>,
Cloneable {
    private static final int InitialCapacity = 4;
    private static final int GrowthFactor = 2;
    private static final String[] Empty = new String[0];
    static final int NotFound = -1;
    private static final String EmptyString = "";
    private int size = 0;
    String[] keys = Empty;
    String[] vals = Empty;

    private void checkCapacity(int minNewSize) {
        int newSize;
        Validate.isTrue(minNewSize >= this.size);
        int curSize = this.keys.length;
        if (curSize >= minNewSize) {
            return;
        }
        int n = newSize = curSize >= 4 ? this.size * 2 : 4;
        if (minNewSize > newSize) {
            newSize = minNewSize;
        }
        this.keys = Attributes.copyOf(this.keys, newSize);
        this.vals = Attributes.copyOf(this.vals, newSize);
    }

    private static String[] copyOf(String[] orig, int size) {
        String[] copy = new String[size];
        System.arraycopy(orig, 0, copy, 0, Math.min(orig.length, size));
        return copy;
    }

    int indexOfKey(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfKeyIgnoreCase(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    static String checkNotNull(String val) {
        return val == null ? EmptyString : val;
    }

    public String get(String key) {
        int i = this.indexOfKey(key);
        return i == -1 ? EmptyString : Attributes.checkNotNull(this.vals[i]);
    }

    public String getIgnoreCase(String key) {
        int i = this.indexOfKeyIgnoreCase(key);
        return i == -1 ? EmptyString : Attributes.checkNotNull(this.vals[i]);
    }

    private void add(String key, String value) {
        this.checkCapacity(this.size + 1);
        this.keys[this.size] = key;
        this.vals[this.size] = value;
        ++this.size;
    }

    public Attributes put(String key, String value) {
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.vals[i] = value;
        } else {
            this.add(key, value);
        }
        return this;
    }

    void putIgnoreCase(String key, String value) {
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.vals[i] = value;
            if (!this.keys[i].equals(key)) {
                this.keys[i] = key;
            }
        } else {
            this.add(key, value);
        }
    }

    public Attributes put(String key, boolean value) {
        if (value) {
            this.putIgnoreCase(key, null);
        } else {
            this.remove(key);
        }
        return this;
    }

    public Attributes put(Attribute attribute) {
        Validate.notNull(attribute);
        this.put(attribute.getKey(), attribute.getValue());
        attribute.parent = this;
        return this;
    }

    private void remove(int index) {
        Validate.isFalse(index >= this.size);
        int shifted = this.size - index - 1;
        if (shifted > 0) {
            System.arraycopy(this.keys, index + 1, this.keys, index, shifted);
            System.arraycopy(this.vals, index + 1, this.vals, index, shifted);
        }
        --this.size;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    public void remove(String key) {
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.remove(i);
        }
    }

    public void removeIgnoreCase(String key) {
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.remove(i);
        }
    }

    public boolean hasKey(String key) {
        return this.indexOfKey(key) != -1;
    }

    public boolean hasKeyIgnoreCase(String key) {
        return this.indexOfKeyIgnoreCase(key) != -1;
    }

    public int size() {
        return this.size;
    }

    public void addAll(Attributes incoming) {
        if (incoming.size() == 0) {
            return;
        }
        this.checkCapacity(this.size + incoming.size);
        for (Attribute attr : incoming) {
            this.put(attr);
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Attributes.this.size;
            }

            @Override
            public Attribute next() {
                String val = Attributes.this.vals[this.i];
                Attribute attr = new Attribute(Attributes.this.keys[this.i], val == null ? Attributes.EmptyString : val, Attributes.this);
                ++this.i;
                return attr;
            }

            @Override
            public void remove() {
                Attributes.this.remove(--this.i);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        if (this.size != that.size) {
            return false;
        }
        if (!Arrays.equals(this.keys, that.keys)) {
            return false;
        }
        return Arrays.equals(this.vals, that.vals);
    }

    public int hashCode() {
        int result = this.size;
        result = 31 * result + Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.vals);
        return result;
    }

    public Attributes clone() {
        Attributes clone;
        try {
            clone = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.size = this.size;
        this.keys = Attributes.copyOf(this.keys, this.size);
        this.vals = Attributes.copyOf(this.vals, this.size);
        return clone;
    }

    public void normalize() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = Normalizer.lowerCase(this.keys[i]);
        }
    }
}

