/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import ro.pippo.core.websocket.WebSocketConnection;

public class JettyWebSocketConnection
implements WebSocketConnection {
    private final Session session;

    public JettyWebSocketConnection(Session session) {
        this.session = session;
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public void close(int code, String reason) {
        if (this.isOpen()) {
            this.session.close(code, reason);
        }
    }

    public WebSocketConnection sendMessage(String message) throws IOException {
        this.checkClosed();
        this.session.getRemote().sendString(message);
        return this;
    }

    public WebSocketConnection sendMessage(byte[] message) throws IOException {
        this.checkClosed();
        ByteBuffer buffer = ByteBuffer.wrap(message, 0, message.length);
        this.session.getRemote().sendBytes(buffer);
        return this;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public Session getSession() {
        return this.session;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed");
        }
    }
}

