/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.Named;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteTransformer;

public class NameTransformer
implements RouteTransformer {
    private static final Logger log = LoggerFactory.getLogger(NameTransformer.class);

    public Route transform(Route route) {
        Method method = (Method)route.getAttribute("__controllerMethod");
        if (method == null) {
            return route;
        }
        if (method.isAnnotationPresent(Named.class)) {
            Named named = method.getAnnotation(Named.class);
            String name = named.value();
            log.debug("Set name '{}' for route {} '{}'", new Object[]{name, route.getRequestMethod(), route.getUriPattern()});
            route.setName(name);
        }
        return route;
    }
}

