/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.ClientSideCache;
import redis.clients.jedis.CommandObject;

public class GuavaCSC
extends ClientSideCache {
    private static final HashFunction DEFAULT_HASH_FUNCTION = Hashing.fingerprint2011();
    private final Cache<Long, Object> cache;
    private final HashFunction function;

    public GuavaCSC(Cache<Long, Object> guavaCache, HashFunction hashFunction) {
        this.cache = guavaCache;
        this.function = hashFunction;
    }

    @Override
    protected final void invalidateAllCommandHashes() {
        this.cache.invalidateAll();
    }

    @Override
    protected void invalidateCommandHashes(Iterable<Long> hashes) {
        this.cache.invalidateAll(hashes);
    }

    @Override
    protected void put(long hash, Object value) {
        this.cache.put((Object)hash, value);
    }

    @Override
    protected Object get(long hash) {
        return this.cache.getIfPresent((Object)hash);
    }

    @Override
    protected final long getCommandHash(CommandObject command) {
        Hasher hasher = this.function.newHasher();
        command.getArguments().forEach(raw -> hasher.putBytes(raw.getRaw()));
        hasher.putInt(command.getBuilder().hashCode());
        return hasher.hash().asLong();
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ HashFunction access$100() {
        return DEFAULT_HASH_FUNCTION;
    }

    public static class Builder {
        private long maximumSize = 10000L;
        private long expireTime = 100L;
        private final TimeUnit expireTimeUnit = TimeUnit.SECONDS;
        private HashFunction hashFunction = GuavaCSC.access$100();

        private Builder() {
        }

        public Builder maximumSize(int size) {
            this.maximumSize = size;
            return this;
        }

        public Builder ttl(int seconds) {
            this.expireTime = seconds;
            return this;
        }

        public Builder hashFunction(HashFunction function) {
            this.hashFunction = function;
            return this;
        }

        public GuavaCSC build() {
            CacheBuilder cb = CacheBuilder.newBuilder();
            cb.maximumSize(this.maximumSize);
            cb.expireAfterWrite(this.expireTime, this.expireTimeUnit);
            return new GuavaCSC((Cache<Long, Object>)cb.build(), this.hashFunction);
        }
    }
}

