/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import net.openhft.hashing.LongHashFunction;
import redis.clients.jedis.ClientSideCache;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.args.Rawable;

public class CaffeineCSC
extends ClientSideCache {
    private static final LongHashFunction DEFAULT_HASH_FUNCTION = LongHashFunction.xx3();
    private final Cache<Long, Object> cache;
    private final LongHashFunction function;

    public CaffeineCSC(Cache<Long, Object> caffeineCache, LongHashFunction hashFunction) {
        this.cache = caffeineCache;
        this.function = hashFunction;
    }

    @Override
    protected final void invalidateAllCommandHashes() {
        this.cache.invalidateAll();
    }

    @Override
    protected void invalidateCommandHashes(Iterable<Long> hashes) {
        this.cache.invalidateAll(hashes);
    }

    @Override
    protected void put(long hash, Object value) {
        this.cache.put((Object)hash, value);
    }

    @Override
    protected Object get(long hash) {
        return this.cache.getIfPresent((Object)hash);
    }

    @Override
    protected final long getCommandHash(CommandObject command) {
        long[] nums = new long[command.getArguments().size() + 1];
        int idx = 0;
        for (Rawable raw : command.getArguments()) {
            nums[idx++] = this.function.hashBytes(raw.getRaw());
        }
        nums[idx] = this.function.hashInt(command.getBuilder().hashCode());
        return this.function.hashLongs(nums);
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ LongHashFunction access$100() {
        return DEFAULT_HASH_FUNCTION;
    }

    public static class Builder {
        private long maximumSize = 10000L;
        private long expireTime = 100L;
        private final TimeUnit expireTimeUnit = TimeUnit.SECONDS;
        private LongHashFunction hashFunction = CaffeineCSC.access$100();

        private Builder() {
        }

        public Builder maximumSize(int size) {
            this.maximumSize = size;
            return this;
        }

        public Builder ttl(int seconds) {
            this.expireTime = seconds;
            return this;
        }

        public Builder hashFunction(LongHashFunction function) {
            this.hashFunction = function;
            return this;
        }

        public CaffeineCSC build() {
            Caffeine cb = Caffeine.newBuilder();
            cb.maximumSize(this.maximumSize);
            cb.expireAfterWrite(this.expireTime, this.expireTimeUnit);
            return new CaffeineCSC((Cache<Long, Object>)cb.build(), this.hashFunction);
        }
    }
}

