/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClientSideCache;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.exceptions.JedisException;

public class JedisClientSideCache
extends Jedis {
    private final ClientSideCache cache;

    public JedisClientSideCache(HostAndPort hostPort, JedisClientConfig config) {
        this(hostPort, config, new ClientSideCache());
    }

    public JedisClientSideCache(HostAndPort hostPort, JedisClientConfig config, ClientSideCache cache) {
        super(hostPort, config);
        if (config.getRedisProtocol() != RedisProtocol.RESP3) {
            throw new JedisException("Client side caching is only supported with RESP3.");
        }
        this.cache = cache;
        this.connection.setClientSideCache(cache);
        this.clientTrackingOn();
    }

    private void clientTrackingOn() {
        String reply = this.connection.executeCommand(new CommandObject<String>(new CommandArguments(Protocol.Command.CLIENT).add("TRACKING").add("ON").add("BCAST"), BuilderFactory.STRING));
        if (!"OK".equals(reply)) {
            throw new JedisException("Could not enable client tracking. Reply: " + reply);
        }
    }

    @Override
    public String get(String key) {
        this.connection.readPushesWithCheckingBroken();
        String cachedValue = (String)this.cache.getValue(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        String value = super.get(key);
        if (value != null) {
            this.cache.setKey(key, value);
        }
        return value;
    }
}

