/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.params.Params;
import redis.clients.jedis.util.SafeEncoder;

public class GetExParams
extends Params
implements IParams {
    private static final String PX = "px";
    private static final String EX = "ex";
    private static final String EXAT = "exat";
    private static final String PXAT = "pxat";
    private static final String PERSIST = "persist";

    public static GetExParams getExParams() {
        return new GetExParams();
    }

    public GetExParams ex(long secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public GetExParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public GetExParams exAt(long seconds) {
        this.addParam(EXAT, seconds);
        return this;
    }

    public GetExParams pxAt(long milliseconds) {
        this.addParam(PXAT, milliseconds);
        return this;
    }

    public GetExParams persist() {
        this.addParam(PERSIST);
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.contains(EX)) {
            args.add(SafeEncoder.encode(EX));
            args.add(Protocol.toByteArray((Long)this.getParam(EX)));
        } else if (this.contains(PX)) {
            args.add(SafeEncoder.encode(PX));
            args.add(Protocol.toByteArray((Long)this.getParam(PX)));
        } else if (this.contains(EXAT)) {
            args.add(SafeEncoder.encode(EXAT));
            args.add(Protocol.toByteArray((Long)this.getParam(EXAT)));
        } else if (this.contains(PXAT)) {
            args.add(SafeEncoder.encode(PXAT));
            args.add(Protocol.toByteArray((Long)this.getParam(PXAT)));
        } else if (this.contains(PERSIST)) {
            args.add(SafeEncoder.encode(PERSIST));
        }
    }
}

