/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.params.IParams;

public class GeoSearchParam
implements IParams {
    private boolean fromMember = false;
    private boolean fromLonLat = false;
    private String member;
    private GeoCoordinate coord;
    private boolean byRadius = false;
    private boolean byBox = false;
    private double radius;
    private double width;
    private double height;
    private GeoUnit unit;
    private boolean withCoord = false;
    private boolean withDist = false;
    private boolean withHash = false;
    private Integer count = null;
    private boolean any = false;
    private boolean asc = false;
    private boolean desc = false;

    public static GeoSearchParam geoSearchParam() {
        return new GeoSearchParam();
    }

    public GeoSearchParam fromMember(String member) {
        this.fromMember = true;
        this.member = member;
        return this;
    }

    public GeoSearchParam fromLonLat(double longitude, double latitude) {
        this.fromLonLat = true;
        this.coord = new GeoCoordinate(longitude, latitude);
        return this;
    }

    public GeoSearchParam fromLonLat(GeoCoordinate coord) {
        this.fromLonLat = true;
        this.coord = coord;
        return this;
    }

    public GeoSearchParam byRadius(double radius, GeoUnit unit) {
        this.byRadius = true;
        this.radius = radius;
        this.unit = unit;
        return this;
    }

    public GeoSearchParam byBox(double width, double height, GeoUnit unit) {
        this.byBox = true;
        this.width = width;
        this.height = height;
        this.unit = unit;
        return this;
    }

    public GeoSearchParam withCoord() {
        this.withCoord = true;
        return this;
    }

    public GeoSearchParam withDist() {
        this.withDist = true;
        return this;
    }

    public GeoSearchParam withHash() {
        this.withHash = true;
        return this;
    }

    public GeoSearchParam asc() {
        this.asc = true;
        return this;
    }

    public GeoSearchParam desc() {
        this.desc = true;
        return this;
    }

    public GeoSearchParam count(int count) {
        return this.count(count, false);
    }

    public GeoSearchParam count(int count, boolean any) {
        if (count > 0) {
            this.count = count;
            if (any) {
                this.any = true;
            }
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.fromMember) {
            args.add(Protocol.Keyword.FROMMEMBER);
            args.add(this.member);
        } else if (this.fromLonLat) {
            args.add(Protocol.Keyword.FROMLONLAT);
            args.add(this.coord.getLongitude());
            args.add(this.coord.getLatitude());
        }
        if (this.byRadius) {
            args.add(Protocol.Keyword.BYRADIUS);
            args.add(this.radius);
        } else if (this.byBox) {
            args.add(Protocol.Keyword.BYBOX);
            args.add(this.width);
            args.add(this.height);
        }
        args.add(this.unit);
        if (this.withCoord) {
            args.add(Protocol.Keyword.WITHCOORD);
        }
        if (this.withDist) {
            args.add(Protocol.Keyword.WITHDIST);
        }
        if (this.withHash) {
            args.add(Protocol.Keyword.WITHHASH);
        }
        if (this.count != null) {
            args.add(Protocol.Keyword.COUNT).add(this.count);
            if (this.any) {
                args.add(Protocol.Keyword.ANY);
            }
        }
        if (this.asc) {
            args.add(Protocol.Keyword.ASC);
        } else if (this.desc) {
            args.add(Protocol.Keyword.DESC);
        }
    }
}

