/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import java.util.Collections;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.timeseries.TimeSeriesProtocol;

public class TSAlterParams
implements IParams {
    private Long retentionTime;
    private Map<String, String> labels;

    public static TSAlterParams alterParams() {
        return new TSAlterParams();
    }

    public TSAlterParams retentionTime(long retentionTime) {
        this.retentionTime = retentionTime;
        return this;
    }

    public TSAlterParams labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public TSAlterParams labelsReset() {
        return this.labels(Collections.emptyMap());
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.retentionTime == null && this.labels == null) {
            throw new JedisException("Either RETENTION or LABELS must be set.");
        }
        if (this.retentionTime != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.RETENTION).add(Protocol.toByteArray(this.retentionTime));
        }
        if (this.labels != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.LABELS);
            this.labels.entrySet().forEach(entry -> args.add(entry.getKey()).add(entry.getValue()));
        }
    }
}

