/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.List;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisException;

public class ReliableTransactionBase
extends Queable
implements Closeable {
    private boolean inTransaction = true;
    protected final Connection connection;

    public ReliableTransactionBase(Connection connection) {
        this.connection = connection;
        this.executeMulti();
    }

    private void executeMulti() {
        this.connection.sendCommand(Protocol.Command.MULTI);
        String status = this.connection.getStatusCodeReply();
        if (!"OK".equals(status)) {
            throw new JedisException("MULTI command failed. Received response: " + status);
        }
    }

    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        String status = this.connection.getStatusCodeReply();
        if (!"QUEUED".equals(status)) {
            throw new JedisException(status);
        }
        return this.enqueResponse(commandObject.getBuilder());
    }

    @Override
    public void close() {
        this.clear();
    }

    public void clear() {
        if (this.inTransaction) {
            this.discard();
        }
    }

    public final void exec() {
        this.connection.sendCommand(Protocol.Command.EXEC);
        this.inTransaction = false;
        List<Object> unformatted = this.connection.getObjectMultiBulkReply();
        unformatted.stream().forEachOrdered(u -> this.generateResponse(u));
    }

    public void discard() {
        this.connection.sendCommand(Protocol.Command.DISCARD);
        String status = this.connection.getStatusCodeReply();
        this.inTransaction = false;
        this.clean();
        if (!"OK".equals(status)) {
            throw new JedisException("DISCARD command failed. Received response: " + status);
        }
    }
}

