/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.Pool;

public class JedisConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(JedisConnectionFactory.class);
    private final Pool<Connection> memberOf;
    private HostAndPort hostAndPort;
    private JedisClientConfig clientConfig;
    private final JedisSocketFactory factory;

    public JedisConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new DefaultJedisSocketFactory(hostAndPort, clientConfig));
        this.hostAndPort = hostAndPort;
        this.clientConfig = clientConfig;
    }

    public JedisConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig, Pool<Connection> memberOf) {
        this(new DefaultJedisSocketFactory(hostAndPort, clientConfig), memberOf);
        this.hostAndPort = hostAndPort;
        this.clientConfig = clientConfig;
    }

    public JedisConnectionFactory(JedisSocketFactory factory) {
        this.factory = factory;
        this.memberOf = null;
    }

    public JedisConnectionFactory(JedisSocketFactory factory, Pool<Connection> memberOf) {
        this.factory = factory;
        this.memberOf = memberOf;
    }

    public void setHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
        if (this.factory instanceof DefaultJedisSocketFactory) {
            ((DefaultJedisSocketFactory)this.factory).updateHostAndPort(hostAndPort);
        }
    }

    public void setPassword(String password) {
        this.clientConfig.updatePassword(password);
    }

    public void activateObject(PooledObject<Connection> pooledJedis) throws Exception {
    }

    public void destroyObject(PooledObject<Connection> pooledJedis) throws Exception {
        Connection jedis = (Connection)pooledJedis.getObject();
        if (jedis.isConnected()) {
            try {
                if (!jedis.isBroken()) {
                    jedis.quit();
                }
            }
            catch (Exception e) {
                logger.warn("Error while QUIT", (Throwable)e);
            }
            try {
                jedis.disconnect();
            }
            catch (Exception e) {
                logger.warn("Error while close", (Throwable)e);
            }
        }
    }

    public PooledObject<Connection> makeObject() throws Exception {
        Connection jedis = null;
        try {
            jedis = new Connection(this.factory, this.clientConfig, this.memberOf);
            jedis.connect();
            return new DefaultPooledObject((Object)jedis);
        }
        catch (JedisException je) {
            if (jedis != null) {
                try {
                    jedis.quit();
                }
                catch (Exception e) {
                    logger.warn("Error while QUIT", (Throwable)e);
                }
                try {
                    jedis.disconnect();
                }
                catch (Exception e) {
                    logger.warn("Error while close", (Throwable)e);
                }
            }
            throw je;
        }
    }

    public void passivateObject(PooledObject<Connection> pooledJedis) throws Exception {
    }

    public boolean validateObject(PooledObject<Connection> pooledJedis) {
        Connection jedis = (Connection)pooledJedis.getObject();
        try {
            jedis.ping();
            return true;
        }
        catch (Exception e) {
            logger.error("Error while validating pooled Jedis object.", (Throwable)e);
            return false;
        }
    }
}

