/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class SearchProtocol {

    public static enum SearchKeyword implements Rawable
    {
        SCHEMA,
        VERBATIM,
        NOCONTENT,
        NOSTOPWORDS,
        WITHSCORES,
        WITHPAYLOADS,
        LANGUAGE,
        INFIELDS,
        SORTBY,
        ASC,
        DESC,
        PAYLOAD,
        LIMIT,
        HIGHLIGHT,
        FIELDS,
        TAGS,
        SUMMARIZE,
        FRAGS,
        LEN,
        SEPARATOR,
        INKEYS,
        RETURN,
        FILTER,
        GEOFILTER,
        INCR,
        MAX,
        FUZZY,
        DD,
        DEL,
        READ,
        COUNT,
        ADD,
        TEMPORARY,
        STOPWORDS,
        NOFREQS,
        NOFIELDS,
        NOOFFSETS,
        SET,
        GET,
        ON,
        ASYNC,
        PREFIX,
        LANGUAGE_FIELD,
        SCORE_FIELD,
        SCORE,
        PAYLOAD_FIELD,
        SCORER;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum SearchCommand implements ProtocolCommand
    {
        CREATE("FT.CREATE"),
        ALTER("FT.ALTER"),
        INFO("FT.INFO"),
        SEARCH("FT.SEARCH"),
        EXPLAIN("FT.EXPLAIN"),
        EXPLAINCLI("FT.EXPLAINCLI"),
        AGGREGATE("FT.AGGREGATE"),
        CURSOR("FT.CURSOR"),
        CONFIG("FT.CONFIG"),
        ALIASADD("FT.ALIASADD"),
        ALIASUPDATE("FT.ALIASUPDATE"),
        ALIASDEL("FT.ALIASDEL"),
        SYNUPDATE("FT.SYNUPDATE"),
        SYNDUMP("FT.SYNDUMP"),
        DROPINDEX("FT.DROPINDEX");

        private final byte[] raw;

        private SearchCommand(String alt) {
            this.raw = SafeEncoder.encode(alt);
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }
}

