/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.BinaryRedisPipeline;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.RedisPipeline;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

public abstract class PipelineBase
extends Queable
implements BinaryRedisPipeline,
RedisPipeline {
    protected abstract Client getClient(String var1);

    protected abstract Client getClient(byte[] var1);

    @Override
    public Response<Long> append(String key, String value) {
        this.getClient(key).append(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> append(byte[] key, byte[] value) {
        this.getClient(key).append(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> blpop(String key) {
        String[] temp = new String[]{key};
        this.getClient(key).blpop(temp);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<String>> brpop(String key) {
        String[] temp = new String[]{key};
        this.getClient(key).brpop(temp);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> blpop(byte[] key) {
        byte[][] temp = new byte[][]{key};
        this.getClient(key).blpop(temp);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<List<byte[]>> brpop(byte[] key) {
        byte[][] temp = new byte[][]{key};
        this.getClient(key).brpop(temp);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> decr(String key) {
        this.getClient(key).decr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> decr(byte[] key) {
        this.getClient(key).decr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> decrBy(String key, long decrement) {
        this.getClient(key).decrBy(key, decrement);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> decrBy(byte[] key, long decrement) {
        this.getClient(key).decrBy(key, decrement);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> del(String key) {
        this.getClient(key).del(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> del(byte[] key) {
        this.getClient(key).del(new byte[][]{key});
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> unlink(String key) {
        this.getClient(key).unlink(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> unlink(byte[] key) {
        this.getClient(key).unlink(new byte[][]{key});
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> echo(String string) {
        this.getClient(string).echo(string);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> echo(byte[] string) {
        this.getClient(string).echo(string);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Boolean> exists(String key) {
        this.getClient(key).exists(key);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> exists(byte[] key) {
        this.getClient(key).exists(new byte[][]{key});
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Long> expire(String key, int seconds) {
        this.getClient(key).expire(key, seconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> expire(byte[] key, int seconds) {
        this.getClient(key).expire(key, seconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> expireAt(String key, long unixTime) {
        this.getClient(key).expireAt(key, unixTime);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> expireAt(byte[] key, long unixTime) {
        this.getClient(key).expireAt(key, unixTime);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> get(String key) {
        this.getClient(key).get(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> get(byte[] key) {
        this.getClient(key).get(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Boolean> getbit(String key, long offset) {
        this.getClient(key).getbit(key, offset);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> getbit(byte[] key, long offset) {
        this.getClient(key).getbit(key, offset);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Long> bitpos(String key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    @Override
    public Response<Long> bitpos(String key, boolean value, BitPosParams params) {
        this.getClient(key).bitpos(key, value, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitpos(byte[] key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    @Override
    public Response<Long> bitpos(byte[] key, boolean value, BitPosParams params) {
        this.getClient(key).bitpos(key, value, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> getrange(String key, long startOffset, long endOffset) {
        this.getClient(key).getrange(key, startOffset, endOffset);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> getSet(String key, String value) {
        this.getClient(key).getSet(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> getSet(byte[] key, byte[] value) {
        this.getClient(key).getSet(key, value);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<byte[]> getrange(byte[] key, long startOffset, long endOffset) {
        this.getClient(key).getrange(key, startOffset, endOffset);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> hdel(String key, String ... field) {
        this.getClient(key).hdel(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hdel(byte[] key, byte[] ... field) {
        this.getClient(key).hdel(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Boolean> hexists(String key, String field) {
        this.getClient(key).hexists(key, field);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> hexists(byte[] key, byte[] field) {
        this.getClient(key).hexists(key, field);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<String> hget(String key, String field) {
        this.getClient(key).hget(key, field);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> hget(byte[] key, byte[] field) {
        this.getClient(key).hget(key, field);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Map<String, String>> hgetAll(String key) {
        this.getClient(key).hgetAll(key);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    @Override
    public Response<Map<byte[], byte[]>> hgetAll(byte[] key) {
        this.getClient(key).hgetAll(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_MAP);
    }

    @Override
    public Response<Long> hincrBy(String key, String field, long value) {
        this.getClient(key).hincrBy(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        this.getClient(key).hincrBy(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> hkeys(String key) {
        this.getClient(key).hkeys(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> hkeys(byte[] key) {
        this.getClient(key).hkeys(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> hlen(String key) {
        this.getClient(key).hlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hlen(byte[] key) {
        this.getClient(key).hlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> hmget(String key, String ... fields) {
        this.getClient(key).hmget(key, fields);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> hmget(byte[] key, byte[] ... fields) {
        this.getClient(key).hmget(key, fields);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<String> hmset(String key, Map<String, String> hash) {
        this.getClient(key).hmset(key, hash);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.getClient(key).hmset(key, hash);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> hset(String key, String field, String value) {
        this.getClient(key).hset(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        this.getClient(key).hset(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hset(String key, Map<String, String> hash) {
        this.getClient(key).hset(key, hash);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hset(byte[] key, Map<byte[], byte[]> hash) {
        this.getClient(key).hset(key, hash);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hsetnx(String key, String field, String value) {
        this.getClient(key).hsetnx(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        this.getClient(key).hsetnx(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> hvals(String key) {
        this.getClient(key).hvals(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> hvals(byte[] key) {
        this.getClient(key).hvals(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> incr(String key) {
        this.getClient(key).incr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> incr(byte[] key) {
        this.getClient(key).incr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> incrBy(String key, long increment) {
        this.getClient(key).incrBy(key, increment);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> incrBy(byte[] key, long increment) {
        this.getClient(key).incrBy(key, increment);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> lindex(String key, long index) {
        this.getClient(key).lindex(key, index);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> lindex(byte[] key, long index) {
        this.getClient(key).lindex(key, index);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> linsert(String key, ListPosition where, String pivot, String value) {
        this.getClient(key).linsert(key, where, pivot, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        this.getClient(key).linsert(key, where, pivot, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> llen(String key) {
        this.getClient(key).llen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> llen(byte[] key) {
        this.getClient(key).llen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> lpop(String key) {
        this.getClient(key).lpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> lpop(byte[] key) {
        this.getClient(key).lpop(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> lpush(String key, String ... string) {
        this.getClient(key).lpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lpush(byte[] key, byte[] ... string) {
        this.getClient(key).lpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lpushx(String key, String ... string) {
        this.getClient(key).lpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lpushx(byte[] key, byte[] ... bytes) {
        this.getClient(key).lpushx(key, bytes);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<String>> lrange(String key, long start, long stop) {
        this.getClient(key).lrange(key, start, stop);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> lrange(byte[] key, long start, long stop) {
        this.getClient(key).lrange(key, start, stop);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> lrem(String key, long count, String value) {
        this.getClient(key).lrem(key, count, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        this.getClient(key).lrem(key, count, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> lset(String key, long index, String value) {
        this.getClient(key).lset(key, index, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> lset(byte[] key, long index, byte[] value) {
        this.getClient(key).lset(key, index, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> ltrim(String key, long start, long stop) {
        this.getClient(key).ltrim(key, start, stop);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> ltrim(byte[] key, long start, long stop) {
        this.getClient(key).ltrim(key, start, stop);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> move(String key, int dbIndex) {
        this.getClient(key).move(key, dbIndex);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> move(byte[] key, int dbIndex) {
        this.getClient(key).move(key, dbIndex);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> persist(String key) {
        this.getClient(key).persist(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> persist(byte[] key) {
        this.getClient(key).persist(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> rpop(String key) {
        this.getClient(key).rpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> rpop(byte[] key) {
        this.getClient(key).rpop(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> rpush(String key, String ... string) {
        this.getClient(key).rpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> rpush(byte[] key, byte[] ... string) {
        this.getClient(key).rpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> rpushx(String key, String ... string) {
        this.getClient(key).rpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> rpushx(byte[] key, byte[] ... string) {
        this.getClient(key).rpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sadd(String key, String ... member) {
        this.getClient(key).sadd(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sadd(byte[] key, byte[] ... member) {
        this.getClient(key).sadd(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> scard(String key) {
        this.getClient(key).scard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> scard(byte[] key) {
        this.getClient(key).scard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> set(String key, String value) {
        this.getClient(key).set(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> set(byte[] key, byte[] value) {
        this.getClient(key).set(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> set(String key, String value, SetParams params) {
        this.getClient(key).set(key, value, params);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> set(byte[] key, byte[] value, SetParams params) {
        this.getClient(key).set(key, value, params);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Boolean> setbit(String key, long offset, boolean value) {
        this.getClient(key).setbit(key, offset, value);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> setbit(byte[] key, long offset, byte[] value) {
        this.getClient(key).setbit(key, offset, value);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<String> setex(String key, int seconds, String value) {
        this.getClient(key).setex(key, seconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        this.getClient(key).setex(key, seconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> setnx(String key, String value) {
        this.getClient(key).setnx(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> setnx(byte[] key, byte[] value) {
        this.getClient(key).setnx(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> setrange(String key, long offset, String value) {
        this.getClient(key).setrange(key, offset, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> setrange(byte[] key, long offset, byte[] value) {
        this.getClient(key).setrange(key, offset, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Boolean> sismember(String key, String member) {
        this.getClient(key).sismember(key, member);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Boolean> sismember(byte[] key, byte[] member) {
        this.getClient(key).sismember(key, member);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    @Override
    public Response<Set<String>> smembers(String key) {
        this.getClient(key).smembers(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> smembers(byte[] key) {
        this.getClient(key).smembers(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<List<String>> sort(String key) {
        this.getClient(key).sort(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key) {
        this.getClient(key).sort(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        this.getClient(key).sort(key, sortingParameters);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        this.getClient(key).sort(key, sortingParameters);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<String> spop(String key) {
        this.getClient(key).spop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Set<String>> spop(String key, long count) {
        this.getClient(key).spop(key, count);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<byte[]> spop(byte[] key) {
        this.getClient(key).spop(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Set<byte[]>> spop(byte[] key, long count) {
        this.getClient(key).spop(key, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<String> srandmember(String key) {
        this.getClient(key).srandmember(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<String>> srandmember(String key, int count) {
        this.getClient(key).srandmember(key, count);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<byte[]> srandmember(byte[] key) {
        this.getClient(key).srandmember(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<List<byte[]>> srandmember(byte[] key, int count) {
        this.getClient(key).srandmember(key, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> srem(String key, String ... member) {
        this.getClient(key).srem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> srem(byte[] key, byte[] ... member) {
        this.getClient(key).srem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> strlen(String key) {
        this.getClient(key).strlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> strlen(byte[] key) {
        this.getClient(key).strlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> substr(String key, int start, int end) {
        this.getClient(key).substr(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> substr(byte[] key, int start, int end) {
        this.getClient(key).substr(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> touch(String key) {
        this.getClient(key).touch(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> touch(byte[] key) {
        this.getClient(key).touch(new byte[][]{key});
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> ttl(String key) {
        this.getClient(key).ttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> ttl(byte[] key) {
        this.getClient(key).ttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> type(String key) {
        this.getClient(key).type(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> type(byte[] key) {
        this.getClient(key).type(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member) {
        this.getClient(key).zadd(key, score, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member, ZAddParams params) {
        this.getClient(key).zadd(key, score, member, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers) {
        this.getClient(key).zadd(key, scoreMembers);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        this.getClient(key).zadd(key, scoreMembers, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        this.getClient(key).zadd(key, score, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        this.getClient(key).zadd(key, score, member, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        this.getClient(key).zadd(key, scoreMembers);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        this.getClient(key).zadd(key, scoreMembers, params);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcard(String key) {
        this.getClient(key).zcard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcard(byte[] key) {
        this.getClient(key).zcard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcount(String key, double min, double max) {
        this.getClient(key).zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcount(String key, String min, String max) {
        this.getClient(key).zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcount(byte[] key, double min, double max) {
        this.getClient(key).zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zcount(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Double> zincrby(String key, double increment, String member) {
        this.getClient(key).zincrby(key, increment, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> zincrby(String key, double increment, String member, ZIncrByParams params) {
        this.getClient(key).zincrby(key, increment, member, params);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> zincrby(byte[] key, double increment, byte[] member) {
        this.getClient(key).zincrby(key, increment, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params) {
        this.getClient(key).zincrby(key, increment, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Set<String>> zrange(String key, long start, long stop) {
        this.getClient(key).zrange(key, start, stop);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrange(byte[] key, long start, long stop) {
        this.getClient(key).zrange(key, start, stop);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max) {
        this.getClient(key).zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        this.getClient(key).zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, String min, String max) {
        this.getClient(key).zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.getClient(key).zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.getClient(key).zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.getClient(key).zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.getClient(key).zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.getClient(key).zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min) {
        this.getClient(key).zrevrangeByScore(key, max, min);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        this.getClient(key).zrevrangeByScore(key, max, min);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, String max, String min) {
        this.getClient(key).zrevrangeByScore(key, max, min);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.getClient(key).zrevrangeByScore(key, max, min);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.getClient(key).zrevrangeByScore(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.getClient(key).zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(String key, long start, long stop) {
        this.getClient(key).zrangeWithScores(key, start, stop);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(byte[] key, long start, long stop) {
        this.getClient(key).zrangeWithScores(key, start, stop);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Long> zrank(String key, String member) {
        this.getClient(key).zrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrank(byte[] key, byte[] member) {
        this.getClient(key).zrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrem(String key, String ... members) {
        this.getClient(key).zrem(key, members);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrem(byte[] key, byte[] ... members) {
        this.getClient(key).zrem(key, members);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByRank(String key, long start, long stop) {
        this.getClient(key).zremrangeByRank(key, start, stop);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByRank(byte[] key, long start, long stop) {
        this.getClient(key).zremrangeByRank(key, start, stop);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByScore(String key, double min, double max) {
        this.getClient(key).zremrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByScore(String key, String min, String max) {
        this.getClient(key).zremrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, double min, double max) {
        this.getClient(key).zremrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zremrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> zrevrange(String key, long start, long stop) {
        this.getClient(key).zrevrange(key, start, stop);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrange(byte[] key, long start, long stop) {
        this.getClient(key).zrevrange(key, start, stop);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(String key, long start, long stop) {
        this.getClient(key).zrevrangeWithScores(key, start, stop);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, long start, long stop) {
        this.getClient(key).zrevrangeWithScores(key, start, stop);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    @Override
    public Response<Long> zrevrank(String key, String member) {
        this.getClient(key).zrevrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zrevrank(byte[] key, byte[] member) {
        this.getClient(key).zrevrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Double> zscore(String key, String member) {
        this.getClient(key).zscore(key, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> zscore(byte[] key, byte[] member) {
        this.getClient(key).zscore(key, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Long> zlexcount(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zlexcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zlexcount(String key, String min, String max) {
        this.getClient(key).zlexcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max) {
        this.getClient(key).zrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.getClient(key).zrangeByLex(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        this.getClient(key).zrangeByLex(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        this.getClient(key).zrevrangeByLex(key, max, min);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min) {
        this.getClient(key).zrevrangeByLex(key, max, min);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.getClient(key).zrevrangeByLex(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        this.getClient(key).zrevrangeByLex(key, max, min, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    @Override
    public Response<Long> zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.getClient(key).zremrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zremrangeByLex(String key, String min, String max) {
        this.getClient(key).zremrangeByLex(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(String key) {
        this.getClient(key).bitcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(String key, long start, long end) {
        this.getClient(key).bitcount(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(byte[] key) {
        this.getClient(key).bitcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitcount(byte[] key, long start, long end) {
        this.getClient(key).bitcount(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<byte[]> dump(String key) {
        this.getClient(key).dump(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<byte[]> dump(byte[] key) {
        this.getClient(key).dump(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<String> migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.getClient(key).migrate(host, port, key, destinationDb, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        this.getClient(key).migrate(host, port, key, destinationDb, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> objectRefcount(String key) {
        this.getClient(key).objectRefcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> objectRefcount(byte[] key) {
        this.getClient(key).objectRefcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> objectEncoding(String key) {
        this.getClient(key).objectEncoding(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> objectEncoding(byte[] key) {
        this.getClient(key).objectEncoding(key);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> objectIdletime(String key) {
        this.getClient(key).objectIdletime(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> objectIdletime(byte[] key) {
        this.getClient(key).objectIdletime(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pexpire(String key, long milliseconds) {
        this.getClient(key).pexpire(key, milliseconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pexpire(byte[] key, long milliseconds) {
        this.getClient(key).pexpire(key, milliseconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        this.getClient(key).pexpireAt(key, millisecondsTimestamp);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.getClient(key).pexpireAt(key, millisecondsTimestamp);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pttl(String key) {
        this.getClient(key).pttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pttl(byte[] key) {
        this.getClient(key).pttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> restore(String key, int ttl, byte[] serializedValue) {
        this.getClient(key).restore(key, ttl, serializedValue);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> restore(byte[] key, int ttl, byte[] serializedValue) {
        this.getClient(key).restore(key, ttl, serializedValue);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> restoreReplace(String key, int ttl, byte[] serializedValue) {
        this.getClient(key).restoreReplace(key, ttl, serializedValue);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        this.getClient(key).restoreReplace(key, ttl, serializedValue);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Double> incrByFloat(String key, double increment) {
        this.getClient(key).incrByFloat(key, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> incrByFloat(byte[] key, double increment) {
        this.getClient(key).incrByFloat(key, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<String> psetex(String key, long milliseconds, String value) {
        this.getClient(key).psetex(key, milliseconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> psetex(byte[] key, long milliseconds, byte[] value) {
        this.getClient(key).psetex(key, milliseconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Double> hincrByFloat(String key, String field, double increment) {
        this.getClient(key).hincrByFloat(key, field, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> hincrByFloat(byte[] key, byte[] field, double increment) {
        this.getClient(key).hincrByFloat(key, field, increment);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Long> pfadd(byte[] key, byte[] ... elements) {
        this.getClient(key).pfadd(key, elements);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfcount(byte[] key) {
        this.getClient(key).pfcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfadd(String key, String ... elements) {
        this.getClient(key).pfadd(key, elements);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfcount(String key) {
        this.getClient(key).pfcount(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.getClient(key).geoadd(key, longitude, latitude, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.getClient(key).geoadd(key, memberCoordinateMap);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> geoadd(String key, double longitude, double latitude, String member) {
        this.getClient(key).geoadd(key, longitude, latitude, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.getClient(key).geoadd(key, memberCoordinateMap);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2) {
        this.getClient(key).geodist(key, member1, member2);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        this.getClient(key).geodist(key, member1, member2, unit);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2) {
        this.getClient(key).geodist(key, member1, member2);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2, GeoUnit unit) {
        this.getClient(key).geodist(key, member1, member2);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    @Override
    public Response<List<byte[]>> geohash(byte[] key, byte[] ... members) {
        this.getClient(key).geohash(key, members);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<List<String>> geohash(String key, String ... members) {
        this.getClient(key).geohash(key, members);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(byte[] key, byte[] ... members) {
        this.getClient(key).geopos(key, members);
        return this.getResponse(BuilderFactory.GEO_COORDINATE_LIST);
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(String key, String ... members) {
        this.getClient(key).geopos(key, members);
        return this.getResponse(BuilderFactory.GEO_COORDINATE_LIST);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.getClient(key).georadius(key, longitude, latitude, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.getClient(key).georadiusReadonly(key, longitude, latitude, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadius(key, longitude, latitude, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadiusReadonly(key, longitude, latitude, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.getClient(key).georadius(key, longitude, latitude, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.getClient(key).georadiusReadonly(key, longitude, latitude, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadius(key, longitude, latitude, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadiusReadonly(key, longitude, latitude, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.getClient(key).georadiusByMember(key, member, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.getClient(key).georadiusByMemberReadonly(key, member, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadiusByMember(key, member, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadiusByMemberReadonly(key, member, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        this.getClient(key).georadiusByMember(key, member, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        this.getClient(key).georadiusByMemberReadonly(key, member, radius, unit);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadiusByMember(key, member, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.getClient(key).georadiusByMemberReadonly(key, member, radius, unit, param);
        return this.getResponse(BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    @Override
    public Response<List<Long>> bitfield(String key, String ... elements) {
        this.getClient(key).bitfield(key, elements);
        return this.getResponse(BuilderFactory.LONG_LIST);
    }

    @Override
    public Response<List<Long>> bitfield(byte[] key, byte[] ... elements) {
        this.getClient(key).bitfield(key, elements);
        return this.getResponse(BuilderFactory.LONG_LIST);
    }

    @Override
    public Response<Long> hstrlen(String key, String field) {
        this.getClient(key).hstrlen(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> hstrlen(byte[] key, byte[] field) {
        this.getClient(key).hstrlen(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<StreamEntryID> xadd(String key, StreamEntryID id, Map<String, String> hash) {
        return this.xadd(key, id, hash, Long.MAX_VALUE, true);
    }

    @Override
    public Response<byte[]> xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash) {
        return this.xadd(key, id, hash, Long.MAX_VALUE, true);
    }

    @Override
    public Response<StreamEntryID> xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        this.getClient(key).xadd(key, id, hash, maxLen, approximateLength);
        return this.getResponse(BuilderFactory.STREAM_ENTRY_ID);
    }

    @Override
    public Response<byte[]> xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash, long maxLen, boolean approximateLength) {
        this.getClient(key).xadd(key, id, hash, maxLen, approximateLength);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Long> xlen(String key) {
        this.getClient(key).xlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> xlen(byte[] key) {
        this.getClient(key).xlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<StreamEntry>> xrange(String key, StreamEntryID start, StreamEntryID end, int count) {
        this.getClient(key).xrange(key, start, end, (long)count);
        return this.getResponse(BuilderFactory.STREAM_ENTRY_LIST);
    }

    @Override
    public Response<List<byte[]>> xrange(byte[] key, byte[] start, byte[] end, int count) {
        this.getClient(key).xrange(key, start, end, (long)count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String key, StreamEntryID end, StreamEntryID start, int count) {
        this.getClient(key).xrevrange(key, start, end, count);
        return this.getResponse(BuilderFactory.STREAM_ENTRY_LIST);
    }

    @Override
    public Response<List<byte[]>> xrevrange(byte[] key, byte[] end, byte[] start, int count) {
        this.getClient(key).xrevrange(key, start, end, count);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Long> xack(String key, String group, StreamEntryID ... ids) {
        this.getClient(key).xack(key, group, ids);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> xack(byte[] key, byte[] group, byte[] ... ids) {
        this.getClient(key).xack(key, group, ids);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        this.getClient(key).xgroupCreate(key, groupname, id, makeStream);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> xgroupCreate(byte[] key, byte[] groupname, byte[] id, boolean makeStream) {
        this.getClient(key).xgroupCreate(key, groupname, id, makeStream);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> xgroupSetID(String key, String groupname, StreamEntryID id) {
        this.getClient(key).xgroupSetID(key, groupname, id);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> xgroupSetID(byte[] key, byte[] groupname, byte[] id) {
        this.getClient(key).xgroupSetID(key, groupname, id);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> xgroupDestroy(String key, String groupname) {
        this.getClient(key).xgroupDestroy(key, groupname);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> xgroupDestroy(byte[] key, byte[] groupname) {
        this.getClient(key).xgroupDestroy(key, groupname);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> xgroupDelConsumer(String key, String groupname, String consumername) {
        this.getClient(key).xgroupDelConsumer(key, groupname, consumername);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> xgroupDelConsumer(byte[] key, byte[] groupname, byte[] consumername) {
        this.getClient(key).xgroupDelConsumer(key, groupname, consumername);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<StreamPendingEntry>> xpending(String key, String groupname, StreamEntryID start, StreamEntryID end, int count, String consumername) {
        this.getClient(key).xpending(key, groupname, start, end, count, consumername);
        return this.getResponse(BuilderFactory.STREAM_PENDING_ENTRY_LIST);
    }

    @Override
    public Response<List<StreamPendingEntry>> xpending(byte[] key, byte[] groupname, byte[] start, byte[] end, int count, byte[] consumername) {
        this.getClient(key).xpending(key, groupname, start, end, count, consumername);
        return this.getResponse(BuilderFactory.STREAM_PENDING_ENTRY_LIST);
    }

    @Override
    public Response<Long> xdel(String key, StreamEntryID ... ids) {
        this.getClient(key).xdel(key, ids);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> xdel(byte[] key, byte[] ... ids) {
        this.getClient(key).xdel(key, ids);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> xtrim(String key, long maxLen, boolean approximateLength) {
        this.getClient(key).xtrim(key, maxLen, approximateLength);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> xtrim(byte[] key, long maxLen, boolean approximateLength) {
        this.getClient(key).xtrim(key, maxLen, approximateLength);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<List<StreamEntry>> xclaim(String key, String group, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        this.getClient(key).xclaim(key, group, consumername, minIdleTime, newIdleTime, retries, force, ids);
        return this.getResponse(BuilderFactory.STREAM_ENTRY_LIST);
    }

    @Override
    public Response<List<byte[]>> xclaim(byte[] key, byte[] group, byte[] consumername, long minIdleTime, long newIdleTime, int retries, boolean force, byte[] ... ids) {
        this.getClient(key).xclaim(key, group, consumername, minIdleTime, newIdleTime, retries, force, ids);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<Object> sendCommand(ProtocolCommand cmd, String ... args) {
        String key = args.length > 0 ? args[0] : cmd.toString();
        this.getClient(key).sendCommand(cmd, args);
        return this.getResponse(BuilderFactory.OBJECT);
    }

    @Override
    public Response<Object> sendCommand(ProtocolCommand cmd, byte[] ... args) {
        byte[] key = args.length > 0 ? args[0] : cmd.getRaw();
        this.getClient(key).sendCommand(cmd, args);
        return this.getResponse(BuilderFactory.OBJECT);
    }
}

