/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.SafeEncoder;

public class BinaryClient
extends Connection {
    private boolean isInMulti;
    private String password;
    private long db;
    private boolean isInWatch;

    public BinaryClient() {
    }

    public BinaryClient(String host) {
        super(host);
    }

    public BinaryClient(String host, int port) {
        super(host, port);
    }

    public BinaryClient(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public BinaryClient(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public boolean isInWatch() {
        return this.isInWatch;
    }

    private byte[][] joinParameters(byte[] first, byte[][] rest) {
        byte[][] result = new byte[rest.length + 1][];
        result[0] = first;
        System.arraycopy(rest, 0, result, 1, rest.length);
        return result;
    }

    private byte[][] joinParameters(byte[] first, byte[] second, byte[][] rest) {
        byte[][] result = new byte[rest.length + 2][];
        result[0] = first;
        result[1] = second;
        System.arraycopy(rest, 0, result, 2, rest.length);
        return result;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDb(long db) {
        this.db = db;
    }

    @Override
    public void connect() {
        if (!this.isConnected()) {
            super.connect();
            if (this.password != null) {
                this.auth(this.password);
                this.getStatusCodeReply();
            }
            if (this.db > 0L) {
                this.select((int)this.db);
                this.getStatusCodeReply();
            }
        }
    }

    public void ping() {
        this.sendCommand(Protocol.Command.PING);
    }

    public void ping(byte[] message) {
        this.sendCommand(Protocol.Command.PING, new byte[][]{message});
    }

    public void set(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.SET, key, value);
    }

    public void set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        this.sendCommand(Protocol.Command.SET, key, value, nxxx, expx, Protocol.toByteArray(time));
    }

    public void set(byte[] key, byte[] value, byte[] expx, long time) {
        this.sendCommand(Protocol.Command.SET, key, value, expx, Protocol.toByteArray(time));
    }

    public void get(byte[] key) {
        this.sendCommand(Protocol.Command.GET, new byte[][]{key});
    }

    public void quit() {
        this.db = 0L;
        this.sendCommand(Protocol.Command.QUIT);
    }

    public void exists(byte[] ... key) {
        this.sendCommand(Protocol.Command.EXISTS, key);
    }

    public void del(byte[] ... keys) {
        this.sendCommand(Protocol.Command.DEL, keys);
    }

    public void unlink(byte[] ... keys) {
        this.sendCommand(Protocol.Command.UNLINK, keys);
    }

    public void type(byte[] key) {
        this.sendCommand(Protocol.Command.TYPE, new byte[][]{key});
    }

    public void flushDB() {
        this.sendCommand(Protocol.Command.FLUSHDB);
    }

    public void keys(byte[] pattern) {
        this.sendCommand(Protocol.Command.KEYS, new byte[][]{pattern});
    }

    public void randomKey() {
        this.sendCommand(Protocol.Command.RANDOMKEY);
    }

    public void rename(byte[] oldkey, byte[] newkey) {
        this.sendCommand(Protocol.Command.RENAME, oldkey, newkey);
    }

    public void renamenx(byte[] oldkey, byte[] newkey) {
        this.sendCommand(Protocol.Command.RENAMENX, oldkey, newkey);
    }

    public void dbSize() {
        this.sendCommand(Protocol.Command.DBSIZE);
    }

    public void expire(byte[] key, int seconds) {
        this.sendCommand(Protocol.Command.EXPIRE, key, Protocol.toByteArray(seconds));
    }

    public void expireAt(byte[] key, long unixTime) {
        this.sendCommand(Protocol.Command.EXPIREAT, key, Protocol.toByteArray(unixTime));
    }

    public void ttl(byte[] key) {
        this.sendCommand(Protocol.Command.TTL, new byte[][]{key});
    }

    public void touch(byte[] ... keys) {
        this.sendCommand(Protocol.Command.TOUCH, keys);
    }

    public void select(int index) {
        this.sendCommand(Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
    }

    public void swapDB(int index1, int index2) {
        this.sendCommand(Protocol.Command.SWAPDB, Protocol.toByteArray(index1), Protocol.toByteArray(index2));
    }

    public void move(byte[] key, int dbIndex) {
        this.sendCommand(Protocol.Command.MOVE, key, Protocol.toByteArray(dbIndex));
    }

    public void flushAll() {
        this.sendCommand(Protocol.Command.FLUSHALL);
    }

    public void getSet(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.GETSET, key, value);
    }

    public void mget(byte[] ... keys) {
        this.sendCommand(Protocol.Command.MGET, keys);
    }

    public void setnx(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.SETNX, key, value);
    }

    public void setex(byte[] key, int seconds, byte[] value) {
        this.sendCommand(Protocol.Command.SETEX, key, Protocol.toByteArray(seconds), value);
    }

    public void mset(byte[] ... keysvalues) {
        this.sendCommand(Protocol.Command.MSET, keysvalues);
    }

    public void msetnx(byte[] ... keysvalues) {
        this.sendCommand(Protocol.Command.MSETNX, keysvalues);
    }

    public void decrBy(byte[] key, long decrement) {
        this.sendCommand(Protocol.Command.DECRBY, key, Protocol.toByteArray(decrement));
    }

    public void decr(byte[] key) {
        this.sendCommand(Protocol.Command.DECR, new byte[][]{key});
    }

    public void incrBy(byte[] key, long increment) {
        this.sendCommand(Protocol.Command.INCRBY, key, Protocol.toByteArray(increment));
    }

    public void incrByFloat(byte[] key, double increment) {
        this.sendCommand(Protocol.Command.INCRBYFLOAT, key, Protocol.toByteArray(increment));
    }

    public void incr(byte[] key) {
        this.sendCommand(Protocol.Command.INCR, new byte[][]{key});
    }

    public void append(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.APPEND, key, value);
    }

    public void substr(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.SUBSTR, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void hset(byte[] key, byte[] field, byte[] value) {
        this.sendCommand(Protocol.Command.HSET, key, field, value);
    }

    public void hset(byte[] key, Map<byte[], byte[]> hash) {
        byte[][] params = new byte[1 + hash.size() * 2][];
        int index = 0;
        params[index++] = key;
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params[index++] = entry.getKey();
            params[index++] = entry.getValue();
        }
        this.sendCommand(Protocol.Command.HSET, params);
    }

    public void hget(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HGET, key, field);
    }

    public void hsetnx(byte[] key, byte[] field, byte[] value) {
        this.sendCommand(Protocol.Command.HSETNX, key, field, value);
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        this.sendCommand(Protocol.Command.HMSET, (byte[][])params.toArray((T[])new byte[params.size()][]));
    }

    public void hmget(byte[] key, byte[] ... fields) {
        this.sendCommand(Protocol.Command.HMGET, this.joinParameters(key, fields));
    }

    public void hincrBy(byte[] key, byte[] field, long value) {
        this.sendCommand(Protocol.Command.HINCRBY, key, field, Protocol.toByteArray(value));
    }

    public void hexists(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HEXISTS, key, field);
    }

    public void hdel(byte[] key, byte[] ... fields) {
        this.sendCommand(Protocol.Command.HDEL, this.joinParameters(key, fields));
    }

    public void hlen(byte[] key) {
        this.sendCommand(Protocol.Command.HLEN, new byte[][]{key});
    }

    public void hkeys(byte[] key) {
        this.sendCommand(Protocol.Command.HKEYS, new byte[][]{key});
    }

    public void hvals(byte[] key) {
        this.sendCommand(Protocol.Command.HVALS, new byte[][]{key});
    }

    public void hgetAll(byte[] key) {
        this.sendCommand(Protocol.Command.HGETALL, new byte[][]{key});
    }

    public void rpush(byte[] key, byte[] ... strings) {
        this.sendCommand(Protocol.Command.RPUSH, this.joinParameters(key, strings));
    }

    public void lpush(byte[] key, byte[] ... strings) {
        this.sendCommand(Protocol.Command.LPUSH, this.joinParameters(key, strings));
    }

    public void llen(byte[] key) {
        this.sendCommand(Protocol.Command.LLEN, new byte[][]{key});
    }

    public void lrange(byte[] key, long start, long stop) {
        this.sendCommand(Protocol.Command.LRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(stop));
    }

    public void ltrim(byte[] key, long start, long stop) {
        this.sendCommand(Protocol.Command.LTRIM, key, Protocol.toByteArray(start), Protocol.toByteArray(stop));
    }

    public void lindex(byte[] key, long index) {
        this.sendCommand(Protocol.Command.LINDEX, key, Protocol.toByteArray(index));
    }

    public void lset(byte[] key, long index, byte[] value) {
        this.sendCommand(Protocol.Command.LSET, key, Protocol.toByteArray(index), value);
    }

    public void lrem(byte[] key, long count, byte[] value) {
        this.sendCommand(Protocol.Command.LREM, key, Protocol.toByteArray(count), value);
    }

    public void lpop(byte[] key) {
        this.sendCommand(Protocol.Command.LPOP, new byte[][]{key});
    }

    public void rpop(byte[] key) {
        this.sendCommand(Protocol.Command.RPOP, new byte[][]{key});
    }

    public void rpoplpush(byte[] srckey, byte[] dstkey) {
        this.sendCommand(Protocol.Command.RPOPLPUSH, srckey, dstkey);
    }

    public void sadd(byte[] key, byte[] ... members) {
        this.sendCommand(Protocol.Command.SADD, this.joinParameters(key, members));
    }

    public void smembers(byte[] key) {
        this.sendCommand(Protocol.Command.SMEMBERS, new byte[][]{key});
    }

    public void srem(byte[] key, byte[] ... members) {
        this.sendCommand(Protocol.Command.SREM, this.joinParameters(key, members));
    }

    public void spop(byte[] key) {
        this.sendCommand(Protocol.Command.SPOP, new byte[][]{key});
    }

    public void spop(byte[] key, long count) {
        this.sendCommand(Protocol.Command.SPOP, key, Protocol.toByteArray(count));
    }

    public void smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.sendCommand(Protocol.Command.SMOVE, srckey, dstkey, member);
    }

    public void scard(byte[] key) {
        this.sendCommand(Protocol.Command.SCARD, new byte[][]{key});
    }

    public void sismember(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.SISMEMBER, key, member);
    }

    public void sinter(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SINTER, keys);
    }

    public void sinterstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand(Protocol.Command.SINTERSTORE, this.joinParameters(dstkey, keys));
    }

    public void sunion(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SUNION, keys);
    }

    public void sunionstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand(Protocol.Command.SUNIONSTORE, this.joinParameters(dstkey, keys));
    }

    public void sdiff(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SDIFF, keys);
    }

    public void sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand(Protocol.Command.SDIFFSTORE, this.joinParameters(dstkey, keys));
    }

    public void srandmember(byte[] key) {
        this.sendCommand(Protocol.Command.SRANDMEMBER, new byte[][]{key});
    }

    public void zadd(byte[] key, double score, byte[] member) {
        this.sendCommand(Protocol.Command.ZADD, key, Protocol.toByteArray(score), member);
    }

    public void zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        this.sendCommand(Protocol.Command.ZADD, params.getByteParams(key, Protocol.toByteArray(score), member));
    }

    public void zaddBinary(byte[] key, Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(scoreMembers.size() * 2 + 1);
        args.add(key);
        args.addAll(this.convertScoreMembersToByteArrays(scoreMembers));
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand(Protocol.Command.ZADD, argsArray);
    }

    public void zaddBinary(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        ArrayList<byte[]> args = this.convertScoreMembersToByteArrays(scoreMembers);
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand(Protocol.Command.ZADD, params.getByteParams(key, argsArray));
    }

    public void zrange(byte[] key, long start, long stop) {
        this.sendCommand(Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(stop));
    }

    public void zrem(byte[] key, byte[] ... members) {
        this.sendCommand(Protocol.Command.ZREM, this.joinParameters(key, members));
    }

    public void zincrby(byte[] key, double increment, byte[] member) {
        this.sendCommand(Protocol.Command.ZINCRBY, key, Protocol.toByteArray(increment), member);
    }

    public void zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params) {
        this.sendCommand(Protocol.Command.ZADD, params.getByteParams(key, Protocol.toByteArray(increment), member));
    }

    public void zrank(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZRANK, key, member);
    }

    public void zrevrank(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZREVRANK, key, member);
    }

    public void zrevrange(byte[] key, long start, long stop) {
        this.sendCommand(Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(stop));
    }

    public void zrangeWithScores(byte[] key, long start, long stop) {
        this.sendCommand(Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(stop), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeWithScores(byte[] key, long start, long stop) {
        this.sendCommand(Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(stop), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zcard(byte[] key) {
        this.sendCommand(Protocol.Command.ZCARD, new byte[][]{key});
    }

    public void zscore(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZSCORE, key, member);
    }

    public void multi() {
        this.sendCommand(Protocol.Command.MULTI);
        this.isInMulti = true;
    }

    public void discard() {
        this.sendCommand(Protocol.Command.DISCARD);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void exec() {
        this.sendCommand(Protocol.Command.EXEC);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void watch(byte[] ... keys) {
        this.sendCommand(Protocol.Command.WATCH, keys);
        this.isInWatch = true;
    }

    public void unwatch() {
        this.sendCommand(Protocol.Command.UNWATCH);
        this.isInWatch = false;
    }

    public void sort(byte[] key) {
        this.sendCommand(Protocol.Command.SORT, new byte[][]{key});
    }

    public void sort(byte[] key, SortingParams sortingParameters) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        this.sendCommand(Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void blpop(byte[][] args) {
        this.sendCommand(Protocol.Command.BLPOP, args);
    }

    public void blpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.blpop((byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add(Protocol.Keyword.STORE.raw);
        args.add(dstkey);
        this.sendCommand(Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, byte[] dstkey) {
        this.sendCommand(Protocol.Command.SORT, key, Protocol.Keyword.STORE.raw, dstkey);
    }

    public void brpop(byte[][] args) {
        this.sendCommand(Protocol.Command.BRPOP, args);
    }

    public void brpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray(timeout));
        this.brpop((byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void auth(String password) {
        this.setPassword(password);
        this.sendCommand(Protocol.Command.AUTH, password);
    }

    public void subscribe(byte[] ... channels) {
        this.sendCommand(Protocol.Command.SUBSCRIBE, channels);
    }

    public void publish(byte[] channel, byte[] message) {
        this.sendCommand(Protocol.Command.PUBLISH, channel, message);
    }

    public void unsubscribe() {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE);
    }

    public void unsubscribe(byte[] ... channels) {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE, channels);
    }

    public void psubscribe(byte[] ... patterns) {
        this.sendCommand(Protocol.Command.PSUBSCRIBE, patterns);
    }

    public void punsubscribe() {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE);
    }

    public void punsubscribe(byte[] ... patterns) {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE, patterns);
    }

    public void pubsub(byte[] ... args) {
        this.sendCommand(Protocol.Command.PUBSUB, args);
    }

    public void zcount(byte[] key, double min, double max) {
        this.sendCommand(Protocol.Command.ZCOUNT, key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    public void zcount(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZCOUNT, key, min, max);
    }

    public void zcount(byte[] key, String min, String max) {
        this.sendCommand(Protocol.Command.ZCOUNT, key, min.getBytes(), max.getBytes());
    }

    public void zrangeByScore(byte[] key, double min, double max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max);
    }

    public void zrangeByScore(byte[] key, String min, String max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes());
    }

    public void zrevrangeByScore(byte[] key, double max, double min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min);
    }

    public void zrevrangeByScore(byte[] key, String max, String min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes());
    }

    public void zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScore(byte[] key, String min, String max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, String max, String min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, String min, String max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, String max, String min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, String min, String max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min.getBytes(), max.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max), Protocol.toByteArray(min), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, String max, String min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max.getBytes(), min.getBytes(), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYSCORE, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zremrangeByRank(byte[] key, long start, long stop) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYRANK, key, Protocol.toByteArray(start), Protocol.toByteArray(stop));
    }

    public void zremrangeByScore(byte[] key, double min, double max) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    public void zremrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYSCORE, key, min, max);
    }

    public void zremrangeByScore(byte[] key, String min, String max) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYSCORE, key, min.getBytes(), max.getBytes());
    }

    public void zunionstore(byte[] dstkey, byte[] ... sets) {
        this.sendCommand(Protocol.Command.ZUNIONSTORE, this.joinParameters(dstkey, Protocol.toByteArray(sets.length), sets));
    }

    public void zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        for (byte[] set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZUNIONSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zinterstore(byte[] dstkey, byte[] ... sets) {
        this.sendCommand(Protocol.Command.ZINTERSTORE, this.joinParameters(dstkey, Protocol.toByteArray(sets.length), sets));
    }

    public void zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        for (byte[] set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZINTERSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zlexcount(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZLEXCOUNT, key, min, max);
    }

    public void zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZRANGEBYLEX, key, min, max);
    }

    public void zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYLEX, key, min, max, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYLEX, key, max, min);
    }

    public void zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand(Protocol.Command.ZREVRANGEBYLEX, key, max, min, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYLEX, key, min, max);
    }

    public void save() {
        this.sendCommand(Protocol.Command.SAVE);
    }

    public void bgsave() {
        this.sendCommand(Protocol.Command.BGSAVE);
    }

    public void bgrewriteaof() {
        this.sendCommand(Protocol.Command.BGREWRITEAOF);
    }

    public void lastsave() {
        this.sendCommand(Protocol.Command.LASTSAVE);
    }

    public void shutdown() {
        this.sendCommand(Protocol.Command.SHUTDOWN);
    }

    public void info() {
        this.sendCommand(Protocol.Command.INFO);
    }

    public void info(String section) {
        this.sendCommand(Protocol.Command.INFO, section);
    }

    public void monitor() {
        this.sendCommand(Protocol.Command.MONITOR);
    }

    public void slaveof(String host, int port) {
        this.sendCommand(Protocol.Command.SLAVEOF, host, String.valueOf(port));
    }

    public void slaveofNoOne() {
        this.sendCommand(Protocol.Command.SLAVEOF, Protocol.Keyword.NO.raw, Protocol.Keyword.ONE.raw);
    }

    public void configGet(byte[] pattern) {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.GET.raw, pattern);
    }

    public void configSet(byte[] parameter, byte[] value) {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.SET.raw, parameter, value);
    }

    public void strlen(byte[] key) {
        this.sendCommand(Protocol.Command.STRLEN, new byte[][]{key});
    }

    public void sync() {
        this.sendCommand(Protocol.Command.SYNC);
    }

    public void lpushx(byte[] key, byte[] ... string) {
        this.sendCommand(Protocol.Command.LPUSHX, this.joinParameters(key, string));
    }

    public void persist(byte[] key) {
        this.sendCommand(Protocol.Command.PERSIST, new byte[][]{key});
    }

    public void rpushx(byte[] key, byte[] ... string) {
        this.sendCommand(Protocol.Command.RPUSHX, this.joinParameters(key, string));
    }

    public void echo(byte[] string) {
        this.sendCommand(Protocol.Command.ECHO, new byte[][]{string});
    }

    @Deprecated
    public void linsert(byte[] key, LIST_POSITION where, byte[] pivot, byte[] value) {
        this.sendCommand(Protocol.Command.LINSERT, key, where.raw, pivot, value);
    }

    public void linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        this.sendCommand(Protocol.Command.LINSERT, key, where.raw, pivot, value);
    }

    public void debug(DebugParams params) {
        this.sendCommand(Protocol.Command.DEBUG, params.getCommand());
    }

    public void brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.sendCommand(Protocol.Command.BRPOPLPUSH, source, destination, Protocol.toByteArray(timeout));
    }

    public void configResetStat() {
        this.sendCommand(Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.RESETSTAT.raw});
    }

    public void configRewrite() {
        this.sendCommand(Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.REWRITE.raw});
    }

    public void setbit(byte[] key, long offset, byte[] value) {
        this.sendCommand(Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), value);
    }

    public void setbit(byte[] key, long offset, boolean value) {
        this.sendCommand(Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), Protocol.toByteArray(value));
    }

    public void getbit(byte[] key, long offset) {
        this.sendCommand(Protocol.Command.GETBIT, key, Protocol.toByteArray(offset));
    }

    public void bitpos(byte[] key, boolean value, BitPosParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(value));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.BITPOS, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void setrange(byte[] key, long offset, byte[] value) {
        this.sendCommand(Protocol.Command.SETRANGE, key, Protocol.toByteArray(offset), value);
    }

    public void getrange(byte[] key, long startOffset, long endOffset) {
        this.sendCommand(Protocol.Command.GETRANGE, key, Protocol.toByteArray(startOffset), Protocol.toByteArray(endOffset));
    }

    public Long getDB() {
        return this.db;
    }

    @Override
    public void disconnect() {
        this.db = 0L;
        super.disconnect();
    }

    @Override
    public void close() {
        this.db = 0L;
        super.close();
    }

    public void resetState() {
        if (this.isInMulti()) {
            this.discard();
        }
        if (this.isInWatch()) {
            this.unwatch();
            this.getStatusCodeReply();
        }
    }

    public void eval(byte[] script, byte[] keyCount, byte[][] params) {
        this.sendCommand(Protocol.Command.EVAL, this.joinParameters(script, keyCount, params));
    }

    public void eval(byte[] script, int keyCount, byte[] ... params) {
        this.sendCommand(Protocol.Command.EVAL, this.joinParameters(script, Protocol.toByteArray(keyCount), params));
    }

    public void evalsha(byte[] sha1, byte[] keyCount, byte[] ... params) {
        this.sendCommand(Protocol.Command.EVALSHA, this.joinParameters(sha1, keyCount, params));
    }

    public void evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.sendCommand(Protocol.Command.EVALSHA, this.joinParameters(sha1, Protocol.toByteArray(keyCount), params));
    }

    public void scriptFlush() {
        this.sendCommand(Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.FLUSH.raw});
    }

    public void scriptExists(byte[] ... sha1) {
        this.sendCommand(Protocol.Command.SCRIPT, this.joinParameters(Protocol.Keyword.EXISTS.raw, sha1));
    }

    public void scriptLoad(byte[] script) {
        this.sendCommand(Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.raw, script);
    }

    public void scriptKill() {
        this.sendCommand(Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.KILL.raw});
    }

    public void slowlogGet() {
        this.sendCommand(Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.GET.raw});
    }

    public void slowlogGet(long entries) {
        this.sendCommand(Protocol.Command.SLOWLOG, Protocol.Keyword.GET.raw, Protocol.toByteArray(entries));
    }

    public void slowlogReset() {
        this.sendCommand(Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.RESET.raw});
    }

    public void slowlogLen() {
        this.sendCommand(Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.LEN.raw});
    }

    public void objectRefcount(byte[] key) {
        this.sendCommand(Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.raw, key);
    }

    public void objectIdletime(byte[] key) {
        this.sendCommand(Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.raw, key);
    }

    public void objectEncoding(byte[] key) {
        this.sendCommand(Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.raw, key);
    }

    public void bitcount(byte[] key) {
        this.sendCommand(Protocol.Command.BITCOUNT, new byte[][]{key});
    }

    public void bitcount(byte[] key, long start, long end) {
        this.sendCommand(Protocol.Command.BITCOUNT, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        Protocol.Keyword kw = Protocol.Keyword.AND;
        switch (op) {
            case AND: {
                kw = Protocol.Keyword.AND;
                break;
            }
            case OR: {
                kw = Protocol.Keyword.OR;
                break;
            }
            case XOR: {
                kw = Protocol.Keyword.XOR;
                break;
            }
            case NOT: {
                kw = Protocol.Keyword.NOT;
            }
        }
        this.sendCommand(Protocol.Command.BITOP, this.joinParameters(kw.raw, destKey, srcKeys));
    }

    public void sentinel(byte[] ... args) {
        this.sendCommand(Protocol.Command.SENTINEL, args);
    }

    public void dump(byte[] key) {
        this.sendCommand(Protocol.Command.DUMP, new byte[][]{key});
    }

    public void restore(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand(Protocol.Command.RESTORE, key, Protocol.toByteArray(ttl), serializedValue);
    }

    @Deprecated
    public void pexpire(byte[] key, int milliseconds) {
        this.pexpire(key, (long)milliseconds);
    }

    public void restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand(Protocol.Command.RESTORE, key, Protocol.toByteArray(ttl), serializedValue, Protocol.Keyword.REPLACE.raw);
    }

    public void pexpire(byte[] key, long milliseconds) {
        this.sendCommand(Protocol.Command.PEXPIRE, key, Protocol.toByteArray(milliseconds));
    }

    public void pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.sendCommand(Protocol.Command.PEXPIREAT, key, Protocol.toByteArray(millisecondsTimestamp));
    }

    public void pttl(byte[] key) {
        this.sendCommand(Protocol.Command.PTTL, new byte[][]{key});
    }

    @Deprecated
    public void psetex(byte[] key, int milliseconds, byte[] value) {
        this.psetex(key, (long)milliseconds, value);
    }

    public void psetex(byte[] key, long milliseconds, byte[] value) {
        this.sendCommand(Protocol.Command.PSETEX, key, Protocol.toByteArray(milliseconds), value);
    }

    public void set(byte[] key, byte[] value, byte[] nxxx) {
        this.sendCommand(Protocol.Command.SET, key, value, nxxx);
    }

    public void set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, int time) {
        this.sendCommand(Protocol.Command.SET, key, value, nxxx, expx, Protocol.toByteArray(time));
    }

    public void srandmember(byte[] key, int count) {
        this.sendCommand(Protocol.Command.SRANDMEMBER, key, Protocol.toByteArray(count));
    }

    public void clientKill(byte[] ipPort) {
        this.sendCommand(Protocol.Command.CLIENT, Protocol.Keyword.KILL.raw, ipPort);
    }

    public void clientKill(String ip, int port) {
        this.sendCommand(Protocol.Command.CLIENT, Protocol.Keyword.KILL.name(), ip + ':' + port);
    }

    public void clientGetname() {
        this.sendCommand(Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.GETNAME.raw});
    }

    public void clientList() {
        this.sendCommand(Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.LIST.raw});
    }

    public void clientSetname(byte[] name) {
        this.sendCommand(Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.raw, name);
    }

    public void time() {
        this.sendCommand(Protocol.Command.TIME);
    }

    @Deprecated
    public void migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        this.sendCommand(Protocol.Command.MIGRATE, host, Protocol.toByteArray(port), key, Protocol.toByteArray(destinationDb), Protocol.toByteArray(timeout));
    }

    public void migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        this.sendCommand(Protocol.Command.MIGRATE, SafeEncoder.encode(host), Protocol.toByteArray(port), key, Protocol.toByteArray(destinationDb), Protocol.toByteArray(timeout));
    }

    public void hincrByFloat(byte[] key, byte[] field, double increment) {
        this.sendCommand(Protocol.Command.HINCRBYFLOAT, key, field, Protocol.toByteArray(increment));
    }

    @Deprecated
    public void scan(int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @Deprecated
    public void hscan(byte[] key, int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.HSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @Deprecated
    public void sscan(byte[] key, int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @Deprecated
    public void zscan(byte[] key, int cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray(cursor));
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void scan(byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void hscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.HSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.SSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void waitReplicas(int replicas, long timeout) {
        this.sendCommand(Protocol.Command.WAIT, Protocol.toByteArray(replicas), Protocol.toByteArray(timeout));
    }

    public void cluster(byte[] ... args) {
        this.sendCommand(Protocol.Command.CLUSTER, args);
    }

    public void asking() {
        this.sendCommand(Protocol.Command.ASKING);
    }

    public void pfadd(byte[] key, byte[] ... elements) {
        this.sendCommand(Protocol.Command.PFADD, this.joinParameters(key, elements));
    }

    public void pfcount(byte[] key) {
        this.sendCommand(Protocol.Command.PFCOUNT, new byte[][]{key});
    }

    public void pfcount(byte[] ... keys) {
        this.sendCommand(Protocol.Command.PFCOUNT, keys);
    }

    public void pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.sendCommand(Protocol.Command.PFMERGE, this.joinParameters(destkey, sourcekeys));
    }

    public void readonly() {
        this.sendCommand(Protocol.Command.READONLY);
    }

    public void geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.sendCommand(Protocol.Command.GEOADD, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), member);
    }

    public void geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(memberCoordinateMap.size() * 3 + 1);
        args.add(key);
        args.addAll(this.convertGeoCoordinateMapToByteArrays(memberCoordinateMap));
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand(Protocol.Command.GEOADD, argsArray);
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2) {
        this.sendCommand(Protocol.Command.GEODIST, key, member1, member2);
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        this.sendCommand(Protocol.Command.GEODIST, key, member1, member2, unit.raw);
    }

    public void geohash(byte[] key, byte[] ... members) {
        this.sendCommand(Protocol.Command.GEOHASH, this.joinParameters(key, members));
    }

    public void geopos(byte[] key, byte[][] members) {
        this.sendCommand(Protocol.Command.GEOPOS, this.joinParameters(key, members));
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.sendCommand(Protocol.Command.GEORADIUS, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit.raw);
    }

    public void georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.sendCommand(Protocol.Command.GEORADIUS_RO, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit.raw);
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand(Protocol.Command.GEORADIUS, param.getByteParams(key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit.raw));
    }

    public void georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand(Protocol.Command.GEORADIUS_RO, param.getByteParams(key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit.raw));
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.sendCommand(Protocol.Command.GEORADIUSBYMEMBER, key, member, Protocol.toByteArray(radius), unit.raw);
    }

    public void georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.sendCommand(Protocol.Command.GEORADIUSBYMEMBER_RO, key, member, Protocol.toByteArray(radius), unit.raw);
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand(Protocol.Command.GEORADIUSBYMEMBER, param.getByteParams(key, member, Protocol.toByteArray(radius), unit.raw));
    }

    public void georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand(Protocol.Command.GEORADIUSBYMEMBER_RO, param.getByteParams(key, member, Protocol.toByteArray(radius), unit.raw));
    }

    private ArrayList<byte[]> convertScoreMembersToByteArrays(Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(scoreMembers.size() * 2);
        for (Map.Entry<byte[], Double> entry : scoreMembers.entrySet()) {
            args.add(Protocol.toByteArray(entry.getValue()));
            args.add(entry.getKey());
        }
        return args;
    }

    private List<byte[]> convertGeoCoordinateMapToByteArrays(Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(memberCoordinateMap.size() * 3);
        for (Map.Entry<byte[], GeoCoordinate> entry : memberCoordinateMap.entrySet()) {
            GeoCoordinate coordinate = entry.getValue();
            args.add(Protocol.toByteArray(coordinate.getLongitude()));
            args.add(Protocol.toByteArray(coordinate.getLatitude()));
            args.add(entry.getKey());
        }
        return args;
    }

    public void bitfield(byte[] key, byte[] ... value) {
        this.sendCommand(Protocol.Command.BITFIELD, this.joinParameters(key, value));
    }

    public void hstrlen(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HSTRLEN, key, field);
    }

    public static enum LIST_POSITION {
        BEFORE,
        AFTER;

        public final byte[] raw = SafeEncoder.encode(this.name());
    }
}

