/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import redis.clients.jedis.Client;
import redis.clients.jedis.SortingParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTransaction {
    protected Client client = null;
    protected boolean inTransaction = true;

    public BinaryTransaction() {
    }

    public BinaryTransaction(Client client) {
        this.client = client;
    }

    public String ping() {
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    public String set(byte[] key, byte[] value) {
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    public String get(byte[] key) {
        this.client.get(key);
        return this.client.getStatusCodeReply();
    }

    public String exists(byte[] key) {
        this.client.exists(key);
        return this.client.getStatusCodeReply();
    }

    public String del(byte[] ... keys) {
        this.client.del(keys);
        return this.client.getStatusCodeReply();
    }

    public String type(byte[] key) {
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    public String flushDB() {
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    public String keys(byte[] pattern) {
        this.client.keys(pattern);
        return this.client.getStatusCodeReply();
    }

    public byte[] randomBinaryKey() {
        this.client.randomKey();
        return this.client.getBinaryBulkReply();
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public String renamenx(byte[] oldkey, byte[] newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public String dbSize() {
        this.client.dbSize();
        return this.client.getStatusCodeReply();
    }

    public String expire(byte[] key, int seconds) {
        this.client.expire(key, seconds);
        return this.client.getStatusCodeReply();
    }

    public String expireAt(byte[] key, long unixTime) {
        this.client.expireAt(key, unixTime);
        return this.client.getStatusCodeReply();
    }

    public String ttl(byte[] key) {
        this.client.ttl(key);
        return this.client.getStatusCodeReply();
    }

    public String select(int index) {
        this.client.select(index);
        return this.client.getStatusCodeReply();
    }

    public String move(byte[] key, int dbIndex) {
        this.client.move(key, dbIndex);
        return this.client.getStatusCodeReply();
    }

    public String flushAll() {
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    public String getSet(byte[] key, byte[] value) {
        this.client.getSet(key, value);
        return this.client.getStatusCodeReply();
    }

    public String mget(byte[] ... keys) {
        this.client.mget(keys);
        return this.client.getStatusCodeReply();
    }

    public String setnx(byte[] key, byte[] value) {
        this.client.setnx(key, value);
        return this.client.getStatusCodeReply();
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    public String mset(byte[] ... keysvalues) {
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public String msetnx(byte[] ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public String decrBy(byte[] key, int integer) {
        this.client.decrBy(key, (long)integer);
        return this.client.getStatusCodeReply();
    }

    public String decr(byte[] key) {
        this.client.decr(key);
        return this.client.getStatusCodeReply();
    }

    public String incrBy(byte[] key, int integer) {
        this.client.incrBy(key, (long)integer);
        return this.client.getStatusCodeReply();
    }

    public String incr(byte[] key) {
        this.client.incr(key);
        return this.client.getStatusCodeReply();
    }

    public String append(byte[] key, byte[] value) {
        this.client.append(key, value);
        return this.client.getStatusCodeReply();
    }

    public String substr(byte[] key, int start, int end) {
        this.client.substr(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String hset(byte[] key, byte[] field, byte[] value) {
        this.client.hset(key, field, value);
        return this.client.getStatusCodeReply();
    }

    public String hget(byte[] key, byte[] field) {
        this.client.hget(key, field);
        return this.client.getStatusCodeReply();
    }

    public String hsetnx(byte[] key, byte[] field, byte[] value) {
        this.client.hsetnx(key, field, value);
        return this.client.getStatusCodeReply();
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    public String hmget(byte[] key, byte[] ... fields) {
        this.client.hmget(key, fields);
        return this.client.getStatusCodeReply();
    }

    public String hincrBy(byte[] key, byte[] field, int value) {
        this.client.hincrBy(key, field, (long)value);
        return this.client.getStatusCodeReply();
    }

    public String hexists(byte[] key, byte[] field) {
        this.client.hexists(key, field);
        return this.client.getStatusCodeReply();
    }

    public String hdel(byte[] key, byte[] field) {
        this.client.hdel(key, field);
        return this.client.getStatusCodeReply();
    }

    public String hlen(byte[] key) {
        this.client.hlen(key);
        return this.client.getStatusCodeReply();
    }

    public String hkeys(byte[] key) {
        this.client.hkeys(key);
        return this.client.getStatusCodeReply();
    }

    public String hvals(byte[] key) {
        this.client.hvals(key);
        return this.client.getStatusCodeReply();
    }

    public String hgetAll(byte[] key) {
        this.client.hgetAll(key);
        return this.client.getStatusCodeReply();
    }

    public String rpush(byte[] key, byte[] string) {
        this.client.rpush(key, string);
        return this.client.getStatusCodeReply();
    }

    public String lpush(byte[] key, byte[] string) {
        this.client.lpush(key, string);
        return this.client.getStatusCodeReply();
    }

    public String llen(byte[] key) {
        this.client.llen(key);
        return this.client.getStatusCodeReply();
    }

    public String lrange(byte[] key, int start, int end) {
        this.client.lrange(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String ltrim(byte[] key, int start, int end) {
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String lindex(byte[] key, int index) {
        this.client.lindex(key, index);
        return this.client.getStatusCodeReply();
    }

    public String lset(byte[] key, int index, byte[] value) {
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    public String lrem(byte[] key, int count, byte[] value) {
        this.client.lrem(key, count, value);
        return this.client.getStatusCodeReply();
    }

    public String lpop(byte[] key) {
        this.client.lpop(key);
        return this.client.getStatusCodeReply();
    }

    public String rpop(byte[] key) {
        this.client.rpop(key);
        return this.client.getStatusCodeReply();
    }

    public String rpoplpush(byte[] srckey, byte[] dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getStatusCodeReply();
    }

    public String sadd(byte[] key, byte[] member) {
        this.client.sadd(key, member);
        return this.client.getStatusCodeReply();
    }

    public String smembers(byte[] key) {
        this.client.smembers(key);
        return this.client.getStatusCodeReply();
    }

    public String srem(byte[] key, byte[] member) {
        this.client.srem(key, member);
        return this.client.getStatusCodeReply();
    }

    public String spop(byte[] key) {
        this.client.spop(key);
        return this.client.getStatusCodeReply();
    }

    public String smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.client.smove(srckey, dstkey, member);
        return this.client.getStatusCodeReply();
    }

    public String scard(byte[] key) {
        this.client.scard(key);
        return this.client.getStatusCodeReply();
    }

    public String sismember(byte[] key, byte[] member) {
        this.client.sismember(key, member);
        return this.client.getStatusCodeReply();
    }

    public String sinter(byte[] ... keys) {
        this.client.sinter(keys);
        return this.client.getStatusCodeReply();
    }

    public String sinterstore(byte[] dstkey, byte[] ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.client.getStatusCodeReply();
    }

    public String sunion(byte[] ... keys) {
        this.client.sunion(keys);
        return this.client.getStatusCodeReply();
    }

    public String sunionstore(byte[] dstkey, byte[] ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.client.getStatusCodeReply();
    }

    public String sdiff(byte[] ... keys) {
        this.client.sdiff(keys);
        return this.client.getStatusCodeReply();
    }

    public String sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.client.getStatusCodeReply();
    }

    public String srandmember(byte[] key) {
        this.client.srandmember(key);
        return this.client.getStatusCodeReply();
    }

    public String zadd(byte[] key, double score, byte[] member) {
        this.client.zadd(key, score, member);
        return this.client.getStatusCodeReply();
    }

    public String zrange(byte[] key, int start, int end) {
        this.client.zrange(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zrem(byte[] key, byte[] member) {
        this.client.zrem(key, member);
        return this.client.getStatusCodeReply();
    }

    public String zincrby(byte[] key, double score, byte[] member) {
        this.client.zincrby(key, score, member);
        return this.client.getStatusCodeReply();
    }

    public String zrank(byte[] key, byte[] member) {
        this.client.zrank(key, member);
        return this.client.getStatusCodeReply();
    }

    public String zrevrank(byte[] key, byte[] member) {
        this.client.zrevrank(key, member);
        return this.client.getStatusCodeReply();
    }

    public String zrevrange(byte[] key, int start, int end) {
        this.client.zrevrange(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zrangeWithScores(byte[] key, int start, int end) {
        this.client.zrangeWithScores(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zrevrangeWithScores(byte[] key, int start, int end) {
        this.client.zrevrangeWithScores(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zcard(byte[] key) {
        this.client.zcard(key);
        return this.client.getStatusCodeReply();
    }

    public String zscore(byte[] key, byte[] member) {
        this.client.zscore(key, member);
        return this.client.getStatusCodeReply();
    }

    public List<Object> exec() {
        this.client.exec();
        return this.client.getObjectMultiBulkReply();
    }

    public String sort(byte[] key) {
        this.client.sort(key);
        return this.client.getStatusCodeReply();
    }

    public String sort(byte[] key, SortingParams sortingParameters) {
        this.client.sort(key, sortingParameters);
        return this.client.getStatusCodeReply();
    }

    public String discard() {
        this.client.discard();
        this.inTransaction = false;
        return this.client.getStatusCodeReply();
    }
}

