/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import redis.clients.util.Hashing;
import redis.clients.util.SafeEncoder;
import redis.clients.util.ShardInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sharded<R, S extends ShardInfo<R>> {
    public static final int DEFAULT_WEIGHT = 1;
    private TreeMap<Long, S> nodes;
    private final Hashing algo;
    private final Map<ShardInfo<R>, R> resources = new HashMap<ShardInfo<R>, R>();
    private Pattern tagPattern = null;
    public static final Pattern DEFAULT_KEY_TAG_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public Sharded(List<S> shards) {
        this(shards, Hashing.MURMUR_HASH);
    }

    public Sharded(List<S> shards, Hashing algo) {
        this.algo = algo;
        this.initialize(shards);
    }

    public Sharded(List<S> shards, Pattern tagPattern) {
        this(shards, Hashing.MURMUR_HASH, tagPattern);
    }

    public Sharded(List<S> shards, Hashing algo, Pattern tagPattern) {
        this.algo = algo;
        this.tagPattern = tagPattern;
        this.initialize(shards);
    }

    private void initialize(List<S> shards) {
        this.nodes = new TreeMap();
        int totalWeight = 0;
        for (ShardInfo shard : shards) {
            totalWeight += shard.getWeight();
        }
        long oneForthOfStep = 0x4000000000000000L / (long)totalWeight;
        long floor = Long.MIN_VALUE;
        for (int i = 0; i != shards.size(); ++i) {
            ShardInfo shardInfo = (ShardInfo)shards.get(i);
            this.resources.put(shardInfo, shardInfo.createResource());
            this.nodes.put(floor, shardInfo);
            floor += 4L * oneForthOfStep * (long)shardInfo.getWeight();
        }
    }

    public R getShard(byte[] key) {
        return this.resources.get(this.getShardInfo(key));
    }

    public R getShard(String key) {
        return this.resources.get(this.getShardInfo(key));
    }

    private S getShardInfo(byte[] key) {
        Iterator<Map.Entry<Long, S>> iterator = this.nodes.headMap(this.algo.hash(key)).entrySet().iterator();
        Map.Entry<Long, S> next = iterator.next();
        if (iterator.hasNext()) {
            next = iterator.next();
        }
        return (S)((ShardInfo)next.getValue());
    }

    public S getShardInfo(String key) {
        return this.getShardInfo(SafeEncoder.encode(this.getKeyTag(key)));
    }

    public String getKeyTag(String key) {
        Matcher m;
        if (this.tagPattern != null && (m = this.tagPattern.matcher(key)).find()) {
            return m.group(1);
        }
        return key;
    }

    public Collection<S> getAllShardInfo() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public Collection<R> getAllShards() {
        return Collections.unmodifiableCollection(this.resources.values());
    }
}

