/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import redis.clients.jedis.JedisException;

public class RedisInputStream
extends FilterInputStream {
    protected final byte[] buf;
    protected int count;
    protected int limit;

    public RedisInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    public RedisInputStream(InputStream in) {
        this(in, 8192);
    }

    public byte readByte() throws IOException {
        if (this.count == this.limit) {
            this.fill();
        }
        return this.buf[this.count++];
    }

    public String readLine() {
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                byte b;
                if (this.count == this.limit) {
                    this.fill();
                }
                if (this.limit == -1) break;
                if ((b = this.buf[this.count++]) == 13) {
                    byte c;
                    if (this.count == this.limit) {
                        this.fill();
                    }
                    if (this.limit == -1) {
                        sb.append((char)b);
                    } else if ((c = this.buf[this.count++]) != 10) {
                        sb.append((char)b);
                        sb.append((char)c);
                        continue;
                    }
                    break;
                }
                sb.append((char)b);
            }
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
        return sb.toString();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.count == this.limit) {
            this.fill();
            if (this.limit == -1) {
                return -1;
            }
        }
        int length = Math.min(this.limit - this.count, len);
        System.arraycopy(this.buf, this.count, b, off, length);
        this.count += length;
        return length;
    }

    private void fill() throws IOException {
        this.limit = this.in.read(this.buf);
        this.count = 0;
    }
}

