/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pool<T> {
    private final GenericObjectPool internalPool;

    public Pool(GenericObjectPool.Config poolConfig, PoolableObjectFactory factory) {
        this.internalPool = new GenericObjectPool(factory, poolConfig);
    }

    public T getResource() throws Exception {
        return (T)this.internalPool.borrowObject();
    }

    public void returnResource(T resource) throws Exception {
        this.internalPool.returnObject(resource);
    }

    public void returnBrokenResource(T resource) throws Exception {
        this.internalPool.invalidateObject(resource);
    }

    public void destroy() throws Exception {
        this.internalPool.close();
    }
}

