/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.Jedis;
import redis.clients.util.ShardInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JedisShardInfo
extends ShardInfo<Jedis> {
    private int timeout;
    private String host;
    private int port;
    private String password = null;

    public String toString() {
        return "JedisShardInfo [host=" + this.host + ", port=" + this.port + ", weight=" + this.getWeight() + "]";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public JedisShardInfo(String host) {
        this(host, 6379);
    }

    public JedisShardInfo(String host, int port) {
        this(host, port, 2000);
    }

    public JedisShardInfo(String host, int port, int timeout) {
        this(host, port, timeout, 1);
    }

    public JedisShardInfo(String host, int port, int timeout, int weight) {
        super(weight);
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String auth) {
        this.password = auth;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Jedis createResource() {
        return new Jedis(this);
    }
}

