/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FixedResourcePool<T> {
    private static Logger logger = Logger.getLogger(FixedResourcePool.class.getName());
    Metrics metrics;
    private LinkedBlockingQueue<Wrapper<T>> availableQueue;
    private LinkedBlockingQueue<Wrapper<T>> repairQueue;
    private HashMap<T, Wrapper<T>> inUse = new HashMap();
    private RepairThread[] repairThreads;
    private Timer t;
    private boolean initializated = false;
    private boolean finishing = false;
    private String name;
    private long defaultPoolWait = 50L;
    private int resourcesNumber = 10;
    private int repairThreadsNumber = 3;
    private long timeBetweenValidation = 150000L;
    private long destructionWait = 10000L;

    public int getResourcesNumber() {
        return this.resourcesNumber;
    }

    public void setResourcesNumber(int resourcesNumber) {
        this.resourcesNumber = resourcesNumber;
    }

    public int getRepairThreadsNumber() {
        return this.repairThreadsNumber;
    }

    public void setRepairThreadsNumber(int repairThreadsNumber) {
        if (this.initializated) {
            throw new IllegalStateException("Repair threads should be setted up before init()");
        }
        this.repairThreadsNumber = repairThreadsNumber;
    }

    public long getTimeBetweenValidation() {
        return this.timeBetweenValidation;
    }

    public void setTimeBetweenValidation(long timeBetweenValidation) {
        this.timeBetweenValidation = timeBetweenValidation;
    }

    public long getDestructionWait() {
        return this.destructionWait;
    }

    public void setDestructionWait(long destructionWait) {
        this.destructionWait = destructionWait;
    }

    public void setName(String name) {
        if (this.initializated) {
            throw new IllegalStateException("Name should be setted up before init()");
        }
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getClass().getName();
        }
        return this.name;
    }

    public void setDefaultPoolWait(long defaultPoolWait) {
        this.defaultPoolWait = defaultPoolWait;
    }

    public long getDefaultPoolWait() {
        return this.defaultPoolWait;
    }

    public void init() {
        int i;
        if (this.initializated) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.severe("Warning, double initialization of [" + this + "]");
            }
            return;
        }
        this.initializated = true;
        this.metrics = new Metrics();
        this.availableQueue = new LinkedBlockingQueue(this.resourcesNumber);
        this.repairQueue = new LinkedBlockingQueue(this.resourcesNumber);
        this.repairThreads = new RepairThread[this.repairThreadsNumber];
        for (i = 0; i < this.repairThreads.length; ++i) {
            this.repairThreads[i] = new RepairThread();
            this.repairThreads[i].setName("REPAIR[" + i + "]:" + this.name);
            this.repairThreads[i].start();
        }
        for (i = 0; i < this.resourcesNumber; ++i) {
            if (this.repairQueue.offer(new Wrapper<Object>(null))) continue;
            throw new IllegalStateException("What!? not enough space in the repairQueue to offer the element. This shouldn't happen!");
        }
        this.t = new Timer();
        this.t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (logger.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("**********************************");
                    sb.append("* Pool name:[" + FixedResourcePool.this.name + "]");
                    sb.append("* resourcesCreated....:" + FixedResourcePool.this.metrics.getResourcesCreated());
                    sb.append("* failsReported.......:" + FixedResourcePool.this.metrics.getFailsReported());
                    sb.append("* fails...............:" + FixedResourcePool.this.metrics.getFails());
                    sb.append("* resourcesCreated....:" + FixedResourcePool.this.metrics.getResourcesCreated());
                    sb.append("* resourcesProvided...:" + FixedResourcePool.this.metrics.getResourcesProvided());
                    sb.append("* resourcesReturned...:" + FixedResourcePool.this.metrics.getResourcesReturned());
                    sb.append("* available size......:" + FixedResourcePool.this.availableQueue.size());
                    sb.append("* repair size.........:" + FixedResourcePool.this.repairQueue.size());
                    sb.append("**********************************");
                    logger.fine(sb.toString());
                }
            }
        }, 10000L, 10000L);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Initialized [" + this.name + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void destroy() {
        long t1;
        this.checkInit();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Destroying [" + this.getName() + "]...");
        }
        this.finishing = true;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Destroying [" + this.getName() + "] threads");
        }
        int i = 0;
        while (true) {
            if (i >= this.repairThreads.length) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Waiting at most [" + this.getDestructionWait() + "]ms for [" + this.getName() + "] resources to be returned.");
                }
                t1 = System.currentTimeMillis();
                FixedResourcePool e = this;
                // MONITORENTER : e
                break;
            }
            boolean joined = false;
            do {
                try {
                    this.repairThreads[i].interrupt();
                    this.repairThreads[i].join();
                    joined = true;
                }
                catch (InterruptedException e) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.severe(e.getMessage());
                }
            } while (!joined);
            ++i;
        }
        while (!this.inUse.isEmpty()) {
            try {
                this.wait(this.getDestructionWait());
                long t2 = System.currentTimeMillis();
                if (!(t2 - t1 > this.getDestructionWait() & !this.inUse.isEmpty())) continue;
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Resource wait timeout. Forcing inUse resources destruction.");
                }
                for (T used : this.inUse.keySet()) {
                    this.destroyResource(used);
                }
            }
            catch (InterruptedException e) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.severe(e.getMessage());
            }
        }
        // MONITOREXIT : e
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Destroying [" + this.getName() + "] resources.");
        }
        for (Wrapper<T> resource : this.availableQueue) {
            this.destroyResource(resource.wrapped);
        }
        this.availableQueue.clear();
        this.availableQueue = null;
        for (Wrapper<T> resource : this.repairQueue) {
            this.destroyResource(resource.wrapped);
        }
        this.repairQueue.clear();
        this.repairQueue = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Shuting metrics timer for [" + this.getName() + "] down.");
        }
        this.t.cancel();
        this.t = null;
        this.metrics = null;
        this.initializated = false;
        this.finishing = false;
        if (!logger.isLoggable(Level.INFO)) return;
        logger.info("Pool [" + this.getName() + "] successfully destroyed.");
    }

    protected void checkInit() {
        if (!this.initializated) {
            throw new IllegalStateException("Call the init() method first!");
        }
    }

    private boolean isValidationNeeded(Wrapper<T> wrapper) {
        long noisyTimeBetweenCheck = this.timeBetweenValidation - (long)((Math.random() - 0.5) * (double)(this.timeBetweenValidation / 10L));
        return wrapper.getLastMark() + noisyTimeBetweenCheck < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnResource(T resource) {
        Wrapper<T> wrapper;
        this.checkInit();
        if (resource == null) {
            throw new IllegalArgumentException("The resource shouldn't be null.");
        }
        Object object = this.inUse;
        synchronized (object) {
            wrapper = this.inUse.remove(resource);
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("The resource [" + resource + "] isn't in the busy resources list.");
        }
        if (this.isValidationNeeded(wrapper)) {
            if (!this.repairQueue.offer(wrapper)) {
                throw new IllegalStateException("This shouldn't happen. Offering to repair queue rejected.");
            }
        } else if (!this.availableQueue.offer(wrapper)) {
            throw new IllegalStateException("This shouldn't happen. Offering to available queue rejected.");
        }
        this.metrics.resourcesReturned++;
        if (this.finishing) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBrokenResource(T resource) {
        Wrapper<T> wrapper;
        this.checkInit();
        Object object = this.inUse;
        synchronized (object) {
            wrapper = this.inUse.remove(resource);
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("The resource [" + resource + "] isn't in the busy resources list.");
        }
        if (!this.repairQueue.offer(wrapper)) {
            throw new IllegalStateException("This shouldn't happen. Offering to repair queue rejected.");
        }
        this.metrics.resourcesReturned++;
        if (this.finishing) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    public T getResource() throws TimeoutException {
        return this.getResource(this.defaultPoolWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResource(long maxTime) throws TimeoutException {
        if (this.finishing) {
            throw new IllegalStateException("Pool [" + this.getName() + "] is currently being destroyed.");
        }
        this.checkInit();
        long tInit = System.currentTimeMillis();
        while (true) {
            try {
                long timeToSleep;
                Wrapper<T> ret;
                do {
                    long timeSpent;
                    long l = timeToSleep = (timeToSleep = maxTime - (timeSpent = System.currentTimeMillis() - tInit)) > 0L ? timeToSleep : 0L;
                    if (timeToSleep != 0L) continue;
                    throw new TimeoutException("" + timeSpent + ">" + maxTime);
                } while ((ret = this.availableQueue.poll(timeToSleep, TimeUnit.MILLISECONDS)) == null);
                HashMap<T, Wrapper<T>> hashMap = this.inUse;
                synchronized (hashMap) {
                    this.inUse.put(ret.wrapped, ret);
                }
                this.metrics.resourcesProvided++;
                return ret.wrapped;
            }
            catch (InterruptedException e1) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.severe(e1.getMessage());
                continue;
            }
            break;
        }
    }

    protected abstract T createResource();

    protected abstract boolean isResourceValid(T var1);

    protected abstract void destroyResource(T var1);

    public String toString() {
        return this.getName() + "[" + super.toString() + "]";
    }

    public static class Metrics {
        private volatile long failsReported = 0L;
        private volatile long fails = 0L;
        private volatile long resourcesCreated = 0L;
        private volatile long resourcesProvided = 0L;
        private volatile long resourcesReturned = 0L;

        public long getFailsReported() {
            return this.failsReported;
        }

        public long getFails() {
            return this.fails;
        }

        public long getResourcesCreated() {
            return this.resourcesCreated;
        }

        public long getResourcesProvided() {
            return this.resourcesProvided;
        }

        public long getResourcesReturned() {
            return this.resourcesReturned;
        }
    }

    protected class RepairThread
    extends Thread {
        protected RepairThread() {
        }

        @Override
        public void run() {
            while (!FixedResourcePool.this.finishing) {
                Wrapper wrapper;
                block8: {
                    try {
                        wrapper = (Wrapper)FixedResourcePool.this.repairQueue.poll(FixedResourcePool.this.timeBetweenValidation, TimeUnit.MILLISECONDS);
                        if (wrapper == null) {
                            this.checkIdles();
                        }
                        break block8;
                    }
                    catch (InterruptedException e) {
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logger.severe(e.getMessage());
                    }
                    continue;
                }
                Object resource = wrapper.wrapped;
                boolean valid = false;
                if (resource != null && !(valid = FixedResourcePool.this.isResourceValid(resource))) {
                    FixedResourcePool.this.metrics.fails++;
                }
                if (!valid) {
                    Object replace = FixedResourcePool.this.createResource();
                    FixedResourcePool.this.metrics.resourcesCreated++;
                    wrapper.wrapped = replace;
                    if (resource != null) {
                        FixedResourcePool.this.destroyResource(resource);
                    }
                }
                wrapper.mark();
                if (FixedResourcePool.this.availableQueue.offer(wrapper) || !logger.isLoggable(Level.SEVERE)) continue;
                logger.severe("This shouldn't happen, offering to available was rejected.");
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Ending thread [" + Thread.currentThread().getName() + "]");
            }
        }

        private void checkIdles() {
            Wrapper wrapper = (Wrapper)FixedResourcePool.this.availableQueue.peek();
            if (wrapper == null) {
                return;
            }
            boolean repairNeeded = FixedResourcePool.this.isValidationNeeded(wrapper);
            if (!repairNeeded) {
                return;
            }
            while (repairNeeded) {
                wrapper = (Wrapper)FixedResourcePool.this.availableQueue.poll();
                if (wrapper == null) {
                    repairNeeded = false;
                    return;
                }
                repairNeeded = FixedResourcePool.this.isValidationNeeded(wrapper);
                if (repairNeeded) {
                    if (FixedResourcePool.this.repairQueue.offer(wrapper) || !logger.isLoggable(Level.SEVERE)) continue;
                    logger.severe("FATAL: This shouldn't happen, offering to repairing was rejected.");
                    continue;
                }
                if (FixedResourcePool.this.availableQueue.offer(wrapper) || !logger.isLoggable(Level.SEVERE)) continue;
                logger.severe("FATAL: This shouldn't happen, offering to available was rejected.");
            }
        }
    }

    private static class Wrapper<T> {
        long timestamp;
        T wrapped;

        public Wrapper(T wrapped) {
            this.wrapped = wrapped;
            this.mark();
        }

        public void mark() {
            this.timestamp = System.currentTimeMillis();
        }

        public long getLastMark() {
            return this.timestamp;
        }
    }
}

