/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.Sort;

public class FloatList
implements Iterable<Float> {
    int count;
    float[] data;

    public FloatList() {
        this.data = new float[10];
    }

    public FloatList(int length) {
        this.data = new float[length];
    }

    public FloatList(float[] list) {
        this.count = list.length;
        this.data = new float[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public FloatList(Iterable<Object> iter) {
        this(10);
        for (Object o : iter) {
            if (o == null) {
                this.append(Float.NaN);
                continue;
            }
            if (o instanceof Number) {
                this.append(((Number)o).floatValue());
                continue;
            }
            this.append(PApplet.parseFloat(o.toString().trim()));
        }
        this.crop();
    }

    public FloatList(Object ... items) {
        float missingValue = Float.NaN;
        this.count = items.length;
        this.data = new float[this.count];
        int index = 0;
        for (Object o : items) {
            float value = Float.NaN;
            if (o != null) {
                value = o instanceof Number ? ((Number)o).floatValue() : PApplet.parseFloat(o.toString().trim(), Float.NaN);
            }
            this.data[index++] = value;
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            float[] temp = new float[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0.0f);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public float get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void set(int index, float what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            for (int i = this.count; i < index; ++i) {
                this.data[i] = 0.0f;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public void push(float value) {
        this.append(value);
    }

    public float pop() {
        if (this.count == 0) {
            throw new RuntimeException("Can't call pop() on an empty list");
        }
        float value = this.get(this.count - 1);
        --this.count;
        return value;
    }

    public float remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        float entry = this.data[index];
        for (int i = index; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return entry;
    }

    public int removeValue(int value) {
        int index = this.index(value);
        if (index != -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public int removeValues(int value) {
        int i;
        int ii = 0;
        if (Float.isNaN(value)) {
            for (i = 0; i < this.count; ++i) {
                if (Float.isNaN(this.data[i])) continue;
                this.data[ii++] = this.data[i];
            }
        } else {
            for (i = 0; i < this.count; ++i) {
                if (this.data[i] == (float)value) continue;
                this.data[ii++] = this.data[i];
            }
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public boolean replaceValue(float value, float newValue) {
        if (Float.isNaN(value)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                this.data[i] = newValue;
                return true;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.data[index] = newValue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceValues(float value, float newValue) {
        boolean changed = false;
        if (Float.isNaN(value)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                this.data[i] = newValue;
                changed = true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != value) continue;
                this.data[i] = newValue;
                changed = true;
            }
        }
        return changed;
    }

    public void append(float value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(float[] values) {
        for (float v : values) {
            this.append(v);
        }
    }

    public void append(FloatList list) {
        for (float v : list.values()) {
            this.append(v);
        }
    }

    public void appendUnique(float value) {
        if (!this.hasValue(value)) {
            this.append(value);
        }
    }

    public void insert(int index, float value) {
        this.insert(index, new float[]{value});
    }

    public void insert(int index, float[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        float[] temp = new float[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, FloatList list) {
        this.insert(index, list.values());
    }

    public int index(float what) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != what) continue;
            return i;
        }
        return -1;
    }

    public boolean hasValue(float value) {
        if (Float.isNaN(value)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != value) continue;
                return true;
            }
        }
        return false;
    }

    private void boundsProblem(int index, String method) {
        String msg = String.format("The list size is %d. You cannot %s() to element %d.", this.count, method, index);
        throw new ArrayIndexOutOfBoundsException(msg);
    }

    public void add(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] + amount;
        } else {
            this.boundsProblem(index, "add");
        }
    }

    public void sub(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] - amount;
        } else {
            this.boundsProblem(index, "sub");
        }
    }

    public void mult(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] * amount;
        } else {
            this.boundsProblem(index, "mult");
        }
    }

    public void div(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] / amount;
        } else {
            this.boundsProblem(index, "div");
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public float min() {
        this.checkMinMax("min");
        int index = this.minIndex();
        return index == -1 ? Float.NaN : this.data[index];
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        float m = Float.NaN;
        int mi = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != this.data[i]) continue;
            m = this.data[i];
            mi = i;
            for (int j = i + 1; j < this.count; ++j) {
                float d = this.data[j];
                if (Float.isNaN(d) || !(d < m)) continue;
                m = this.data[j];
                mi = j;
            }
            break;
        }
        return mi;
    }

    public float max() {
        this.checkMinMax("max");
        int index = this.maxIndex();
        return index == -1 ? Float.NaN : this.data[index];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        float m = Float.NaN;
        int mi = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != this.data[i]) continue;
            m = this.data[i];
            mi = i;
            for (int j = i + 1; j < this.count; ++j) {
                float d = this.data[j];
                if (Float.isNaN(d) || !(d > m)) continue;
                m = this.data[j];
                mi = j;
            }
            break;
        }
        return mi;
    }

    public float sum() {
        double amount = this.sumDouble();
        if (amount > 3.4028234663852886E38) {
            throw new RuntimeException("sum() exceeds 3.4028235E38, use sumDouble()");
        }
        if (amount < -3.4028234663852886E38) {
            throw new RuntimeException("sum() lower than -3.4028235E38, use sumDouble()");
        }
        return (float)amount;
    }

    public double sumDouble() {
        double sum = 0.0;
        for (int i = 0; i < this.count; ++i) {
            sum += (double)this.data[i];
        }
        return sum;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                if (FloatList.this.count == 0) {
                    return 0;
                }
                int right = FloatList.this.count - 1;
                while (FloatList.this.data[right] != FloatList.this.data[right]) {
                    if (--right != -1) continue;
                    return 0;
                }
                for (int i = right; i >= 0; --i) {
                    float v = FloatList.this.data[i];
                    if (v == v) continue;
                    FloatList.this.data[i] = FloatList.this.data[right];
                    FloatList.this.data[right] = v;
                    --right;
                }
                return right + 1;
            }

            @Override
            public int compare(int a, int b) {
                float diff = FloatList.this.data[b] - FloatList.this.data[a];
                return diff == 0.0f ? 0 : (diff < 0.0f ? -1 : 1);
            }

            @Override
            public void swap(int a, int b) {
                float temp = FloatList.this.data[a];
                FloatList.this.data[a] = FloatList.this.data[b];
                FloatList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            float t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public FloatList copy() {
        FloatList outgoing = new FloatList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public float[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            int index = -1;

            @Override
            public void remove() {
                FloatList.this.remove(this.index);
                --this.index;
            }

            @Override
            public Float next() {
                return Float.valueOf(FloatList.this.data[++this.index]);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatList.this.count;
            }
        };
    }

    public float[] array() {
        return this.array(null);
    }

    public float[] array(float[] array) {
        if (array == null || array.length != this.count) {
            array = new float[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public FloatList getPercent() {
        double sum = 0.0;
        for (float value : this.array()) {
            sum += (double)value;
        }
        FloatList outgoing = new FloatList(this.count);
        for (int i = 0; i < this.count; ++i) {
            double percent = (double)this.data[i] / sum;
            outgoing.set(i, (float)percent);
        }
        return outgoing;
    }

    public FloatList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public FloatList getSubset(int start, int num) {
        float[] subset = new float[num];
        System.arraycopy(this.data, start, subset, 0, num);
        return new FloatList(subset);
    }

    public String join(String separator) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.data[0]);
        for (int i = 1; i < this.count; ++i) {
            sb.append(separator);
            sb.append(this.data[i]);
        }
        return sb.toString();
    }

    public void print() {
        for (int i = 0; i < this.count; ++i) {
            System.out.format("[%d] %f%n", i, Float.valueOf(this.data[i]));
        }
    }

    public void save(File file) {
        PrintWriter writer = PApplet.createWriter(file);
        this.write(writer);
        writer.close();
    }

    public void write(PrintWriter writer) {
        for (int i = 0; i < this.count; ++i) {
            writer.println(this.data[i]);
        }
        writer.flush();
    }

    public String toJSON() {
        return "[ " + this.join(", ") + " ]";
    }

    public String toString() {
        return this.getClass().getSimpleName() + " size=" + this.size() + " " + this.toJSON();
    }
}

