/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.utils;

import android.text.TextUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.utils.DoricContextHolder;
import pub.doric.utils.DoricLog;

public class DoricMetaInfo<T extends DoricContextHolder> {
    private Constructor<? extends T> pluginConstructor;
    private Map<String, Method> methodMap = new ConcurrentHashMap<String, Method>();
    private String name;

    public DoricMetaInfo(Class<? extends T> pluginClass) {
        try {
            Method[] methods;
            this.pluginConstructor = pluginClass.getDeclaredConstructor(DoricContext.class);
            DoricPlugin doricPlugin = pluginClass.getAnnotation(DoricPlugin.class);
            this.name = doricPlugin.name();
            for (Method method : methods = pluginClass.getMethods()) {
                DoricMethod doricMethod = method.getAnnotation(DoricMethod.class);
                if (doricMethod == null) continue;
                if (TextUtils.isEmpty((CharSequence)doricMethod.name())) {
                    this.methodMap.put(method.getName(), method);
                    continue;
                }
                this.methodMap.put(doricMethod.name(), method);
            }
        }
        catch (Exception e) {
            DoricLog.e("Error to create doric for " + e.getLocalizedMessage(), new Object[0]);
        }
    }

    public String getName() {
        return this.name;
    }

    public T createInstance(DoricContext doricContext) {
        try {
            return (T)((DoricContextHolder)this.pluginConstructor.newInstance(doricContext));
        }
        catch (Exception e) {
            DoricLog.e("Error to create doric plugin for " + e.getLocalizedMessage(), new Object[0]);
            return null;
        }
    }

    public Method getMethod(String name) {
        return this.methodMap.get(name);
    }
}

