/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.slider;

import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;
import pub.doric.shader.slider.SlideAdapter;

@DoricPlugin(name="Slider")
public class SliderNode
extends SuperNode<RecyclerView> {
    private final SlideAdapter slideAdapter = new SlideAdapter(this);
    private String onPageSlidedFuncId;
    private int lastPosition = 0;
    private int itemCount = 0;

    public SliderNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected RecyclerView build() {
        RecyclerView recyclerView = new RecyclerView(this.getContext());
        final LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        layoutManager.setOrientation(0);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        final PagerSnapHelper snapHelper = new PagerSnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        recyclerView.setAdapter((RecyclerView.Adapter)this.slideAdapter);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                View view;
                if (newState == 0 && (view = snapHelper.findSnapView((RecyclerView.LayoutManager)layoutManager)) != null) {
                    int position = layoutManager.getPosition(view);
                    if (((SliderNode)SliderNode.this).slideAdapter.loop) {
                        if (position == 0) {
                            recyclerView.scrollToPosition(((SliderNode)SliderNode.this).slideAdapter.itemCount);
                        } else if (position == ((SliderNode)SliderNode.this).slideAdapter.itemCount + 1) {
                            recyclerView.scrollToPosition(1);
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)SliderNode.this.onPageSlidedFuncId)) {
                        if (position != SliderNode.this.lastPosition) {
                            SliderNode.this.callJSResponse(SliderNode.this.onPageSlidedFuncId, position);
                        }
                        SliderNode.this.lastPosition = position;
                    }
                }
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
            }
        });
        return recyclerView;
    }

    @Override
    public ViewNode getSubNodeById(String id2) {
        RecyclerView.LayoutManager manager = ((RecyclerView)this.mView).getLayoutManager();
        if (manager == null) {
            return null;
        }
        for (int i = 0; i < manager.getChildCount(); ++i) {
            View view = manager.getChildAt(i);
            if (view == null) continue;
            SlideAdapter.DoricViewHolder viewHolder = (SlideAdapter.DoricViewHolder)((RecyclerView)this.mView).getChildViewHolder(view);
            if (!id2.equals(viewHolder.slideItemNode.getId())) continue;
            return viewHolder.slideItemNode;
        }
        return null;
    }

    @Override
    protected void blendSubNode(JSObject subProperties) {
        String viewId = subProperties.getProperty("id").asString().value();
        ViewNode node = this.getSubNodeById(viewId);
        if (node != null) {
            node.blend(subProperties.getProperty("props").asObject());
        } else {
            JSObject oldModel = this.getSubModel(viewId);
            if (oldModel != null) {
                this.recursiveMixin(subProperties, oldModel);
            }
            this.slideAdapter.blendSubNode(subProperties);
        }
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        if (this.mView != null) {
            ((RecyclerView)this.mView).post(new Runnable(){

                @Override
                public void run() {
                    ((SliderNode)SliderNode.this).slideAdapter.itemCount = SliderNode.this.itemCount;
                    SliderNode.this.slideAdapter.notifyDataSetChanged();
                }
            });
        }
    }

    @Override
    protected void blend(RecyclerView view, String name, JSValue prop) {
        switch (name) {
            case "itemCount": {
                this.itemCount = prop.asNumber().toInt();
                break;
            }
            case "renderPage": {
                String funcId = prop.asString().value();
                if (funcId.equals(this.slideAdapter.renderPageFuncId)) break;
                this.slideAdapter.itemValues.clear();
                this.clearSubModel();
                this.slideAdapter.renderPageFuncId = funcId;
                break;
            }
            case "batchCount": {
                this.slideAdapter.batchCount = prop.asNumber().toInt();
                break;
            }
            case "onPageSlided": {
                this.onPageSlidedFuncId = prop.asString().toString();
                break;
            }
            case "loop": {
                boolean loop;
                this.slideAdapter.loop = loop = prop.asBoolean().value().booleanValue();
                if (!loop) break;
                ((RecyclerView)this.mView).post(new Runnable(){

                    @Override
                    public void run() {
                        ((RecyclerView)SliderNode.this.mView).scrollToPosition(1);
                    }
                });
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }

    @DoricMethod
    public void slidePage(JSObject params, DoricPromise promise) {
        int page = params.getProperty("page").asNumber().toInt();
        boolean smooth = params.getProperty("smooth").asBoolean().value();
        if (smooth) {
            ((RecyclerView)this.mView).smoothScrollToPosition(page);
        } else {
            ((RecyclerView)this.mView).scrollToPosition(page);
        }
        if (!TextUtils.isEmpty((CharSequence)this.onPageSlidedFuncId)) {
            this.callJSResponse(this.onPageSlidedFuncId, page);
            this.lastPosition = page;
        }
        promise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public int getSlidedPage() {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)((RecyclerView)this.mView).getLayoutManager();
        return linearLayoutManager != null ? linearLayoutManager.findFirstVisibleItemPosition() : 0;
    }
}

