/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.slider;

import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSNull;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.async.AsyncResult;
import pub.doric.shader.ViewNode;
import pub.doric.shader.slider.SlideItemNode;
import pub.doric.shader.slider.SliderNode;

class SlideAdapter
extends RecyclerView.Adapter<DoricViewHolder> {
    private final SliderNode sliderNode;
    int itemCount = 0;
    int batchCount = 3;
    SparseArray<String> itemValues = new SparseArray();
    String renderPageFuncId;
    boolean loop;

    SlideAdapter(SliderNode sliderNode) {
        this.sliderNode = sliderNode;
    }

    @NonNull
    public DoricViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        SlideItemNode node = (SlideItemNode)ViewNode.create(this.sliderNode.getDoricContext(), "SlideItem");
        node.init(this.sliderNode);
        return new DoricViewHolder(node, node.getNodeView());
    }

    public void onBindViewHolder(@NonNull DoricViewHolder holder, int position) {
        JSValue jsValue = this.getItemModel(position);
        if (jsValue.isObject()) {
            JSObject jsObject = jsValue.asObject();
            holder.slideItemNode.setId(jsObject.getProperty("id").asString().value());
            holder.slideItemNode.blend(jsObject.getProperty("props").asObject());
        }
    }

    public int getItemCount() {
        if (this.loop) {
            return this.itemCount + 2;
        }
        return this.itemCount;
    }

    public int getItemViewType(int position) {
        JSValue value = this.getItemModel(position);
        if (value.isObject() && value.asObject().getProperty("identifier").isString()) {
            return value.asObject().getProperty("identifier").asString().value().hashCode();
        }
        return super.getItemViewType(position);
    }

    private JSValue getItemModel(int position) {
        int index = this.loop ? (position == 0 ? this.itemCount - 1 : (position == this.itemCount + 1 ? 0 : position - 1)) : position;
        String id2 = (String)this.itemValues.get(index);
        if (TextUtils.isEmpty((CharSequence)id2)) {
            AsyncResult<JSDecoder> asyncResult = this.sliderNode.callJSResponse("renderBunchedItems", index, this.batchCount);
            try {
                JSDecoder jsDecoder = asyncResult.synchronous().get();
                JSValue result = jsDecoder.decode();
                if (result.isArray()) {
                    JSArray jsArray = result.asArray();
                    for (int i = 0; i < jsArray.size(); ++i) {
                        JSObject itemModel = jsArray.get(i).asObject();
                        String itemId = itemModel.getProperty("id").asString().value();
                        this.itemValues.put(i + index, (Object)itemId);
                        this.sliderNode.setSubModel(itemId, itemModel);
                    }
                    return this.sliderNode.getSubModel((String)this.itemValues.get(index));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new JSNull();
        }
        JSObject childModel = this.sliderNode.getSubModel(id2);
        if (childModel == null) {
            return new JSNull();
        }
        return childModel;
    }

    void blendSubNode(JSObject subProperties) {
        for (int i = 0; i < this.itemValues.size(); ++i) {
            if (!subProperties.getProperty("id").asString().value().equals(this.itemValues.valueAt(i))) continue;
            this.notifyItemChanged(i);
        }
    }

    static class DoricViewHolder
    extends RecyclerView.ViewHolder {
        SlideItemNode slideItemNode;

        DoricViewHolder(SlideItemNode node, @NonNull View itemView) {
            super(itemView);
            this.slideItemNode = node;
        }
    }
}

