/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.slider;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.ArrayList;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.shader.GroupNode;
import pub.doric.shader.ViewNode;

@DoricPlugin(name="NestedSlider")
public class NestedSliderNode
extends GroupNode<ViewPager>
implements ViewPager.OnPageChangeListener {
    private ArrayList<View> slideItems = new ArrayList();
    private String onPageSlidedFuncId;

    public NestedSliderNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected ViewPager build() {
        ViewPager viewPager = new ViewPager(this.getContext());
        viewPager.setAdapter(new PagerAdapter(){

            public int getCount() {
                return NestedSliderNode.this.slideItems.size();
            }

            public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
                return view == object;
            }

            public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
                container.removeView((View)NestedSliderNode.this.slideItems.get(position));
            }

            @NonNull
            public Object instantiateItem(@NonNull ViewGroup container, int position) {
                container.addView((View)NestedSliderNode.this.slideItems.get(position));
                return NestedSliderNode.this.slideItems.get(position);
            }
        });
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        return viewPager;
    }

    @Override
    protected void blend(ViewPager view, String name, JSValue prop) {
        switch (name) {
            case "onPageSlided": {
                this.onPageSlidedFuncId = prop.asString().toString();
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }

    @Override
    protected void configChildNode() {
        for (int idx = 0; idx < this.mChildViewIds.size(); ++idx) {
            String id2 = (String)this.mChildViewIds.get(idx);
            JSObject model = this.getSubModel(id2);
            String type = model.getProperty("type").asString().value();
            if (idx < this.mChildNodes.size()) {
                ViewNode oldNode = (ViewNode)this.mChildNodes.get(idx);
                if (id2.equals(oldNode.getId())) continue;
                if (this.mReusable) {
                    if (oldNode.getType().equals(type)) {
                        oldNode.setId(id2);
                        oldNode.blend(model.getProperty("props").asObject());
                        continue;
                    }
                    this.mChildNodes.remove(idx);
                    this.slideItems.remove(oldNode.getNodeView());
                    ViewNode newNode = ViewNode.create(this.getDoricContext(), type);
                    newNode.setId(id2);
                    newNode.init(this);
                    newNode.blend(model.getProperty("props").asObject());
                    this.mChildNodes.add(idx, newNode);
                    this.slideItems.add(idx, newNode.getNodeView());
                    continue;
                }
                int position = -1;
                for (int start = idx + 1; start < this.mChildNodes.size(); ++start) {
                    ViewNode node = (ViewNode)this.mChildNodes.get(start);
                    if (!id2.equals(node.getId())) continue;
                    position = start;
                    break;
                }
                if (position >= 0) {
                    ViewNode reused = (ViewNode)this.mChildNodes.remove(position);
                    ViewNode abandoned = (ViewNode)this.mChildNodes.remove(idx);
                    this.mChildNodes.set(idx, reused);
                    this.mChildNodes.set(position, abandoned);
                    this.slideItems.remove(reused.getNodeView());
                    this.slideItems.add(idx, reused.getNodeView());
                    this.slideItems.remove(abandoned.getNodeView());
                    this.slideItems.add(position, abandoned.getNodeView());
                    continue;
                }
                ViewNode newNode = ViewNode.create(this.getDoricContext(), type);
                newNode.setId(id2);
                newNode.init(this);
                newNode.blend(model.getProperty("props").asObject());
                this.mChildNodes.add(idx, newNode);
                this.slideItems.add(idx, newNode.getNodeView());
                continue;
            }
            ViewNode newNode = ViewNode.create(this.getDoricContext(), type);
            newNode.setId(id2);
            newNode.init(this);
            newNode.blend(model.getProperty("props").asObject());
            this.mChildNodes.add(newNode);
            this.slideItems.add(idx, newNode.getNodeView());
        }
        int size = this.mChildNodes.size();
        for (int idx = this.mChildViewIds.size(); idx < size; ++idx) {
            ViewNode viewNode = (ViewNode)this.mChildNodes.remove(this.mChildViewIds.size());
            this.slideItems.remove(viewNode.getNodeView());
        }
        ((ViewPager)this.mView).getAdapter().notifyDataSetChanged();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (!TextUtils.isEmpty((CharSequence)this.onPageSlidedFuncId)) {
            this.callJSResponse(this.onPageSlidedFuncId, position);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    @DoricMethod
    public void slidePage(JSObject params, DoricPromise promise) {
        int page = params.getProperty("page").asNumber().toInt();
        boolean smooth = params.getProperty("smooth").asBoolean().value();
        ((ViewPager)this.mView).setCurrentItem(page, smooth);
        if (!TextUtils.isEmpty((CharSequence)this.onPageSlidedFuncId)) {
            this.callJSResponse(this.onPageSlidedFuncId, page);
        }
        promise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public int getSlidedPage() {
        return ((ViewPager)this.mView).getCurrentItem();
    }
}

