/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.richtext;

import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import java.util.ArrayDeque;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlParser
implements Html.TagHandler,
ContentHandler {
    private final TagHandler handler;
    private ContentHandler mInnerContentHandler;
    private Editable mEditable;
    private ArrayDeque<Boolean> tagStatus = new ArrayDeque();

    public static Spanned buildSpannedText(String html, Html.ImageGetter imageGetter, TagHandler handler) {
        return Html.fromHtml((String)("<inject/>" + html), (Html.ImageGetter)imageGetter, (Html.TagHandler)new HtmlParser(handler));
    }

    public static String getValue(Attributes attributes, String name) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(attributes.getLocalName(i))) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private HtmlParser(TagHandler handler) {
        this.handler = handler;
    }

    public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
        if (this.mInnerContentHandler == null) {
            this.mEditable = output;
            this.mInnerContentHandler = xmlReader.getContentHandler();
            xmlReader.setContentHandler(this);
            this.tagStatus.addLast(Boolean.FALSE);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mInnerContentHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.mInnerContentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.mInnerContentHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.mInnerContentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.mInnerContentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean isHandled = this.handler.handleTag(true, localName, this.mEditable, attributes);
        this.tagStatus.addLast(isHandled);
        if (!isHandled) {
            this.mInnerContentHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.tagStatus.removeLast().booleanValue()) {
            this.mInnerContentHandler.endElement(uri, localName, qName);
        }
        this.handler.handleTag(false, localName, this.mEditable, null);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mInnerContentHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.mInnerContentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.mInnerContentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.mInnerContentHandler.skippedEntity(name);
    }

    public static interface TagHandler {
        public boolean handleTag(boolean var1, String var2, Editable var3, Attributes var4);
    }
}

