/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.richtext;

import android.text.Editable;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import java.util.Stack;
import org.xml.sax.Attributes;
import pub.doric.shader.richtext.HtmlParser;

public class CustomTagHandler
implements HtmlParser.TagHandler {
    private Stack<Integer> startIndex = new Stack();
    private Stack<String> propertyValue = new Stack();

    @Override
    public boolean handleTag(boolean opening, String tag, Editable output, Attributes attributes) {
        if (opening) {
            this.handleStartTag(tag, output, attributes);
        } else {
            this.handleEndTag(tag, output, attributes);
        }
        return false;
    }

    private void handleStartTag(String tag, Editable output, Attributes attributes) {
        if (tag.equalsIgnoreCase("font")) {
            this.handleStartFont(output, attributes);
        }
    }

    private void handleEndTag(String tag, Editable output, Attributes attributes) {
        if (tag.equalsIgnoreCase("font")) {
            this.handleEndFont(output);
        }
    }

    private void handleStartFont(Editable output, Attributes attributes) {
        this.startIndex.push(output.length());
        this.propertyValue.push(HtmlParser.getValue(attributes, "size"));
    }

    private void handleEndFont(Editable output) {
        String val = this.propertyValue.pop();
        if (!TextUtils.isEmpty((CharSequence)val)) {
            int value = 12;
            try {
                value = Integer.parseInt(val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            switch (value) {
                case 1: {
                    value = 9;
                    break;
                }
                case 2: {
                    value = 10;
                    break;
                }
                case 4: {
                    value = 14;
                    break;
                }
                case 5: {
                    value = 18;
                    break;
                }
                case 6: {
                    value = 24;
                    break;
                }
                case 7: {
                    value = 36;
                    break;
                }
                default: {
                    value = 12;
                }
            }
            output.setSpan((Object)new AbsoluteSizeSpan(value, true), this.startIndex.pop().intValue(), output.length(), 33);
        }
    }
}

