/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.LinkedList;
import org.json.JSONObject;
import pub.doric.DoricContext;
import pub.doric.DoricRegistry;
import pub.doric.R;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.shader.DoricLayer;
import pub.doric.shader.HLayoutNode;
import pub.doric.shader.SuperNode;
import pub.doric.shader.VLayoutNode;
import pub.doric.utils.DoricContextHolder;
import pub.doric.utils.DoricLog;
import pub.doric.utils.DoricMetaInfo;
import pub.doric.utils.DoricUtils;

public abstract class ViewNode<T extends View>
extends DoricContextHolder {
    protected T mView;
    SuperNode mSuperNode;
    String mId;
    protected ViewGroup.LayoutParams mLayoutParams;
    private String mType;
    protected JSObject mFlexConfig;
    private DoricLayer doricLayer;
    private String[] animatedKeys = new String[]{"translationX", "translationY", "scaleX", "scaleY", "rotation"};

    public JSObject getFlexConfig() {
        return this.mFlexConfig;
    }

    public ViewNode(DoricContext doricContext) {
        super(doricContext);
    }

    public void init(SuperNode superNode) {
        if (this instanceof SuperNode) {
            ((SuperNode)this).mReusable = superNode.mReusable;
        }
        this.mSuperNode = superNode;
        this.mLayoutParams = superNode.generateDefaultLayoutParams();
        this.mView = this.build();
        this.mView.setTag(R.id.doric_node, (Object)this);
        this.mView.setLayoutParams(this.mLayoutParams);
    }

    public void init(ViewGroup.LayoutParams layoutParams) {
        this.mLayoutParams = layoutParams;
        this.mView = this.build();
        this.mView.setLayoutParams(layoutParams);
    }

    public void setId(String id2) {
        this.mId = id2;
    }

    public String getType() {
        if (TextUtils.isEmpty((CharSequence)this.mType)) {
            this.mType = this.getClass().getAnnotation(DoricPlugin.class).name();
        }
        return this.mType;
    }

    public T getView() {
        return this.mView;
    }

    public View getNodeView() {
        if (this.doricLayer != null) {
            return this.doricLayer;
        }
        return this.mView;
    }

    public Context getContext() {
        return this.getDoricContext().getContext();
    }

    protected abstract T build();

    public void blend(JSObject jsObject) {
        if (jsObject != null) {
            JSValue value = jsObject.getProperty("layoutConfig");
            if (value.isObject()) {
                this.setLayoutConfig(value.asObject());
            }
            for (String prop : jsObject.propertySet()) {
                this.blend(this.mView, prop, jsObject.getProperty(prop));
            }
        }
        if (this.doricLayer != null) {
            ViewGroup.LayoutParams params = this.mView.getLayoutParams();
            if (params != null) {
                params.width = this.mLayoutParams.width;
                params.height = this.mLayoutParams.height;
            } else {
                params = this.mLayoutParams;
            }
            if (this.mLayoutParams instanceof LinearLayout.LayoutParams && ((LinearLayout.LayoutParams)this.mLayoutParams).weight > 0.0f) {
                if (this.mSuperNode instanceof VLayoutNode) {
                    params.height = -1;
                } else if (this.mSuperNode instanceof HLayoutNode) {
                    params.width = -1;
                }
            }
            this.mView.setLayoutParams(params);
        }
    }

    protected void blend(T view, String name, JSValue prop) {
        switch (name) {
            case "width": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getWidth(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setWidth(prop.asNumber().toFloat());
                break;
            }
            case "height": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getHeight(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setHeight(prop.asNumber().toFloat());
                break;
            }
            case "x": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getX(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setX(prop.asNumber().toFloat());
                break;
            }
            case "y": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getY(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setY(prop.asNumber().toFloat());
                break;
            }
            case "backgroundColor": {
                if (this.isAnimating()) {
                    if (!prop.isNumber()) break;
                    ObjectAnimator animator = ObjectAnimator.ofInt((Object)this, (String)name, (int[])new int[]{this.getBackgroundColor(), prop.asNumber().toInt()});
                    animator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
                    this.addAnimator((Animator)animator);
                    break;
                }
                if (prop.isNumber()) {
                    this.setBackgroundColor(prop.asNumber().toInt());
                    break;
                }
                if (!prop.isObject()) break;
                final JSValue dict = prop;
                ShapeDrawable shapeDrawable = new ShapeDrawable();
                shapeDrawable.setShape((Shape)new RectShape());
                shapeDrawable.setShaderFactory(new ShapeDrawable.ShaderFactory(){

                    public Shader resize(int width, int height) {
                        JSValue orientation;
                        LinearGradient linearGradient = null;
                        int[] colors = null;
                        float[] locations = null;
                        if (dict.asObject().propertySet().contains("colors")) {
                            colors = dict.asObject().getProperty("colors").asArray().toIntArray();
                            if (dict.asObject().propertySet().contains("locations")) {
                                locations = dict.asObject().getProperty("locations").asArray().toFloatArray();
                            }
                        } else if (dict.asObject().propertySet().contains("start") && dict.asObject().propertySet().contains("end")) {
                            JSValue start = dict.asObject().getProperty("start");
                            JSValue end = dict.asObject().getProperty("end");
                            colors = new int[]{start.asNumber().toInt(), end.asNumber().toInt()};
                        }
                        if ((orientation = dict.asObject().getProperty("orientation")).isNumber()) {
                            switch (orientation.asNumber().toInt()) {
                                case 0: {
                                    linearGradient = new LinearGradient(0.0f, 0.0f, 0.0f, (float)height, colors, locations, Shader.TileMode.CLAMP);
                                    break;
                                }
                                case 1: {
                                    linearGradient = new LinearGradient((float)width, 0.0f, 0.0f, (float)height, colors, locations, Shader.TileMode.CLAMP);
                                    break;
                                }
                                case 2: {
                                    linearGradient = new LinearGradient((float)width, 0.0f, 0.0f, 0.0f, colors, locations, Shader.TileMode.CLAMP);
                                    break;
                                }
                                case 3: {
                                    linearGradient = new LinearGradient((float)width, (float)height, 0.0f, 0.0f, colors, locations, Shader.TileMode.CLAMP);
                                    break;
                                }
                                case 4: {
                                    linearGradient = new LinearGradient(0.0f, (float)height, 0.0f, 0.0f, colors, locations, Shader.TileMode.CLAMP);
                                    break;
                                }
                                case 5: {
                                    linearGradient = new LinearGradient(0.0f, (float)height, (float)width, 0.0f, colors, locations, Shader.TileMode.CLAMP);
                                    break;
                                }
                                case 6: {
                                    linearGradient = new LinearGradient(0.0f, 0.0f, (float)width, 0.0f, colors, locations, Shader.TileMode.CLAMP);
                                    break;
                                }
                                case 7: {
                                    linearGradient = new LinearGradient(0.0f, 0.0f, (float)width, (float)height, colors, locations, Shader.TileMode.CLAMP);
                                }
                            }
                        }
                        return linearGradient;
                    }
                });
                view.setBackground((Drawable)shapeDrawable);
                break;
            }
            case "onClick": {
                if (!prop.isString()) {
                    return;
                }
                final String functionId = prop.asString().value();
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ViewNode.this.callJSResponse(functionId, new Object[0]);
                    }
                });
                break;
            }
            case "border": {
                if (!prop.isObject()) break;
                this.requireDoricLayer().setBorder(DoricUtils.dp2px(prop.asObject().getProperty("width").asNumber().toFloat()), prop.asObject().getProperty("color").asNumber().toInt());
                this.requireDoricLayer().invalidate();
                break;
            }
            case "alpha": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getAlpha(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setAlpha(prop.asNumber().toFloat());
                break;
            }
            case "corners": {
                if (prop.isNumber()) {
                    if (this.isAnimating()) {
                        this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getCorners(), prop.asNumber().toFloat()}));
                        break;
                    }
                    this.setCorners(prop.asNumber().toFloat());
                    break;
                }
                if (!prop.isObject()) break;
                JSValue lt = prop.asObject().getProperty("leftTop");
                JSValue rt = prop.asObject().getProperty("rightTop");
                JSValue rb = prop.asObject().getProperty("rightBottom");
                JSValue lb = prop.asObject().getProperty("leftBottom");
                this.requireDoricLayer().setCornerRadius(DoricUtils.dp2px(lt.isNumber() ? lt.asNumber().toFloat() : 0.0f), DoricUtils.dp2px(rt.isNumber() ? rt.asNumber().toFloat() : 0.0f), DoricUtils.dp2px(rb.isNumber() ? rb.asNumber().toFloat() : 0.0f), DoricUtils.dp2px(lb.isNumber() ? lb.asNumber().toFloat() : 0.0f));
                break;
            }
            case "shadow": {
                if (!prop.isObject()) break;
                this.requireDoricLayer().setShadow(prop.asObject().getProperty("color").asNumber().toInt(), (int)(prop.asObject().getProperty("opacity").asNumber().toFloat() * 255.0f), DoricUtils.dp2px(prop.asObject().getProperty("radius").asNumber().toFloat()), DoricUtils.dp2px(prop.asObject().getProperty("offsetX").asNumber().toFloat()), DoricUtils.dp2px(prop.asObject().getProperty("offsetY").asNumber().toFloat()));
                break;
            }
            case "translationX": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getTranslationX(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setTranslationX(prop.asNumber().toFloat());
                break;
            }
            case "translationY": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getTranslationY(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setTranslationY(prop.asNumber().toFloat());
                break;
            }
            case "scaleX": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getScaleX(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setScaleX(prop.asNumber().toFloat());
                break;
            }
            case "scaleY": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getScaleY(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setScaleY(prop.asNumber().toFloat());
                break;
            }
            case "pivotX": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getPivotX(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setPivotX(prop.asNumber().toFloat());
                break;
            }
            case "pivotY": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getPivotY(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setPivotY(prop.asNumber().toFloat());
                break;
            }
            case "rotation": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getRotation(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setRotation(prop.asNumber().toFloat());
                break;
            }
            case "rotationX": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getRotationX(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setRotationX(prop.asNumber().toFloat());
                break;
            }
            case "rotationY": {
                if (!prop.isNumber()) {
                    return;
                }
                if (this.isAnimating()) {
                    this.addAnimator((Animator)ObjectAnimator.ofFloat((Object)this, (String)name, (float[])new float[]{this.getRotationY(), prop.asNumber().toFloat()}));
                    break;
                }
                this.setRotationY(prop.asNumber().toFloat());
                break;
            }
            case "padding": {
                if (!prop.isObject()) break;
                this.setPadding(prop.asObject());
                break;
            }
            case "hidden": {
                if (!prop.isBoolean()) break;
                this.getNodeView().setVisibility(prop.asBoolean().value() != false ? 8 : 0);
                break;
            }
            case "flexConfig": {
                if (!prop.isObject()) break;
                this.mFlexConfig = prop.asObject();
                break;
            }
            case "perspective": {
                if (!prop.isNumber()) break;
                this.getNodeView().setCameraDistance((float)this.getContext().getResources().getDisplayMetrics().densityDpi * prop.asNumber().toFloat() / 25.0f);
                break;
            }
        }
    }

    @NonNull
    private DoricLayer requireDoricLayer() {
        if (this.doricLayer == null) {
            this.doricLayer = new DoricLayer(this.getContext());
            this.doricLayer.setLayoutParams(this.mLayoutParams);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.mLayoutParams.width, this.mLayoutParams.height);
            if (this.mView.getParent() instanceof ViewGroup) {
                ViewGroup superview = (ViewGroup)this.mView.getParent();
                int index = superview.indexOfChild(this.mView);
                superview.removeView(this.mView);
                this.doricLayer.addView((View)this.mView, (ViewGroup.LayoutParams)params);
                superview.addView((View)this.doricLayer, index);
            } else {
                this.doricLayer.addView((View)this.mView, (ViewGroup.LayoutParams)params);
            }
            this.doricLayer.setTag(R.id.doric_node, this);
        }
        return this.doricLayer;
    }

    String[] getIdList() {
        LinkedList<String> ids = new LinkedList<String>();
        ViewNode viewNode = this;
        do {
            ids.push(viewNode.mId);
        } while ((viewNode = viewNode.mSuperNode) != null);
        return ids.toArray(new String[0]);
    }

    public AsyncResult<JSDecoder> callJSResponse(String funcId, Object ... args) {
        Object[] nArgs = new Object[args.length + 2];
        nArgs[0] = this.getIdList();
        nArgs[1] = funcId;
        if (args.length > 0) {
            System.arraycopy(args, 0, nArgs, 2, args.length);
        }
        return this.getDoricContext().callEntity("__response__", nArgs);
    }

    public static ViewNode create(DoricContext doricContext, String type) {
        DoricRegistry registry = doricContext.getDriver().getRegistry();
        DoricMetaInfo<ViewNode> clz = registry.acquireViewNodeInfo(type);
        ViewNode ret = clz.createInstance(doricContext);
        ret.mType = type;
        return ret;
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    public String getId() {
        return this.mId;
    }

    protected void setLayoutConfig(JSObject layoutConfig) {
        if (this.mSuperNode != null) {
            this.mSuperNode.blendSubLayoutConfig(this, layoutConfig);
        } else {
            this.blendLayoutConfig(layoutConfig);
        }
    }

    protected void setPadding(JSObject paddings) {
        JSValue left = paddings.getProperty("left");
        JSValue right = paddings.getProperty("right");
        JSValue top = paddings.getProperty("top");
        JSValue bottom = paddings.getProperty("bottom");
        this.mView.setPadding(left.isNumber() ? DoricUtils.dp2px(left.asNumber().toFloat()) : 0, top.isNumber() ? DoricUtils.dp2px(top.asNumber().toFloat()) : 0, right.isNumber() ? DoricUtils.dp2px(right.asNumber().toFloat()) : 0, bottom.isNumber() ? DoricUtils.dp2px(bottom.asNumber().toFloat()) : 0);
    }

    protected void blendLayoutConfig(JSObject jsObject) {
        JSValue minHeightValue;
        JSValue minWidthValue;
        JSValue jsValue;
        JSValue margin = jsObject.getProperty("margin");
        JSValue widthSpec = jsObject.getProperty("widthSpec");
        JSValue heightSpec = jsObject.getProperty("heightSpec");
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (widthSpec.isNumber()) {
            switch (widthSpec.asNumber().toInt()) {
                case 1: {
                    layoutParams.width = -2;
                    break;
                }
                case 2: {
                    layoutParams.width = -1;
                    break;
                }
                default: {
                    layoutParams.width = Math.max(0, layoutParams.width);
                }
            }
        }
        if (heightSpec.isNumber()) {
            switch (heightSpec.asNumber().toInt()) {
                case 1: {
                    layoutParams.height = -2;
                    break;
                }
                case 2: {
                    layoutParams.height = -1;
                    break;
                }
                default: {
                    layoutParams.height = Math.max(0, layoutParams.height);
                }
            }
        }
        if (margin.isObject() && layoutParams instanceof ViewGroup.MarginLayoutParams) {
            JSValue bottomVal;
            JSValue rightVal;
            JSValue leftVal;
            JSValue topVal = margin.asObject().getProperty("top");
            if (topVal.isNumber()) {
                ((ViewGroup.MarginLayoutParams)layoutParams).topMargin = DoricUtils.dp2px(topVal.asNumber().toFloat());
            }
            if ((leftVal = margin.asObject().getProperty("left")).isNumber()) {
                ((ViewGroup.MarginLayoutParams)layoutParams).leftMargin = DoricUtils.dp2px(leftVal.asNumber().toFloat());
            }
            if ((rightVal = margin.asObject().getProperty("right")).isNumber()) {
                ((ViewGroup.MarginLayoutParams)layoutParams).rightMargin = DoricUtils.dp2px(rightVal.asNumber().toFloat());
            }
            if ((bottomVal = margin.asObject().getProperty("bottom")).isNumber()) {
                ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin = DoricUtils.dp2px(bottomVal.asNumber().toFloat());
            }
        }
        if ((jsValue = jsObject.getProperty("alignment")).isNumber() && layoutParams instanceof FrameLayout.LayoutParams) {
            ((FrameLayout.LayoutParams)layoutParams).gravity = jsValue.asNumber().toInt();
        }
        if ((minWidthValue = jsObject.getProperty("minWidth")).isNumber()) {
            this.mView.setMinimumWidth(DoricUtils.dp2px(minWidthValue.asNumber().toFloat()));
        }
        if ((minHeightValue = jsObject.getProperty("minHeight")).isNumber()) {
            this.mView.setMinimumHeight(DoricUtils.dp2px(minHeightValue.asNumber().toFloat()));
        }
    }

    protected boolean isAnimating() {
        return this.getDoricContext().getAnimatorSet() != null;
    }

    protected void addAnimator(Animator animator) {
        if (this.getDoricContext().getAnimatorSet() == null) {
            return;
        }
        this.getDoricContext().getAnimatorSet().play(animator);
    }

    @DoricMethod
    public float getWidth() {
        if (this.mLayoutParams.width >= 0) {
            return DoricUtils.px2dp(this.mLayoutParams.width);
        }
        return DoricUtils.px2dp(this.mView.getMeasuredWidth());
    }

    @DoricMethod
    public float getHeight() {
        if (this.mLayoutParams.width >= 0) {
            return DoricUtils.px2dp(this.mLayoutParams.height);
        }
        return DoricUtils.px2dp(this.mView.getMeasuredHeight());
    }

    @DoricMethod
    public void setWidth(float width) {
        if (this.mLayoutParams.width >= 0) {
            this.mLayoutParams.width = DoricUtils.dp2px(width);
            if (this.mView.getLayoutParams() != this.mLayoutParams) {
                this.mView.getLayoutParams().width = this.mLayoutParams.width;
            }
            this.getNodeView().requestLayout();
        }
    }

    @DoricMethod
    public void setHeight(float height) {
        if (this.mLayoutParams.height >= 0) {
            this.mLayoutParams.height = DoricUtils.dp2px(height);
            if (this.mView.getLayoutParams() != this.mLayoutParams) {
                this.mView.getLayoutParams().height = this.mLayoutParams.height;
            }
            this.getNodeView().requestLayout();
        }
    }

    @DoricMethod
    public void setX(float x) {
        if (this.mLayoutParams instanceof ViewGroup.MarginLayoutParams) {
            ((ViewGroup.MarginLayoutParams)this.mLayoutParams).leftMargin = DoricUtils.dp2px(x);
            this.getNodeView().requestLayout();
        }
    }

    @DoricMethod
    public void setY(float y) {
        if (this.mLayoutParams instanceof ViewGroup.MarginLayoutParams) {
            ((ViewGroup.MarginLayoutParams)this.mLayoutParams).topMargin = DoricUtils.dp2px(y);
            this.getNodeView().requestLayout();
        }
    }

    @DoricMethod
    public float getX() {
        if (this.mLayoutParams instanceof ViewGroup.MarginLayoutParams) {
            return DoricUtils.px2dp(((ViewGroup.MarginLayoutParams)this.mLayoutParams).leftMargin);
        }
        return DoricUtils.px2dp(this.mView.getLeft());
    }

    @DoricMethod
    public float getY() {
        if (this.mLayoutParams instanceof ViewGroup.MarginLayoutParams) {
            return DoricUtils.px2dp(((ViewGroup.MarginLayoutParams)this.mLayoutParams).topMargin);
        }
        return DoricUtils.px2dp(this.mView.getTop());
    }

    @DoricMethod
    public int getBackgroundColor() {
        if (this.mView.getBackground() instanceof ColorDrawable) {
            return ((ColorDrawable)this.mView.getBackground()).getColor();
        }
        return 0;
    }

    @DoricMethod
    public void setBackgroundColor(int color) {
        this.mView.setBackgroundColor(color);
    }

    @DoricMethod
    public void setAlpha(float alpha) {
        this.getNodeView().setAlpha(alpha);
    }

    @DoricMethod
    public float getAlpha() {
        return this.getNodeView().getAlpha();
    }

    @DoricMethod
    public void setCorners(float corner) {
        this.requireDoricLayer().setCornerRadius(DoricUtils.dp2px(corner));
        this.getNodeView().invalidate();
    }

    @DoricMethod
    public float getCorners() {
        return DoricUtils.px2dp((int)this.requireDoricLayer().getCornerRadius());
    }

    @DoricMethod
    public void setTranslationX(float v) {
        this.getNodeView().setTranslationX((float)DoricUtils.dp2px(v));
    }

    @DoricMethod
    public float getTranslationX() {
        return DoricUtils.px2dp((int)this.getNodeView().getTranslationX());
    }

    @DoricMethod
    public void setTranslationY(float v) {
        this.getNodeView().setTranslationY((float)DoricUtils.dp2px(v));
    }

    @DoricMethod
    public float getTranslationY() {
        return DoricUtils.px2dp((int)this.getNodeView().getTranslationY());
    }

    @DoricMethod
    public void setScaleX(float v) {
        this.getNodeView().setScaleX(v);
    }

    @DoricMethod
    public float getScaleX() {
        return this.getNodeView().getScaleX();
    }

    @DoricMethod
    public void setScaleY(float v) {
        this.getNodeView().setScaleY(v);
    }

    @DoricMethod
    public float getScaleY() {
        return this.getNodeView().getScaleY();
    }

    @DoricMethod
    public void setRotation(float rotation) {
        this.getNodeView().setRotation(rotation * 180.0f);
    }

    @DoricMethod
    public float getRotation() {
        return this.getNodeView().getRotation() / 180.0f;
    }

    @DoricMethod
    public void setRotationX(float rotation) {
        this.getNodeView().setRotationX(rotation * 180.0f);
    }

    @DoricMethod
    public float getRotationX() {
        return this.getNodeView().getRotationX() / 180.0f;
    }

    @DoricMethod
    public void setRotationY(float rotation) {
        this.getNodeView().setRotationY(rotation * 180.0f);
    }

    @DoricMethod
    public float getRotationY() {
        return this.getNodeView().getRotationY() / 180.0f;
    }

    @DoricMethod
    public void setPivotX(float v) {
        this.getNodeView().setPivotX(v * (float)this.getNodeView().getWidth());
    }

    @DoricMethod
    public float getPivotX() {
        return this.getNodeView().getPivotX() / (float)this.getNodeView().getWidth();
    }

    @DoricMethod
    public void setPivotY(float v) {
        this.getNodeView().setPivotY(v * (float)this.getNodeView().getHeight());
    }

    @DoricMethod
    public float getPivotY() {
        return this.getNodeView().getPivotY() / (float)this.getNodeView().getHeight();
    }

    @DoricMethod
    public void doAnimation(JSValue value, final DoricPromise promise) {
        Animator animator = this.parseAnimator(value);
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    JSONBuilder jsonBuilder = new JSONBuilder();
                    for (String key : ViewNode.this.animatedKeys) {
                        jsonBuilder.put(key, (Object)Float.valueOf(ViewNode.this.getAnimatedValue(key)));
                    }
                    promise.resolve(new JavaValue(jsonBuilder.toJSONObject()));
                }
            });
            animator.start();
        }
    }

    private Animator parseAnimator(JSValue value) {
        if (!value.isObject()) {
            DoricLog.e("parseAnimator error", new Object[0]);
            return null;
        }
        JSValue animations = value.asObject().getProperty("animations");
        if (animations.isArray()) {
            AnimatorSet animatorSet = new AnimatorSet();
            for (int i = 0; i < animations.asArray().size(); ++i) {
                animatorSet.play(this.parseAnimator(animations.asArray().get(i)));
            }
            JSValue delayJS = value.asObject().getProperty("delay");
            if (delayJS.isNumber()) {
                animatorSet.setStartDelay(delayJS.asNumber().toLong());
            }
            return animatorSet;
        }
        if (value.isObject()) {
            JSArray changeables = value.asObject().getProperty("changeables").asArray();
            AnimatorSet animatorSet = new AnimatorSet();
            JSValue repeatCount = value.asObject().getProperty("repeatCount");
            JSValue repeatMode = value.asObject().getProperty("repeatMode");
            JSValue fillMode = value.asObject().getProperty("fillMode");
            JSValue timingFunction = value.asObject().getProperty("timingFunction");
            for (int j = 0; j < changeables.size(); ++j) {
                ObjectAnimator animator = this.parseChangeable(changeables.get(j).asObject(), fillMode);
                if (repeatCount.isNumber()) {
                    animator.setRepeatCount(repeatCount.asNumber().toInt());
                }
                if (repeatMode.isNumber()) {
                    animator.setRepeatMode(repeatMode.asNumber().toInt());
                }
                if (timingFunction.isNumber()) {
                    animator.setInterpolator((TimeInterpolator)this.getTimingInterpolator(timingFunction.asNumber().toInt()));
                }
                animatorSet.play((Animator)animator);
            }
            long duration = value.asObject().getProperty("duration").asNumber().toLong();
            animatorSet.setDuration(duration);
            JSValue delayJS = value.asObject().getProperty("delay");
            if (delayJS.isNumber()) {
                animatorSet.setStartDelay(delayJS.asNumber().toLong());
            }
            return animatorSet;
        }
        return null;
    }

    private Interpolator getTimingInterpolator(int timingFunction) {
        switch (timingFunction) {
            case 1: {
                return new LinearInterpolator();
            }
            case 2: {
                return new AccelerateInterpolator();
            }
            case 3: {
                return new DecelerateInterpolator();
            }
            case 4: {
                return new FastOutSlowInInterpolator();
            }
        }
        return new AccelerateDecelerateInterpolator();
    }

    private ObjectAnimator parseChangeable(JSObject jsObject, JSValue fillMode) {
        String key = jsObject.getProperty("key").asString().value();
        float startVal = jsObject.getProperty("fromValue").asNumber().toFloat();
        float endVal = jsObject.getProperty("toValue").asNumber().toFloat();
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this, (String)key, (float[])new float[]{startVal, endVal});
        this.setFillMode(animator, key, startVal, endVal, fillMode);
        return animator;
    }

    private void setFillMode(ObjectAnimator animator, final String key, float startVal, float endVal, JSValue jsValue) {
        int fillMode = 0;
        if (jsValue.isNumber()) {
            fillMode = jsValue.asNumber().toInt();
        }
        if ((fillMode & 2) == 2) {
            this.setAnimatedValue(key, startVal);
        }
        final int finalFillMode = fillMode;
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            private float originVal;

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                this.originVal = ViewNode.this.getAnimatedValue(key);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if ((finalFillMode & 1) != 1) {
                    ViewNode.this.setAnimatedValue(key, this.originVal);
                }
            }
        });
    }

    private void setAnimatedValue(String key, float value) {
        switch (key) {
            case "translationX": {
                this.setTranslationX(value);
                break;
            }
            case "translationY": {
                this.setTranslationY(value);
                break;
            }
            case "scaleX": {
                this.setScaleX(value);
                break;
            }
            case "scaleY": {
                this.setScaleY(value);
                break;
            }
            case "rotation": {
                this.setRotation(value);
                break;
            }
        }
    }

    private float getAnimatedValue(String key) {
        switch (key) {
            case "translationX": {
                return this.getTranslationX();
            }
            case "translationY": {
                return this.getTranslationY();
            }
            case "scaleX": {
                return this.getScaleX();
            }
            case "scaleY": {
                return this.getScaleY();
            }
            case "rotation": {
                return this.getRotation();
            }
        }
        return 0.0f;
    }

    @DoricMethod
    public JSONObject getLocationOnScreen() {
        int[] position = new int[2];
        this.getNodeView().getLocationOnScreen(position);
        return new JSONBuilder().put("x", (Object)Float.valueOf(DoricUtils.px2dp(position[0]))).put("y", (Object)Float.valueOf(DoricUtils.px2dp(position[1]))).toJSONObject();
    }
}

