/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.content.res.ColorStateList;
import android.widget.CompoundButton;
import androidx.appcompat.widget.SwitchCompat;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.ViewNode;

@DoricPlugin(name="Switch")
public class SwitchNode
extends ViewNode<SwitchCompat> {
    private int offTintColor = -1644826;
    private int onTintColor = -11348119;
    private int thumbTintColor = -1;

    public SwitchNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected SwitchCompat build() {
        return new SwitchCompat(this.getContext());
    }

    @Override
    protected void blend(SwitchCompat view, String name, JSValue prop) {
        switch (name) {
            case "state": {
                if (!prop.isBoolean()) {
                    return;
                }
                view.setChecked(prop.asBoolean().value().booleanValue());
                break;
            }
            case "onSwitch": {
                if (!prop.isString()) {
                    return;
                }
                final String callbackId = prop.asString().value();
                view.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        SwitchNode.this.callJSResponse(callbackId, isChecked);
                    }
                });
                break;
            }
            case "offTintColor": {
                if (!prop.isNumber()) {
                    return;
                }
                this.offTintColor = prop.asNumber().toInt();
                break;
            }
            case "onTintColor": {
                if (!prop.isNumber()) {
                    return;
                }
                this.onTintColor = prop.asNumber().toInt();
                break;
            }
            case "thumbTintColor": {
                if (!prop.isNumber()) {
                    return;
                }
                this.thumbTintColor = prop.asNumber().toInt();
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }

    @DoricMethod
    public boolean getState() {
        return ((SwitchCompat)this.mView).isChecked();
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        ColorStateList thumbTintList = new ColorStateList((int[][])new int[][]{{0x10100A0}, new int[0]}, new int[]{this.thumbTintColor, this.thumbTintColor});
        ColorStateList trackTintList = new ColorStateList((int[][])new int[][]{{0x10100A0}, new int[0]}, new int[]{this.onTintColor, this.offTintColor});
        ((SwitchCompat)this.mView).setThumbTintList(thumbTintList);
        ((SwitchCompat)this.mView).setTrackTintList(trackTintList);
    }
}

