/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.DoricScrollChangeListener;
import pub.doric.IDoricScrollable;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricJSDispatcher;
import pub.doric.utils.DoricUtils;
import pub.doric.widget.HVScrollView;

@DoricPlugin(name="Scroller")
public class ScrollerNode
extends SuperNode<HVScrollView>
implements IDoricScrollable {
    private String mChildViewId;
    private ViewNode mChildNode;
    private Set<DoricScrollChangeListener> listeners = new HashSet<DoricScrollChangeListener>();
    private String onScrollFuncId;
    private String onScrollEndFuncId;
    private DoricJSDispatcher jsDispatcher = new DoricJSDispatcher();

    public ScrollerNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected void blendLayoutConfig(JSObject jsObject) {
        JSValue maxHeight;
        super.blendLayoutConfig(jsObject);
        JSValue maxWidth = jsObject.getProperty("maxWidth");
        if (maxWidth.isNumber()) {
            ((MaximumScrollView)this.mView).maxWidth = DoricUtils.dp2px(maxWidth.asNumber().toFloat());
        }
        if ((maxHeight = jsObject.getProperty("maxHeight")).isNumber()) {
            ((MaximumScrollView)this.mView).maxHeight = DoricUtils.dp2px(maxHeight.asNumber().toFloat());
        }
    }

    @Override
    public ViewNode getSubNodeById(String id2) {
        return id2.equals(this.mChildNode.getId()) ? this.mChildNode : null;
    }

    @Override
    protected void blendSubNode(JSObject subProperties) {
        if (this.mChildNode != null) {
            this.mChildNode.blend(subProperties.getProperty("props").asObject());
        }
    }

    @Override
    protected HVScrollView build() {
        MaximumScrollView hvScrollView = new MaximumScrollView(this.getContext());
        hvScrollView.setOnScrollChangeListener(new HVScrollView.OnScrollChangeListener(){

            @Override
            public void onScrollChange(HVScrollView v, final int scrollX, final int scrollY, int oldScrollX, int oldScrollY) {
                for (DoricScrollChangeListener listener : ScrollerNode.this.listeners) {
                    listener.onScrollChange((View)v, scrollX, scrollY, oldScrollX, oldScrollY);
                }
                if (!TextUtils.isEmpty((CharSequence)ScrollerNode.this.onScrollFuncId) && !TextUtils.isEmpty((CharSequence)ScrollerNode.this.onScrollFuncId)) {
                    ScrollerNode.this.jsDispatcher.dispatch(new Callable<AsyncResult>(){

                        @Override
                        public AsyncResult call() throws Exception {
                            return ScrollerNode.this.callJSResponse(ScrollerNode.this.onScrollFuncId, new JSONBuilder().put("x", (Object)Float.valueOf(DoricUtils.px2dp(scrollX))).put("y", (Object)Float.valueOf(DoricUtils.px2dp(scrollY))).toJSONObject());
                        }
                    });
                }
            }

            @Override
            public void onScrollEnd(HVScrollView v, int scrollX, int scrollY) {
                if (!TextUtils.isEmpty((CharSequence)ScrollerNode.this.onScrollEndFuncId)) {
                    ScrollerNode.this.callJSResponse(ScrollerNode.this.onScrollEndFuncId, new JSONBuilder().put("x", (Object)Float.valueOf(DoricUtils.px2dp(scrollX))).put("y", (Object)Float.valueOf(DoricUtils.px2dp(scrollY))).toJSONObject());
                }
            }
        });
        return hvScrollView;
    }

    @Override
    protected void blend(HVScrollView view, String name, JSValue prop) {
        if ("content".equals(name)) {
            if (!prop.isString()) {
                return;
            }
            this.mChildViewId = prop.asString().value();
        } else if ("onScroll".equals(name)) {
            if (!prop.isString()) {
                return;
            }
            this.onScrollFuncId = prop.asString().value();
        } else if ("onScrollEnd".equals(name)) {
            if (!prop.isString()) {
                return;
            }
            this.onScrollEndFuncId = prop.asString().value();
        } else {
            super.blend(view, name, prop);
        }
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        JSObject contentModel = this.getSubModel(this.mChildViewId);
        if (contentModel == null) {
            return;
        }
        String viewId = contentModel.getProperty("id").asString().value();
        String type = contentModel.getProperty("type").asString().value();
        JSObject props = contentModel.getProperty("props").asObject();
        if (this.mChildNode != null) {
            if (!this.mChildNode.getId().equals(viewId)) {
                if (this.mReusable && type.equals(this.mChildNode.getType())) {
                    this.mChildNode.setId(viewId);
                    this.mChildNode.blend(props);
                } else {
                    ((HVScrollView)this.mView).removeAllViews();
                    this.mChildNode = ViewNode.create(this.getDoricContext(), type);
                    this.mChildNode.setId(viewId);
                    this.mChildNode.init(this);
                    this.mChildNode.blend(props);
                    ((HVScrollView)this.mView).addView(this.mChildNode.getNodeView());
                }
            }
        } else {
            this.mChildNode = ViewNode.create(this.getDoricContext(), type);
            this.mChildNode.setId(viewId);
            this.mChildNode.init(this);
            this.mChildNode.blend(props);
            ((HVScrollView)this.mView).addView(this.mChildNode.getNodeView());
        }
        if (jsObject.getProperty("contentOffset").isObject()) {
            JSObject offset = jsObject.getProperty("contentOffset").asObject();
            ((HVScrollView)this.mView).scrollTo(DoricUtils.dp2px(offset.getProperty("x").asNumber().toFloat()), DoricUtils.dp2px(offset.getProperty("y").asNumber().toFloat()));
        }
    }

    @Override
    public void addScrollChangeListener(DoricScrollChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeScrollChangeListener(DoricScrollChangeListener listener) {
        this.listeners.remove(listener);
    }

    @DoricMethod
    public void scrollTo(JSObject params) {
        boolean animated = false;
        if (params.getProperty("animated").isBoolean()) {
            animated = params.getProperty("animated").asBoolean().value();
        }
        JSObject offset = params.getProperty("offset").asObject();
        if (animated) {
            ((HVScrollView)this.mView).smoothScrollTo(DoricUtils.dp2px(offset.getProperty("x").asNumber().toFloat()), DoricUtils.dp2px(offset.getProperty("y").asNumber().toFloat()));
        } else {
            ((HVScrollView)this.mView).scrollTo(DoricUtils.dp2px(offset.getProperty("x").asNumber().toFloat()), DoricUtils.dp2px(offset.getProperty("y").asNumber().toFloat()));
        }
    }

    @DoricMethod
    public void scrollBy(JSObject params) {
        boolean animated = false;
        if (params.getProperty("animated").isBoolean()) {
            animated = params.getProperty("animated").asBoolean().value();
        }
        JSObject offset = params.getProperty("offset").asObject();
        if (animated) {
            ((HVScrollView)this.mView).smoothScrollBy(DoricUtils.dp2px(offset.getProperty("x").asNumber().toFloat()), DoricUtils.dp2px(offset.getProperty("y").asNumber().toFloat()));
        } else {
            ((HVScrollView)this.mView).scrollBy(DoricUtils.dp2px(offset.getProperty("x").asNumber().toFloat()), DoricUtils.dp2px(offset.getProperty("y").asNumber().toFloat()));
        }
    }

    private static class MaximumScrollView
    extends HVScrollView {
        private int maxWidth = Integer.MAX_VALUE;
        private int maxHeight = Integer.MAX_VALUE;

        public MaximumScrollView(Context context) {
            super(context);
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            if (width > this.maxWidth || height > this.maxHeight) {
                width = Math.min(width, this.maxWidth);
                height = Math.min(height, this.maxHeight);
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }
}

