/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.StackNode;
import pub.doric.utils.DoricUtils;

@DoricPlugin(name="Draggable")
public class DraggableNode
extends StackNode {
    private String onDrag;

    public DraggableNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected FrameLayout build() {
        return new DraggableView(this.getContext());
    }

    @Override
    protected void blend(FrameLayout view, String name, JSValue prop) {
        if ("onDrag".equals(name)) {
            this.onDrag = prop.isString() ? prop.asString().value() : null;
        } else {
            super.blend(view, name, prop);
        }
    }

    private class DraggableView
    extends FrameLayout {
        private int lastX;
        private int lastY;

        public DraggableView(Context context) {
            super(context);
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouchEvent(MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.lastX = x;
                    this.lastY = y;
                    break;
                }
                case 2: {
                    int offsetX = x - this.lastX;
                    int offsetY = y - this.lastY;
                    this.layout(this.getLeft() + offsetX, this.getTop() + offsetY, this.getRight() + offsetX, this.getBottom() + offsetY);
                    break;
                }
            }
            DraggableNode.this.callJSResponse(DraggableNode.this.onDrag, Float.valueOf(DoricUtils.px2dp(event.getRawX() - (float)x)), Float.valueOf(DoricUtils.px2dp(event.getRawY() - (float)y)));
            return true;
        }
    }
}

