/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.refresh;

import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.refresh.DoricSwipeLayout;
import pub.doric.refresh.PullingListener;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;

@DoricPlugin(name="Refreshable")
public class RefreshableNode
extends SuperNode<DoricSwipeLayout>
implements PullingListener {
    private String mContentViewId;
    private ViewNode mContentNode;
    private String mHeaderViewId;
    private ViewNode mHeaderNode;

    public RefreshableNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected DoricSwipeLayout build() {
        DoricSwipeLayout doricSwipeLayout = new DoricSwipeLayout(this.getContext());
        doricSwipeLayout.getRefreshView().setPullingListener(this);
        return doricSwipeLayout;
    }

    @Override
    protected void blend(DoricSwipeLayout view, String name, JSValue prop) {
        if ("content".equals(name)) {
            if (!prop.isString()) {
                return;
            }
            this.mContentViewId = prop.asString().value();
        } else if ("header".equals(name)) {
            if (!prop.isString()) {
                return;
            }
            this.mHeaderViewId = prop.asString().value();
        } else if ("onRefresh".equals(name)) {
            if (!prop.isString()) {
                return;
            }
            final String funcId = prop.asString().value();
            ((DoricSwipeLayout)this.mView).setOnRefreshListener(new DoricSwipeLayout.OnRefreshListener(){

                @Override
                public void onRefresh() {
                    RefreshableNode.this.callJSResponse(funcId, new Object[0]);
                }
            });
        } else {
            super.blend(view, name, prop);
        }
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        this.blendContentNode();
        this.blendHeadNode();
    }

    private void blendContentNode() {
        JSObject contentModel = this.getSubModel(this.mContentViewId);
        if (contentModel == null) {
            return;
        }
        String viewId = contentModel.getProperty("id").asString().value();
        String type = contentModel.getProperty("type").asString().value();
        JSObject props = contentModel.getProperty("props").asObject();
        if (this.mContentNode != null) {
            if (!this.mContentNode.getId().equals(viewId)) {
                if (this.mReusable && type.equals(this.mContentNode.getType())) {
                    this.mContentNode.setId(viewId);
                    this.mContentNode.blend(props);
                } else {
                    ((DoricSwipeLayout)this.mView).removeAllViews();
                    this.mContentNode = ViewNode.create(this.getDoricContext(), type);
                    this.mContentNode.setId(viewId);
                    this.mContentNode.init(this);
                    this.mContentNode.blend(props);
                    ((DoricSwipeLayout)this.mView).addView(this.mContentNode.getNodeView());
                }
            }
        } else {
            this.mContentNode = ViewNode.create(this.getDoricContext(), type);
            this.mContentNode.setId(viewId);
            this.mContentNode.init(this);
            this.mContentNode.blend(props);
            ((DoricSwipeLayout)this.mView).addView(this.mContentNode.getNodeView());
        }
    }

    private void blendHeadNode() {
        JSObject headerModel = this.getSubModel(this.mHeaderViewId);
        if (headerModel == null) {
            return;
        }
        String viewId = headerModel.getProperty("id").asString().value();
        String type = headerModel.getProperty("type").asString().value();
        JSObject props = headerModel.getProperty("props").asObject();
        if (this.mHeaderNode != null) {
            if (!this.mHeaderNode.getId().equals(viewId)) {
                if (this.mReusable && type.equals(this.mHeaderNode.getType())) {
                    this.mHeaderNode.setId(viewId);
                    this.mHeaderNode.blend(props);
                } else {
                    this.mHeaderNode = ViewNode.create(this.getDoricContext(), type);
                    this.mHeaderNode.setId(viewId);
                    this.mHeaderNode.init(this);
                    this.mHeaderNode.blend(props);
                    ((DoricSwipeLayout)this.mView).getRefreshView().setContent(this.mHeaderNode.getNodeView());
                }
            }
        } else {
            this.mHeaderNode = ViewNode.create(this.getDoricContext(), type);
            this.mHeaderNode.setId(viewId);
            this.mHeaderNode.init(this);
            this.mHeaderNode.blend(props);
            ((DoricSwipeLayout)this.mView).getRefreshView().setContent(this.mHeaderNode.getNodeView());
        }
    }

    @Override
    public ViewNode getSubNodeById(String id2) {
        if (id2.equals(this.mContentViewId)) {
            return this.mContentNode;
        }
        if (id2.equals(this.mHeaderViewId)) {
            return this.mHeaderNode;
        }
        return null;
    }

    @Override
    protected void blendSubNode(JSObject subProperties) {
        String viewId = subProperties.getProperty("id").asString().value();
        ViewNode node = this.getSubNodeById(viewId);
        if (node != null) {
            node.blend(subProperties.getProperty("props").asObject());
        }
    }

    @DoricMethod
    public void setRefreshable(JSValue jsValue, DoricPromise doricPromise) {
        boolean refreshable = jsValue.asBoolean().value();
        ((DoricSwipeLayout)this.mView).setEnabled(refreshable);
        doricPromise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public void setRefreshing(JSValue jsValue, DoricPromise doricPromise) {
        boolean refreshing = jsValue.asBoolean().value();
        ((DoricSwipeLayout)this.mView).setRefreshing(refreshing);
        doricPromise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public void isRefreshable(DoricPromise doricPromise) {
        doricPromise.resolve(new JavaValue(((DoricSwipeLayout)this.mView).isEnabled()));
    }

    @DoricMethod
    public void isRefreshing(DoricPromise doricPromise) {
        doricPromise.resolve(new JavaValue(((DoricSwipeLayout)this.mView).isRefreshing()));
    }

    @Override
    public void startAnimation() {
        if (this.mHeaderNode != null) {
            this.mHeaderNode.callJSResponse("startAnimation", new Object[0]);
        }
    }

    @Override
    public void stopAnimation() {
        if (this.mHeaderNode != null) {
            this.mHeaderNode.callJSResponse("stopAnimation", new Object[0]);
        }
    }

    @Override
    public void setPullingDistance(float rotation) {
        if (this.mHeaderNode != null) {
            this.mHeaderNode.callJSResponse("setPullingDistance", Float.valueOf(rotation));
        }
    }
}

