/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.refresh;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import android.widget.ListView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import androidx.core.widget.ListViewCompat;
import pub.doric.refresh.DoricRefreshView;
import pub.doric.utils.DoricUtils;

public class DoricSwipeLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    public static final int LARGE = 0;
    public static final int DEFAULT = 1;
    public static final int DEFAULT_SLINGSHOT_DISTANCE = -1;
    @VisibleForTesting
    static final int CIRCLE_DIAMETER = 40;
    @VisibleForTesting
    static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final String LOG_TAG = DoricSwipeLayout.class.getSimpleName();
    private static final int MAX_ALPHA = 255;
    private static final int STARTING_PROGRESS_ALPHA = 76;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final int INVALID_POINTER = -1;
    private static final float DRAG_RATE = 0.5f;
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    private static final int SCALE_DOWN_DURATION = 150;
    private static final int ALPHA_ANIMATION_DURATION = 300;
    private static final int ANIMATE_TO_TRIGGER_DURATION = 200;
    private static final int ANIMATE_TO_START_DURATION = 200;
    private static final int DEFAULT_CIRCLE_TARGET = 64;
    private View mTarget;
    OnRefreshListener mListener;
    boolean mRefreshing = false;
    private int mTouchSlop;
    private float mTotalDragDistance = -1.0f;
    private float mTotalUnconsumed;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private boolean mNestedScrollInProgress;
    private int mMediumAnimationDuration;
    int mCurrentTargetOffsetTop;
    private float mInitialMotionY;
    private float mInitialDownY;
    private boolean mIsBeingDragged;
    private int mActivePointerId = -1;
    private boolean mReturningToStart;
    private final DecelerateInterpolator mDecelerateInterpolator;
    private static final int[] LAYOUT_ATTRS = new int[]{0x101000E};
    private int mCircleViewIndex = -1;
    protected int mFrom;
    float mStartingScale;
    protected int mOriginalOffsetTop;
    int mSpinnerOffsetEnd;
    int mCustomSlingshotDistance;
    boolean mNotify;
    boolean mUsingCustomStart;
    private OnChildScrollUpCallback mChildScrollUpCallback;
    private DoricRefreshView mRefreshView;
    private Animation.AnimationListener mRefreshListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (DoricSwipeLayout.this.mRefreshing) {
                DoricSwipeLayout.this.mRefreshView.startAnimation();
                if (DoricSwipeLayout.this.mNotify && DoricSwipeLayout.this.mListener != null) {
                    DoricSwipeLayout.this.mListener.onRefresh();
                }
                DoricSwipeLayout.this.mCurrentTargetOffsetTop = DoricSwipeLayout.this.mRefreshView.getTop();
            } else {
                DoricSwipeLayout.this.reset();
            }
        }
    };
    private int mPullDownHeight = 0;
    private ValueAnimator headerViewAnimator;
    private final Animation mAnimateToCorrectPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            int targetTop = 0;
            int endTarget = 0;
            endTarget = !DoricSwipeLayout.this.mUsingCustomStart ? DoricSwipeLayout.this.mSpinnerOffsetEnd - Math.abs(DoricSwipeLayout.this.mOriginalOffsetTop) : DoricSwipeLayout.this.mSpinnerOffsetEnd;
            targetTop = DoricSwipeLayout.this.mFrom + (int)((float)(endTarget - DoricSwipeLayout.this.mFrom) * interpolatedTime);
            int offset = targetTop - DoricSwipeLayout.this.mRefreshView.getTop();
            DoricSwipeLayout.this.setTargetOffsetTopAndBottom(offset);
        }
    };
    private final Animation mAnimateToStartPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            DoricSwipeLayout.this.moveToStart(interpolatedTime);
        }
    };

    private void onRefreshAnimationEnd() {
        if (this.mRefreshing) {
            this.mRefreshView.startAnimation();
            if (this.mNotify && this.mListener != null) {
                this.mListener.onRefresh();
            }
            this.mCurrentTargetOffsetTop = this.mRefreshView.getTop();
        } else {
            this.reset();
        }
    }

    void reset() {
        this.mRefreshing = false;
        if (this.headerViewAnimator != null && this.headerViewAnimator.isRunning()) {
            this.headerViewAnimator.cancel();
        }
        this.headerViewAnimator = ValueAnimator.ofInt((int[])new int[]{this.mRefreshView.getBottom(), 0});
        this.headerViewAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DoricSwipeLayout.this.mCurrentTargetOffsetTop = (Integer)animation.getAnimatedValue() - DoricSwipeLayout.this.mRefreshView.getMeasuredHeight();
                if (DoricSwipeLayout.this.mRefreshView.getMeasuredHeight() > 0) {
                    DoricSwipeLayout.this.mRefreshView.setPullingDistance(DoricUtils.px2dp(DoricSwipeLayout.this.mRefreshView.getBottom()));
                }
                DoricSwipeLayout.this.mRefreshView.requestLayout();
            }
        });
        this.headerViewAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                DoricSwipeLayout.this.mRefreshView.stopAnimation();
                DoricSwipeLayout.this.mRefreshView.setVisibility(8);
                DoricSwipeLayout.this.setTargetOffsetTopAndBottom(DoricSwipeLayout.this.mOriginalOffsetTop - DoricSwipeLayout.this.mCurrentTargetOffsetTop);
                DoricSwipeLayout.this.mCurrentTargetOffsetTop = DoricSwipeLayout.this.mRefreshView.getTop();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.headerViewAnimator.setDuration(150L);
        this.headerViewAnimator.start();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.reset();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.reset();
    }

    public DoricSwipeLayout(@NonNull Context context) {
        this(context, null);
    }

    public DoricSwipeLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMediumAnimationDuration = this.getResources().getInteger(0x10E0001);
        this.setWillNotDraw(false);
        this.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.createProgressView();
        this.setChildrenDrawingOrderEnabled(true);
        this.mSpinnerOffsetEnd = (int)(64.0f * metrics.density);
        this.mTotalDragDistance = this.mSpinnerOffsetEnd;
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.moveToStart(1.0f);
        TypedArray a = context.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
        this.setEnabled(a.getBoolean(0, true));
        a.recycle();
    }

    public void setPullDownHeight(int height) {
        this.mPullDownHeight = height;
        this.mOriginalOffsetTop = this.mCurrentTargetOffsetTop = -height;
        this.mSpinnerOffsetEnd = height;
        this.mTotalDragDistance = height;
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mCircleViewIndex < 0) {
            return i;
        }
        if (i == childCount - 1) {
            return this.mCircleViewIndex;
        }
        if (i >= this.mCircleViewIndex) {
            return i + 1;
        }
        return i;
    }

    private void createProgressView() {
        this.mRefreshView = new DoricRefreshView(this.getContext());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -2);
        this.addView((View)this.mRefreshView, layoutParams);
    }

    public DoricRefreshView getRefreshView() {
        return this.mRefreshView;
    }

    public void setOnRefreshListener(@Nullable OnRefreshListener listener) {
        this.mListener = listener;
    }

    public void setRefreshing(boolean refreshing) {
        if (refreshing && this.mRefreshing != refreshing) {
            this.mRefreshing = refreshing;
            int endTarget = 0;
            endTarget = !this.mUsingCustomStart ? this.mSpinnerOffsetEnd + this.mOriginalOffsetTop : this.mSpinnerOffsetEnd;
            this.setTargetOffsetTopAndBottom(endTarget - this.mCurrentTargetOffsetTop);
            this.mNotify = false;
            this.mRefreshView.setVisibility(0);
            this.onRefreshAnimationEnd();
        } else {
            this.setRefreshing(refreshing, false);
        }
    }

    private void setRefreshing(boolean refreshing, boolean notify) {
        if (this.mRefreshing != refreshing) {
            this.mNotify = notify;
            this.ensureTarget();
            this.mRefreshing = refreshing;
            if (this.mRefreshing) {
                this.animateOffsetToCorrectPosition(this.mCurrentTargetOffsetTop, this.mRefreshListener);
            } else {
                this.onRefreshAnimationEnd();
            }
        }
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child.equals(this.mRefreshView)) continue;
                this.mTarget = child;
                break;
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (this.getChildCount() == 0) {
            return;
        }
        if (this.mTarget == null) {
            this.ensureTarget();
        }
        if (this.mTarget == null) {
            return;
        }
        int circleWidth = this.mRefreshView.getMeasuredWidth();
        int circleHeight = this.mRefreshView.getMeasuredHeight();
        this.mRefreshView.layout(width / 2 - circleWidth / 2, this.mCurrentTargetOffsetTop, width / 2 + circleWidth / 2, this.mCurrentTargetOffsetTop + circleHeight);
        View child = this.mTarget;
        int childLeft = this.getPaddingLeft();
        int childTop = this.getPaddingTop() + this.mRefreshView.getBottom();
        int childWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int childHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mTarget == null) {
            this.ensureTarget();
        }
        if (this.mTarget == null) {
            return;
        }
        this.mTarget.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
        this.mRefreshView.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)((this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 3), (int)0));
        if (this.mPullDownHeight != this.mRefreshView.getMeasuredHeight()) {
            this.setPullDownHeight(this.mRefreshView.getMeasuredHeight());
        }
        this.mCircleViewIndex = -1;
        for (int index = 0; index < this.getChildCount(); ++index) {
            if (this.getChildAt(index) != this.mRefreshView) continue;
            this.mCircleViewIndex = index;
            break;
        }
    }

    public boolean canChildScrollUp() {
        if (this.mChildScrollUpCallback != null) {
            return this.mChildScrollUpCallback.canChildScrollUp(this, this.mTarget);
        }
        if (this.mTarget instanceof ListView) {
            return ListViewCompat.canScrollList((ListView)((ListView)this.mTarget), (int)-1);
        }
        return this.mTarget.canScrollVertically(-1);
    }

    public void setOnChildScrollUpCallback(@Nullable OnChildScrollUpCallback callback) {
        this.mChildScrollUpCallback = callback;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        int action = ev.getActionMasked();
        if (this.mReturningToStart && action == 0) {
            this.mReturningToStart = false;
        }
        if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp() || this.mRefreshing || this.mNestedScrollInProgress) {
            return false;
        }
        switch (action) {
            case 0: {
                this.setTargetOffsetTopAndBottom(this.mOriginalOffsetTop - this.mRefreshView.getTop());
                this.mActivePointerId = ev.getPointerId(0);
                this.mIsBeingDragged = false;
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    return false;
                }
                this.mInitialDownY = ev.getY(pointerIndex);
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    Log.e((String)LOG_TAG, (String)"Got ACTION_MOVE event but don't have an active pointer id.");
                    return false;
                }
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    return false;
                }
                float y = ev.getY(pointerIndex);
                this.startDragging(y);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
            }
        }
        return this.mIsBeingDragged;
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (!(Build.VERSION.SDK_INT < 21 && this.mTarget instanceof AbsListView || this.mTarget != null && !ViewCompat.isNestedScrollingEnabled((View)this.mTarget))) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && !this.mReturningToStart && !this.mRefreshing && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(axes & 2);
        this.mTotalUnconsumed = 0.0f;
        this.mNestedScrollInProgress = true;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int[] parentConsumed;
        if (dy > 0 && this.mTotalUnconsumed > 0.0f) {
            if ((float)dy > this.mTotalUnconsumed) {
                consumed[1] = dy - (int)this.mTotalUnconsumed;
                this.mTotalUnconsumed = 0.0f;
            } else if (dy > 3) {
                this.mTotalUnconsumed -= (float)dy;
                consumed[1] = dy;
            }
            this.moveSpinner(this.mTotalUnconsumed);
        }
        if (this.mUsingCustomStart && dy > 0 && this.mTotalUnconsumed == 0.0f && Math.abs(dy - consumed[1]) > 0) {
            this.mRefreshView.setVisibility(8);
        }
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed = this.mParentScrollConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (this.mTotalUnconsumed > 0.0f) {
            this.finishSpinner(this.mTotalUnconsumed);
            this.mTotalUnconsumed = 0.0f;
        }
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if (dy < 0 && !this.canChildScrollUp()) {
            this.mTotalUnconsumed += (float)Math.abs(dy);
            this.moveSpinner(this.mTotalUnconsumed);
        }
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    private boolean isAnimationRunning(Animation animation) {
        return animation != null && animation.hasStarted() && !animation.hasEnded();
    }

    private void moveSpinner(float overscrollTop) {
        float originalDragPercent = overscrollTop / this.mTotalDragDistance;
        float dragPercent = Math.min(1.0f, Math.abs(originalDragPercent));
        float extraOS = Math.abs(overscrollTop) - this.mTotalDragDistance;
        float slingshotDist = this.mCustomSlingshotDistance > 0 ? (float)this.mCustomSlingshotDistance : (float)(this.mUsingCustomStart ? this.mSpinnerOffsetEnd - this.mOriginalOffsetTop : this.mSpinnerOffsetEnd);
        float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, slingshotDist * 2.0f) / slingshotDist);
        float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
        float extraMove = slingshotDist * tensionPercent * 2.0f;
        int targetY = this.mOriginalOffsetTop + (int)(slingshotDist * dragPercent + extraMove);
        if (this.mRefreshView.getVisibility() != 0) {
            this.mRefreshView.setVisibility(0);
        }
        this.mRefreshView.setScaleX(1.0f);
        this.mRefreshView.setScaleY(1.0f);
        this.setTargetOffsetTopAndBottom(targetY - this.mCurrentTargetOffsetTop);
    }

    private void finishSpinner(float overscrollTop) {
        if (overscrollTop > this.mTotalDragDistance) {
            this.setRefreshing(true, true);
        } else {
            this.mRefreshing = false;
            this.animateOffsetToStartPosition(this.mCurrentTargetOffsetTop, null);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        int pointerIndex = -1;
        if (this.mReturningToStart && action == 0) {
            this.mReturningToStart = false;
        }
        if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp() || this.mRefreshing || this.mNestedScrollInProgress) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mIsBeingDragged = false;
                break;
            }
            case 2: {
                pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    Log.e((String)LOG_TAG, (String)"Got ACTION_MOVE event but have an invalid active pointer id.");
                    return false;
                }
                float y = ev.getY(pointerIndex);
                this.startDragging(y);
                if (!this.mIsBeingDragged) break;
                float overscrollTop = (y - this.mInitialMotionY) * 0.5f;
                if (overscrollTop > 0.0f) {
                    this.moveSpinner(overscrollTop);
                    break;
                }
                return false;
            }
            case 5: {
                pointerIndex = ev.getActionIndex();
                if (pointerIndex < 0) {
                    Log.e((String)LOG_TAG, (String)"Got ACTION_POINTER_DOWN event but have an invalid action index.");
                    return false;
                }
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: {
                pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0) {
                    Log.e((String)LOG_TAG, (String)"Got ACTION_UP event but don't have an active pointer id.");
                    return false;
                }
                if (this.mIsBeingDragged) {
                    float y = ev.getY(pointerIndex);
                    float overscrollTop = (y - this.mInitialMotionY) * 0.5f;
                    this.mIsBeingDragged = false;
                    this.finishSpinner(overscrollTop);
                }
                this.mActivePointerId = -1;
                return false;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    private void startDragging(float y) {
        float yDiff = y - this.mInitialDownY;
        if (yDiff > (float)this.mTouchSlop && !this.mIsBeingDragged) {
            this.mInitialMotionY = this.mInitialDownY + (float)this.mTouchSlop;
            this.mIsBeingDragged = true;
        }
    }

    private void animateOffsetToCorrectPosition(int from, Animation.AnimationListener listener) {
        this.mFrom = from;
        this.mAnimateToCorrectPosition.reset();
        this.mAnimateToCorrectPosition.setDuration(200L);
        this.mAnimateToCorrectPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (listener != null) {
            this.mRefreshView.setAnimationListener(listener);
        }
        this.mRefreshView.clearAnimation();
        this.mRefreshView.startAnimation(this.mAnimateToCorrectPosition);
    }

    private void animateOffsetToStartPosition(int from, Animation.AnimationListener listener) {
        this.mFrom = from;
        this.mAnimateToStartPosition.reset();
        this.mAnimateToStartPosition.setDuration(200L);
        this.mAnimateToStartPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (listener != null) {
            this.mRefreshView.setAnimationListener(listener);
        }
        this.mRefreshView.clearAnimation();
        this.mRefreshView.startAnimation(this.mAnimateToStartPosition);
    }

    void moveToStart(float interpolatedTime) {
        int targetTop = 0;
        targetTop = this.mFrom + (int)((float)(this.mOriginalOffsetTop - this.mFrom) * interpolatedTime);
        int offset = targetTop - this.mRefreshView.getTop();
        this.setTargetOffsetTopAndBottom(offset);
    }

    void setTargetOffsetTopAndBottom(int offset) {
        this.mRefreshView.bringToFront();
        ViewCompat.offsetTopAndBottom((View)this.mRefreshView, (int)offset);
        this.mCurrentTargetOffsetTop = this.mRefreshView.getTop();
        if (this.mRefreshView.getMeasuredHeight() > 0) {
            this.mRefreshView.setPullingDistance(DoricUtils.px2dp(this.mRefreshView.getBottom()));
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    public static interface OnChildScrollUpCallback {
        public boolean canChildScrollUp(@NonNull DoricSwipeLayout var1, @Nullable View var2);
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

