/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.shader.ViewNode;
import pub.doric.utils.ThreadMode;

@DoricPlugin(name="popover")
public class PopoverPlugin
extends DoricJavaPlugin {
    private static final String TYPE = "popover";
    private FrameLayout mFullScreenView;

    public PopoverPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod
    public void show(JSDecoder decoder, final DoricPromise promise) {
        try {
            final JSObject jsObject = decoder.decode().asObject();
            this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    int marginTop;
                    ViewGroup decorView = (ViewGroup)PopoverPlugin.this.getDoricContext().getRootNode().getNodeView().getRootView();
                    if (PopoverPlugin.this.mFullScreenView == null) {
                        PopoverPlugin.this.mFullScreenView = new FrameLayout(PopoverPlugin.this.getDoricContext().getContext());
                        View navBar = (View)PopoverPlugin.this.getDoricContext().getDoricNavBar();
                        ViewGroup.MarginLayoutParams layoutParams = new ViewGroup.MarginLayoutParams(-1, -1);
                        marginTop = 0;
                        if (navBar != null && navBar.getVisibility() == 0) {
                            int[] navBarLocation = new int[2];
                            navBar.getLocationOnScreen(navBarLocation);
                            int[] decorViewLocation = new int[2];
                            decorView.getLocationOnScreen(decorViewLocation);
                            marginTop = navBarLocation[1] - decorViewLocation[1] + navBar.getHeight();
                        }
                        layoutParams.topMargin = marginTop;
                        layoutParams.bottomMargin = QMUIDisplayHelper.getNavMenuHeight((Context)PopoverPlugin.this.getDoricContext().getContext());
                        decorView.addView((View)PopoverPlugin.this.mFullScreenView, (ViewGroup.LayoutParams)layoutParams);
                    } else {
                        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)PopoverPlugin.this.mFullScreenView.getLayoutParams();
                        View navBar = (View)PopoverPlugin.this.getDoricContext().getDoricNavBar();
                        marginTop = 0;
                        if (navBar != null && navBar.getVisibility() == 0) {
                            int[] navBarLocation = new int[2];
                            navBar.getLocationOnScreen(navBarLocation);
                            int[] decorViewLocation = new int[2];
                            decorView.getLocationOnScreen(decorViewLocation);
                            marginTop = navBarLocation[1] - decorViewLocation[1] + navBar.getHeight();
                        }
                        layoutParams.topMargin = marginTop;
                        layoutParams.bottomMargin = QMUIDisplayHelper.getNavMenuHeight((Context)PopoverPlugin.this.getDoricContext().getContext());
                        PopoverPlugin.this.mFullScreenView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                    PopoverPlugin.this.mFullScreenView.bringToFront();
                    String viewId = jsObject.getProperty("id").asString().value();
                    String type = jsObject.getProperty("type").asString().value();
                    ViewNode node = ViewNode.create(PopoverPlugin.this.getDoricContext(), type);
                    node.setId(viewId);
                    node.init((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                    node.blend(jsObject.getProperty("props").asObject());
                    PopoverPlugin.this.mFullScreenView.addView(node.getNodeView());
                    PopoverPlugin.this.getDoricContext().addHeadNode(PopoverPlugin.TYPE, node);
                    return null;
                }
            }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

                @Override
                public void onResult(Object result) {
                    promise.resolve(new JavaValue[0]);
                }

                @Override
                public void onError(Throwable t) {
                    t.printStackTrace();
                    promise.reject(new JavaValue(t.getLocalizedMessage()));
                }

                @Override
                public void onFinish() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod
    public void dismiss(final JSValue value, final DoricPromise promise) {
        try {
            this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (value.isObject()) {
                        String viewId = value.asObject().getProperty("id").asString().value();
                        ViewNode node = PopoverPlugin.this.getDoricContext().targetViewNode(viewId);
                        PopoverPlugin.this.dismissViewNode(node);
                    } else {
                        PopoverPlugin.this.dismissPopover();
                    }
                    return null;
                }
            }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

                @Override
                public void onResult(Object result) {
                    promise.resolve(new JavaValue[0]);
                }

                @Override
                public void onError(Throwable t) {
                    t.printStackTrace();
                    promise.reject(new JavaValue(t.getLocalizedMessage()));
                }

                @Override
                public void onFinish() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    private void dismissViewNode(ViewNode node) {
        this.getDoricContext().removeHeadNode(TYPE, node);
        this.mFullScreenView.removeView(node.getNodeView());
        if (this.getDoricContext().allHeadNodes(TYPE).isEmpty()) {
            ViewGroup decorView = (ViewGroup)this.getDoricContext().getRootNode().getNodeView().getRootView();
            decorView.removeView((View)this.mFullScreenView);
            this.mFullScreenView = null;
        }
    }

    private void dismissPopover() {
        for (ViewNode node : this.getDoricContext().allHeadNodes(TYPE)) {
            this.dismissViewNode(node);
        }
    }

    @Override
    public void onTearDown() {
        super.onTearDown();
        this.dismissPopover();
    }
}

