/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.content.Intent;
import android.net.Uri;
import com.github.pengfeizhou.jscore.ArchiveException;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import pub.doric.DoricActivity;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.navigator.IDoricNavigator;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.utils.ThreadMode;

@DoricPlugin(name="navigator")
public class NavigatorPlugin
extends DoricJavaPlugin {
    public NavigatorPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void push(JSDecoder jsDecoder, DoricPromise promise) {
        IDoricNavigator navigator = this.getDoricContext().getDoricNavigator();
        if (navigator != null) {
            try {
                String source;
                JSObject jsObject = jsDecoder.decode().asObject();
                String alias = source = jsObject.getProperty("source").asString().value();
                String extra = "";
                JSValue config = jsObject.getProperty("config");
                boolean singlePage = false;
                if (config.isObject()) {
                    JSValue singlePageJS;
                    JSValue extraJS;
                    JSValue aliasJS = config.asObject().getProperty("alias");
                    if (aliasJS.isString()) {
                        alias = aliasJS.asString().value();
                    }
                    if ((extraJS = config.asObject().getProperty("extra")).isString()) {
                        extra = extraJS.asString().value();
                    }
                    if ((singlePageJS = config.asObject().getProperty("singlePage")).isBoolean()) {
                        singlePage = singlePageJS.asBoolean().value();
                    }
                }
                if (singlePage) {
                    navigator.push(jsObject.getProperty("source").asString().value(), alias, extra);
                } else {
                    Intent intent = new Intent(this.getDoricContext().getContext(), DoricActivity.class);
                    intent.putExtra("source", source);
                    intent.putExtra("alias", alias);
                    intent.putExtra("extra", extra);
                    this.getDoricContext().getContext().startActivity(intent);
                }
                promise.resolve(new JavaValue[0]);
            }
            catch (ArchiveException e) {
                e.printStackTrace();
                promise.reject(new JavaValue(e.getLocalizedMessage()));
            }
        } else {
            promise.reject(new JavaValue("Navigator not implemented"));
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void pop(DoricPromise promise) {
        IDoricNavigator navigator = this.getDoricContext().getDoricNavigator();
        if (navigator != null) {
            navigator.pop();
            promise.resolve(new JavaValue[0]);
        } else {
            promise.reject(new JavaValue("Navigator not implemented"));
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void openUrl(String url, DoricPromise promise) {
        try {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(uri);
            this.getDoricContext().getContext().startActivity(intent);
            promise.resolve(new JavaValue[0]);
        }
        catch (Exception e) {
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }
}

