/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import pub.doric.DoricContext;
import pub.doric.R;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.utils.DoricUtils;
import pub.doric.utils.ThreadMode;

@DoricPlugin(name="modal")
public class ModalPlugin
extends DoricJavaPlugin {
    public ModalPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void toast(JSObject jsObject) {
        try {
            String msg = jsObject.getProperty("msg").asString().value();
            JSValue gravityVal = jsObject.getProperty("gravity");
            int gravity = 80;
            if (gravityVal.isNumber()) {
                gravity = gravityVal.asNumber().toInt();
            }
            Toast toast = Toast.makeText((Context)this.getDoricContext().getContext(), (CharSequence)jsObject.getProperty("msg").asString().value(), (int)0);
            if ((gravity & 0x30) == 48) {
                toast.setGravity(49, 0, DoricUtils.dp2px(50.0f));
            } else if ((gravity & 0x50) == 80) {
                toast.setGravity(81, 0, DoricUtils.dp2px(50.0f));
            } else {
                toast.setGravity(17, 0, 0);
            }
            toast.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void alert(JSObject jsObject, final DoricPromise promise) {
        try {
            JSValue titleVal = jsObject.getProperty("title");
            JSValue msgVal = jsObject.getProperty("msg");
            JSValue okBtn = jsObject.getProperty("okLabel");
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getDoricContext().getContext(), R.style.Theme_Doric_Modal_Alert);
            if (titleVal.isString()) {
                builder.setTitle((CharSequence)titleVal.asString().value());
            }
            String btnTitle = this.getDoricContext().getContext().getString(17039370);
            if (okBtn.isString()) {
                btnTitle = okBtn.asString().value();
            }
            builder.setMessage((CharSequence)msgVal.asString().value()).setPositiveButton((CharSequence)btnTitle, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    promise.resolve(new JavaValue[0]);
                }
            });
            builder.setCancelable(false);
            builder.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void confirm(JSObject jsObject, final DoricPromise promise) {
        try {
            JSValue titleVal = jsObject.getProperty("title");
            JSValue msgVal = jsObject.getProperty("msg");
            JSValue okBtn = jsObject.getProperty("okLabel");
            JSValue cancelBtn = jsObject.getProperty("cancelLabel");
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getDoricContext().getContext(), R.style.Theme_Doric_Modal_Confirm);
            if (titleVal.isString()) {
                builder.setTitle((CharSequence)titleVal.asString().value());
            }
            String okLabel = this.getDoricContext().getContext().getString(17039370);
            if (okBtn.isString()) {
                okLabel = okBtn.asString().value();
            }
            String cancelLabel = this.getDoricContext().getContext().getString(0x1040000);
            if (cancelBtn.isString()) {
                cancelLabel = cancelBtn.asString().value();
            }
            builder.setMessage((CharSequence)msgVal.asString().value()).setPositiveButton((CharSequence)okLabel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    promise.resolve(new JavaValue[0]);
                }
            }).setNegativeButton((CharSequence)cancelLabel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    promise.reject(new JavaValue[0]);
                }
            });
            builder.setCancelable(false);
            builder.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void prompt(JSObject jsObject, final DoricPromise promise) {
        try {
            JSValue titleVal = jsObject.getProperty("title");
            JSValue msgVal = jsObject.getProperty("msg");
            JSValue okBtn = jsObject.getProperty("okLabel");
            JSValue cancelBtn = jsObject.getProperty("cancelLabel");
            JSValue defaultVal = jsObject.getProperty("defaultText");
            JSValue text = jsObject.getProperty("text");
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getDoricContext().getContext(), R.style.Theme_Doric_Modal_Prompt);
            if (titleVal.isString()) {
                builder.setTitle((CharSequence)titleVal.asString().value());
            }
            String okLabel = this.getDoricContext().getContext().getString(17039370);
            if (okBtn.isString()) {
                okLabel = okBtn.asString().value();
            }
            String cancelLabel = this.getDoricContext().getContext().getString(0x1040000);
            if (cancelBtn.isString()) {
                cancelLabel = cancelBtn.asString().value();
            }
            View v = LayoutInflater.from((Context)this.getDoricContext().getContext()).inflate(R.layout.doric_modal_prompt, null);
            TextView tvMsg = (TextView)v.findViewById(R.id.tv_msg);
            if (msgVal.isString()) {
                tvMsg.setText((CharSequence)msgVal.asString().value());
            }
            final EditText editText = (EditText)v.findViewById(R.id.edit_input);
            if (defaultVal.isString()) {
                editText.setHint((CharSequence)defaultVal.asString().value());
            }
            if (text.isString()) {
                editText.setText((CharSequence)text.asString().value());
                editText.setSelection(text.asString().value().length());
            }
            builder.setView(v);
            builder.setPositiveButton((CharSequence)okLabel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    promise.resolve(new JavaValue(editText.getText().toString()));
                }
            }).setNegativeButton((CharSequence)cancelLabel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    promise.reject(new JavaValue(editText.getText().toString()));
                }
            });
            builder.setCancelable(false);
            builder.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }
}

