/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.graphics.Color;
import android.view.View;
import com.github.pengfeizhou.jscore.JSNumber;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.DoricScrollChangeListener;
import pub.doric.IDoricScrollable;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricUtils;
import pub.doric.utils.ThreadMode;

@DoricPlugin(name="coordinator")
public class CoordinatorPlugin
extends DoricJavaPlugin {
    public CoordinatorPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod
    public void ready(final DoricPromise doricPromise) {
        this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

            @Override
            public Object call() {
                doricPromise.resolve(new JavaValue[0]);
                return null;
            }
        }, ThreadMode.UI);
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void verticalScrolling(final JSObject argument, final DoricPromise doricPromise) {
        this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JSValue[] scrollableIds = argument.getProperty("scrollable").asArray().toArray();
                ViewNode scrollNode = null;
                for (JSValue value : scrollableIds) {
                    if (scrollNode == null) {
                        scrollNode = CoordinatorPlugin.this.getDoricContext().targetViewNode(value.asString().value());
                        continue;
                    }
                    if (!value.isString() || !(scrollNode instanceof SuperNode)) continue;
                    String viewId = value.asString().value();
                    scrollNode = ((SuperNode)scrollNode).getSubNodeById(viewId);
                }
                if (scrollNode == null) {
                    throw new Exception("Cannot find scrollable view");
                }
                JSObject scrollRange = argument.getProperty("scrollRange").asObject();
                final int startAnchor = DoricUtils.dp2px(scrollRange.getProperty("start").asNumber().toFloat());
                final int endAnchor = DoricUtils.dp2px(scrollRange.getProperty("end").asNumber().toFloat());
                JSValue target = argument.getProperty("target");
                boolean isNavBar = false;
                ViewNode targetNode = null;
                if (target.isString() && "NavBar".equals(target.asString().value())) {
                    isNavBar = true;
                } else if (target.isArray()) {
                    JSValue[] targetIds;
                    for (JSValue value : targetIds = target.asArray().toArray()) {
                        if (targetNode == null) {
                            targetNode = CoordinatorPlugin.this.getDoricContext().targetViewNode(value.asString().value());
                            continue;
                        }
                        if (!value.isString() || !(targetNode instanceof SuperNode)) continue;
                        String viewId = value.asString().value();
                        targetNode = ((SuperNode)targetNode).getSubNodeById(viewId);
                    }
                } else {
                    throw new Exception("Target type error");
                }
                JSObject changing = argument.getProperty("changing").asObject();
                final String name = changing.getProperty("name").asString().value();
                final float changingStart = changing.getProperty("start").asNumber().toFloat();
                final float changingEnd = changing.getProperty("end").asNumber().toFloat();
                ViewNode finalScrollNode = scrollNode;
                final ViewNode finalTargetNode = targetNode;
                final boolean finalIsNavBar = isNavBar;
                if (finalScrollNode instanceof IDoricScrollable) {
                    ((IDoricScrollable)((Object)finalScrollNode)).addScrollChangeListener(new DoricScrollChangeListener(){

                        @Override
                        public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                            if (scrollY <= startAnchor) {
                                CoordinatorPlugin.this.setValue(finalTargetNode, finalIsNavBar, name, changingStart);
                            } else if (scrollY >= endAnchor) {
                                CoordinatorPlugin.this.setValue(finalTargetNode, finalIsNavBar, name, changingEnd);
                            } else {
                                float value;
                                float range = Math.max(1, endAnchor - startAnchor);
                                float offset = scrollY - startAnchor;
                                float rate = offset / range;
                                if ("backgroundColor".equals(name)) {
                                    int startColor = (int)changingStart;
                                    int endColor = (int)changingEnd;
                                    value = Color.argb((int)((int)((float)Color.alpha((int)startColor) + (float)(Color.alpha((int)endColor) - Color.alpha((int)startColor)) * rate)), (int)((int)((float)Color.red((int)startColor) + (float)(Color.red((int)endColor) - Color.red((int)startColor)) * rate)), (int)((int)((float)Color.green((int)startColor) + (float)(Color.green((int)endColor) - Color.green((int)startColor)) * rate)), (int)((int)((float)Color.blue((int)startColor) + (float)(Color.blue((int)endColor) - Color.blue((int)startColor)) * rate)));
                                } else {
                                    value = changingStart + (changingEnd - changingStart) * rate;
                                }
                                CoordinatorPlugin.this.setValue(finalTargetNode, finalIsNavBar, name, value);
                            }
                        }
                    });
                    return null;
                }
                throw new Exception("Scroller type error");
            }
        }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

            @Override
            public void onResult(Object result) {
                doricPromise.resolve(new JavaValue[0]);
            }

            @Override
            public void onError(Throwable t) {
                doricPromise.reject(new JavaValue[0]);
            }

            @Override
            public void onFinish() {
            }
        });
    }

    private void setValue(ViewNode viewNode, boolean isNavBar, String name, float value) {
        if ("backgroundColor".equals(name) && isNavBar) {
            this.getDoricContext().getDoricNavBar().setBackgroundColor((int)value);
        } else {
            JSNumber jsNumber = new JSNumber((double)value);
            JSObject jsObject = new JSObject();
            jsObject.setProperty(name, (JSValue)jsNumber);
            viewNode.blend(jsObject);
        }
    }
}

