/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.navbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.util.QMUIStatusBarHelper;
import pub.doric.R;
import pub.doric.navbar.IDoricNavBar;

public class BaseDoricNavBar
extends FrameLayout
implements IDoricNavBar {
    private ViewGroup mTitleContainer;
    private ViewGroup mRightContainer;
    private ViewGroup mLeftContainer;
    private TextView mTvTitle;

    public BaseDoricNavBar(@NonNull Context context) {
        this(context, null);
    }

    public BaseDoricNavBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseDoricNavBar(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup();
    }

    private void setup() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.doric_navigator, (ViewGroup)this);
        this.mTitleContainer = (ViewGroup)this.findViewById(R.id.container_title);
        this.mLeftContainer = (ViewGroup)this.findViewById(R.id.container_left);
        this.mRightContainer = (ViewGroup)this.findViewById(R.id.container_right);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.findViewById(R.id.tv_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseDoricNavBar.this.getContext() instanceof Activity) {
                    ((Activity)BaseDoricNavBar.this.getContext()).onBackPressed();
                }
            }
        });
    }

    public void setBackIconVisible(boolean visible) {
        this.findViewById(R.id.tv_back).setVisibility(visible ? 0 : 8);
    }

    @Override
    public boolean isHidden() {
        return this.getVisibility() != 0;
    }

    @Override
    public void setHidden(boolean b) {
        if (this.getVisibility() == (b ? 8 : 0)) {
            return;
        }
        this.setVisibility(b ? 8 : 0);
        Activity activity = (Activity)this.getContext();
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 19) {
            if (b) {
                QMUIStatusBarHelper.translucent((Activity)activity);
            } else {
                int visibility = window.getDecorView().getSystemUiVisibility();
                window.getDecorView().setSystemUiVisibility(visibility ^= 0x500);
                if (Build.VERSION.SDK_INT >= 21) {
                    window.clearFlags(Integer.MIN_VALUE);
                }
            }
        }
    }

    @Override
    public void setTitle(String title) {
        this.mTvTitle.setText((CharSequence)title);
    }

    @Override
    public void setLeft(View view) {
        this.mLeftContainer.removeAllViews();
        this.mLeftContainer.addView(view);
    }

    @Override
    public void setRight(View view) {
        this.mRightContainer.removeAllViews();
        this.mRightContainer.addView(view);
    }

    @Override
    public void setCenter(View view) {
        this.mTitleContainer.removeAllViews();
        this.mTitleContainer.addView(view);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
        lp.gravity = 17;
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void updateTitleMargins() {
        try {
            int width = this.mRightContainer.getRight() - this.mLeftContainer.getLeft();
            int leftWidth = this.mLeftContainer.getWidth();
            int rightWidth = this.mRightContainer.getWidth();
            int margin = Math.max(leftWidth, rightWidth);
            if (leftWidth + rightWidth > width) {
                this.mTitleContainer.setVisibility(8);
            } else {
                float textWidth;
                this.mTitleContainer.setVisibility(0);
                StaticLayout staticLayout = new StaticLayout(this.mTvTitle.getText(), this.mTvTitle.getPaint(), Integer.MAX_VALUE, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                float f = textWidth = staticLayout.getLineCount() > 0 ? staticLayout.getLineWidth(0) : 0.0f;
                if ((float)(width - 2 * margin) >= textWidth) {
                    this.mTitleContainer.setPadding(margin, 0, margin, 0);
                } else {
                    this.mTitleContainer.setPadding(leftWidth, 0, rightWidth, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.updateTitleMargins();
    }
}

