/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.loader;

import androidx.annotation.NonNull;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import pub.doric.async.AsyncResult;
import pub.doric.loader.IDoricJSLoader;

public class DoricHttpJSLoader
implements IDoricJSLoader {
    private OkHttpClient okHttpClient = new OkHttpClient();

    @Override
    public boolean filter(String source) {
        return source.startsWith("http");
    }

    @Override
    public AsyncResult<String> request(String source) {
        final AsyncResult<String> ret = new AsyncResult<String>();
        this.okHttpClient.newCall(new Request.Builder().url(source).build()).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                ret.setError(e);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                try {
                    ret.setResult(response.body().string());
                }
                catch (Exception e) {
                    ret.setError(e);
                }
            }
        });
        return ret;
    }
}

