/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.loader;

import android.content.res.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import pub.doric.Doric;
import pub.doric.async.AsyncResult;
import pub.doric.loader.IDoricJSLoader;

public class DoricAssetJSLoader
implements IDoricJSLoader {
    @Override
    public boolean filter(String source) {
        return source.startsWith("assets");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncResult<String> request(String source) {
        AsyncResult<String> result = new AsyncResult<String>();
        String assetPath = source.substring("assets://".length());
        InputStream inputStream = null;
        try {
            AssetManager assetManager = Doric.application().getAssets();
            inputStream = assetManager.open(assetPath);
            int length = inputStream.available();
            byte[] buffer = new byte[length];
            inputStream.read(buffer);
            result.setResult(new String(buffer));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setError(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }
}

