/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.extension.timer;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.HashSet;
import java.util.Set;

public class DoricTimerExtension
implements Handler.Callback {
    private static final int MSG_TIMER = 0;
    private final Handler mTimerHandler;
    private final TimerCallback mTimerCallback;
    private Set<Long> mDeletedTimerIds = new HashSet<Long>();

    public DoricTimerExtension(Looper looper, TimerCallback timerCallback) {
        this.mTimerHandler = new Handler(looper, (Handler.Callback)this);
        this.mTimerCallback = timerCallback;
    }

    public void setTimer(long timerId, long time, boolean repeat) {
        TimerInfo timerInfo = new TimerInfo();
        timerInfo.timerId = timerId;
        timerInfo.time = time;
        timerInfo.repeat = repeat;
        this.mTimerHandler.sendMessageDelayed(Message.obtain((Handler)this.mTimerHandler, (int)0, (Object)timerInfo), timerInfo.time);
    }

    public void clearTimer(long timerId) {
        this.mDeletedTimerIds.add(timerId);
    }

    public boolean handleMessage(Message msg) {
        if (msg.obj instanceof TimerInfo) {
            TimerInfo timerInfo = (TimerInfo)msg.obj;
            if (this.mDeletedTimerIds.contains(timerInfo.timerId)) {
                this.mDeletedTimerIds.remove(timerInfo.timerId);
            } else {
                this.mTimerCallback.callback(timerInfo.timerId);
                if (timerInfo.repeat) {
                    this.mTimerHandler.sendMessageDelayed(Message.obtain((Handler)this.mTimerHandler, (int)0, (Object)timerInfo), timerInfo.time);
                } else {
                    this.mDeletedTimerIds.remove(timerInfo.timerId);
                }
            }
        }
        return true;
    }

    public void teardown() {
        this.mTimerHandler.removeCallbacksAndMessages(null);
    }

    public static interface TimerCallback {
        public void callback(long var1);
    }

    private class TimerInfo {
        long timerId;
        long time;
        boolean repeat;

        private TimerInfo() {
        }
    }
}

