/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.engine;

import android.app.Application;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JavaFunction;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.ArrayList;
import java.util.Map;
import pub.doric.Doric;
import pub.doric.DoricContext;
import pub.doric.DoricRegistry;
import pub.doric.IDoricMonitor;
import pub.doric.engine.DoricNativeJSExecutor;
import pub.doric.engine.IDoricJSE;
import pub.doric.extension.bridge.DoricBridgeExtension;
import pub.doric.extension.timer.DoricTimerExtension;
import pub.doric.utils.DoricLog;
import pub.doric.utils.DoricUtils;

public class DoricJSEngine
implements Handler.Callback,
DoricTimerExtension.TimerCallback,
IDoricMonitor {
    private HandlerThread handlerThread;
    private final Handler mJSHandler;
    private final DoricBridgeExtension mDoricBridgeExtension = new DoricBridgeExtension();
    protected IDoricJSE mDoricJSE;
    private final DoricTimerExtension mTimerExtension;
    private final DoricRegistry mDoricRegistry = new DoricRegistry();

    public DoricJSEngine() {
        this.handlerThread = new HandlerThread(this.getClass().getSimpleName());
        this.handlerThread.start();
        Looper looper = this.handlerThread.getLooper();
        this.mJSHandler = new Handler(looper, (Handler.Callback)this);
        this.mJSHandler.post(new Runnable(){

            @Override
            public void run() {
                DoricJSEngine.this.initJSEngine();
                DoricJSEngine.this.injectGlobal();
                DoricJSEngine.this.initDoricRuntime();
            }
        });
        this.mTimerExtension = new DoricTimerExtension(looper, this);
        this.mDoricRegistry.registerMonitor(this);
    }

    public Handler getJSHandler() {
        return this.mJSHandler;
    }

    protected void initJSEngine() {
        this.mDoricJSE = new DoricNativeJSExecutor();
    }

    private void injectGlobal() {
        String appName = "";
        String appVersion = "";
        Application context = Doric.application();
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            appName = context.getResources().getString(labelRes);
            appVersion = packageInfo.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONBuilder envObject = new JSONBuilder().put("platform", (Object)"Android").put("platformVersion", (Object)String.valueOf(Build.VERSION.SDK_INT)).put("appName", (Object)appName).put("appVersion", (Object)appVersion).put("screenWidth", (Object)Float.valueOf(DoricUtils.px2dp(DoricUtils.getScreenWidth()))).put("screenHeight", (Object)Float.valueOf(DoricUtils.px2dp(DoricUtils.getScreenHeight()))).put("screenScale", (Object)Float.valueOf(DoricUtils.getScreenScale())).put("statusBarHeight", (Object)Float.valueOf(DoricUtils.px2dp(DoricUtils.getStatusBarHeight()))).put("hasNotch", (Object)false).put("deviceBrand", (Object)Build.BRAND).put("deviceModel", (Object)Build.MODEL);
        Map<String, Object> extend = this.mDoricRegistry.getEnvironmentVariables();
        for (String key : extend.keySet()) {
            envObject.put(key, extend.get(key));
        }
        this.mDoricJSE.injectGlobalJSObject("Environment", new JavaValue(envObject.toJSONObject()));
        this.mDoricJSE.injectGlobalJSFunction("nativeLog", new JavaFunction(){

            public JavaValue exec(JSDecoder[] args) {
                try {
                    String type = args[0].string();
                    String message = args[1].string();
                    switch (type) {
                        case "w": {
                            DoricJSEngine.this.mDoricRegistry.onLog(5, message);
                            break;
                        }
                        case "e": {
                            DoricJSEngine.this.mDoricRegistry.onLog(6, message);
                            break;
                        }
                        default: {
                            DoricJSEngine.this.mDoricRegistry.onLog(4, message);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    DoricJSEngine.this.mDoricRegistry.onException(null, e);
                }
                return null;
            }
        });
        this.mDoricJSE.injectGlobalJSFunction("nativeEmpty", new JavaFunction(){

            public JavaValue exec(JSDecoder[] args) {
                return null;
            }
        });
        this.mDoricJSE.injectGlobalJSFunction("nativeRequire", new JavaFunction(){

            public JavaValue exec(JSDecoder[] args) {
                try {
                    String name = args[0].string();
                    String content = DoricJSEngine.this.mDoricRegistry.acquireJSBundle(name);
                    if (TextUtils.isEmpty((CharSequence)content)) {
                        DoricJSEngine.this.mDoricRegistry.onLog(6, String.format("require js bundle:%s is empty", name));
                        return new JavaValue(false);
                    }
                    DoricJSEngine.this.mDoricJSE.loadJS(DoricJSEngine.this.packageModuleScript(name, content), "Module://" + name);
                    return new JavaValue(true);
                }
                catch (Exception e) {
                    DoricJSEngine.this.mDoricRegistry.onException(null, e);
                    return new JavaValue(false);
                }
            }
        });
        this.mDoricJSE.injectGlobalJSFunction("nativeSetTimer", new JavaFunction(){

            public JavaValue exec(JSDecoder[] args) {
                try {
                    DoricJSEngine.this.mTimerExtension.setTimer(args[0].number().longValue(), args[1].number().longValue(), args[2].bool());
                }
                catch (Exception e) {
                    DoricJSEngine.this.mDoricRegistry.onException(null, e);
                }
                return null;
            }
        });
        this.mDoricJSE.injectGlobalJSFunction("nativeClearTimer", new JavaFunction(){

            public JavaValue exec(JSDecoder[] args) {
                try {
                    DoricJSEngine.this.mTimerExtension.clearTimer(args[0].number().longValue());
                }
                catch (Exception e) {
                    DoricJSEngine.this.mDoricRegistry.onException(null, e);
                }
                return null;
            }
        });
        this.mDoricJSE.injectGlobalJSFunction("nativeBridge", new JavaFunction(){

            public JavaValue exec(JSDecoder[] args) {
                String source = "Unknown";
                try {
                    String contextId = args[0].string();
                    String module = args[1].string();
                    String method = args[2].string();
                    String callbackId = args[3].string();
                    JSDecoder jsDecoder = args[4];
                    return DoricJSEngine.this.mDoricBridgeExtension.callNative(contextId, module, method, callbackId, jsDecoder);
                }
                catch (Exception e) {
                    DoricJSEngine.this.mDoricRegistry.onException(null, e);
                    return null;
                }
            }
        });
    }

    private void initDoricRuntime() {
        try {
            this.loadBuiltinJS("doric-sandbox.js");
            String libName = "doric";
            String libJS = DoricUtils.readAssetFile("doric-lib.js");
            this.mDoricJSE.loadJS(this.packageModuleScript(libName, libJS), "Module://" + libName);
        }
        catch (Exception e) {
            this.mDoricRegistry.onException(null, e);
        }
    }

    public boolean handleMessage(Message msg) {
        return false;
    }

    public void teardown() {
        this.mDoricJSE.teardown();
        this.mTimerExtension.teardown();
        this.handlerThread.quit();
        this.mJSHandler.removeCallbacksAndMessages(null);
    }

    private void loadBuiltinJS(String assetName) {
        String script = DoricUtils.readAssetFile(assetName);
        this.mDoricJSE.loadJS(script, "Assets://" + assetName);
    }

    public void prepareContext(String contextId, String script, String source) {
        this.mDoricJSE.loadJS(this.packageContextScript(contextId, script), "Context://" + source);
    }

    public void destroyContext(String contextId) {
        this.mDoricJSE.loadJS(String.format("doric.jsReleaseContext(\"%s\")", contextId), "_Context://" + contextId);
    }

    private String packageContextScript(String contextId, String content) {
        return String.format("Reflect.apply(function(doric,context,Entry,require,exports){\n%s\n},undefined,[undefined,doric.jsObtainContext(\"%s\"),doric.jsObtainEntry(\"%s\"),doric.__require__,{}])", content, contextId, contextId);
    }

    private String packageModuleScript(String moduleName, String content) {
        return String.format("Reflect.apply(doric.jsRegisterModule,this,[\"%s\",Reflect.apply(function(__module){(function(module,exports,require){\n%s\n})(__module,__module.exports,doric.__require__);\nreturn __module.exports;},this,[{exports:{}}])])", moduleName, content);
    }

    public JSDecoder invokeDoricMethod(String method, Object ... args) {
        ArrayList<JavaValue> values = new ArrayList<JavaValue>();
        for (Object arg : args) {
            values.add(DoricUtils.toJavaValue(arg));
        }
        return this.mDoricJSE.invokeMethod("doric", method, values.toArray(new JavaValue[values.size()]), false);
    }

    @Override
    public void callback(long timerId) {
        try {
            this.invokeDoricMethod("jsCallbackTimer", timerId);
        }
        catch (Exception e) {
            this.mDoricRegistry.onException(null, e);
            this.mDoricRegistry.onLog(6, String.format("Timer Callback error:%s", e.getLocalizedMessage()));
        }
    }

    public DoricRegistry getRegistry() {
        return this.mDoricRegistry;
    }

    @Override
    public void onException(@Nullable DoricContext context, Exception e) {
        Log.e((String)DoricJSEngine.class.getSimpleName(), (String)("In source file: " + (context != null ? context.getSource() : "Unknown")));
        e.printStackTrace();
    }

    @Override
    public void onLog(int type, String message) {
        switch (type) {
            case 6: {
                DoricLog.suffix_e("_js", message, new Object[0]);
                break;
            }
            case 5: {
                DoricLog.suffix_w("_js", message, new Object[0]);
                break;
            }
            default: {
                DoricLog.suffix_d("_js", message, new Object[0]);
            }
        }
    }
}

