/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.async;

import pub.doric.async.SettableFuture;

public class AsyncResult<R> {
    private static Object EMPTY = new Object();
    private Object result = EMPTY;
    private Callback<R> callback = null;

    public AsyncResult() {
    }

    public AsyncResult(R r) {
        this.result = r;
    }

    public void setResult(R result) {
        this.result = result;
        if (this.callback != null) {
            this.callback.onResult(result);
            this.callback.onFinish();
        }
    }

    public void setError(Throwable result) {
        this.result = result;
        if (this.callback != null) {
            this.callback.onError(result);
            this.callback.onFinish();
        }
    }

    public boolean hasResult() {
        return this.result != EMPTY;
    }

    public R getResult() {
        return (R)this.result;
    }

    public void setCallback(Callback<R> callback) {
        this.callback = callback;
        if (this.result instanceof Throwable) {
            this.callback.onError((Throwable)this.result);
            this.callback.onFinish();
        } else if (this.result != EMPTY) {
            this.callback.onResult(this.result);
            this.callback.onFinish();
        }
    }

    public SettableFuture<R> synchronous() {
        final SettableFuture settableFuture = new SettableFuture();
        this.setCallback(new Callback<R>(){

            @Override
            public void onResult(R result) {
                settableFuture.set(result);
            }

            @Override
            public void onError(Throwable t) {
                settableFuture.set(null);
            }

            @Override
            public void onFinish() {
            }
        });
        return settableFuture;
    }

    public static interface Callback<R> {
        public void onResult(R var1);

        public void onError(Throwable var1);

        public void onFinish();
    }
}

