/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.async;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import pub.doric.async.AsyncResult;

public class AsyncCall {
    public static <T> AsyncResult<T> ensureRunInHandler(Handler handler, final Callable<T> callable) {
        final AsyncResult<T> asyncResult = new AsyncResult<T>();
        if (Looper.myLooper() == handler.getLooper()) {
            try {
                asyncResult.setResult(callable.call());
            }
            catch (Exception e) {
                e.printStackTrace();
                asyncResult.setError(e);
            }
        } else {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        asyncResult.setResult(callable.call());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        asyncResult.setError(e);
                    }
                }
            });
        }
        return asyncResult;
    }

    public static <T> AsyncResult<T> ensureRunInExecutor(ExecutorService executorService, final Callable<T> callable) {
        final AsyncResult asyncResult = new AsyncResult();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    asyncResult.setResult(callable.call());
                }
                catch (Exception e) {
                    asyncResult.setError(e);
                }
            }
        });
        return asyncResult;
    }
}

