/*
 * Decompiled with CFR 0.152.
 */
package pub.doric;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import pub.doric.DoricContext;
import pub.doric.DoricLibrary;
import pub.doric.IDoricMonitor;
import pub.doric.plugin.AnimatePlugin;
import pub.doric.plugin.CoordinatorPlugin;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.plugin.ModalPlugin;
import pub.doric.plugin.NavBarPlugin;
import pub.doric.plugin.NavigatorPlugin;
import pub.doric.plugin.NetworkPlugin;
import pub.doric.plugin.NotchPlugin;
import pub.doric.plugin.NotificationPlugin;
import pub.doric.plugin.PopoverPlugin;
import pub.doric.plugin.ShaderPlugin;
import pub.doric.plugin.StatusBarPlugin;
import pub.doric.plugin.StoragePlugin;
import pub.doric.refresh.RefreshableNode;
import pub.doric.shader.DraggableNode;
import pub.doric.shader.HLayoutNode;
import pub.doric.shader.ImageNode;
import pub.doric.shader.InputNode;
import pub.doric.shader.RootNode;
import pub.doric.shader.ScrollerNode;
import pub.doric.shader.StackNode;
import pub.doric.shader.SwitchNode;
import pub.doric.shader.TextNode;
import pub.doric.shader.VLayoutNode;
import pub.doric.shader.ViewNode;
import pub.doric.shader.flex.FlexNode;
import pub.doric.shader.flowlayout.FlowLayoutItemNode;
import pub.doric.shader.flowlayout.FlowLayoutNode;
import pub.doric.shader.list.ListItemNode;
import pub.doric.shader.list.ListNode;
import pub.doric.shader.slider.NestedSliderNode;
import pub.doric.shader.slider.SlideItemNode;
import pub.doric.shader.slider.SliderNode;
import pub.doric.utils.DoricMetaInfo;

public class DoricRegistry {
    private static Map<String, String> bundles = new ConcurrentHashMap<String, String>();
    private static Set<DoricLibrary> doricLibraries = new HashSet<DoricLibrary>();
    private Map<String, Object> extendedEnvValues = new HashMap<String, Object>();
    private Map<String, DoricMetaInfo<DoricJavaPlugin>> pluginInfoMap = new HashMap<String, DoricMetaInfo<DoricJavaPlugin>>();
    private Map<String, DoricMetaInfo<ViewNode>> nodeInfoMap = new HashMap<String, DoricMetaInfo<ViewNode>>();
    private Set<IDoricMonitor> monitors = new HashSet<IDoricMonitor>();
    private Drawable defaultPlaceHolderDrawable = null;
    private Drawable defaultErrorDrawable = null;

    private static void initRegistry(DoricRegistry doricRegistry) {
        for (DoricLibrary library : doricLibraries) {
            library.load(doricRegistry);
        }
    }

    public static void register(DoricLibrary doricLibrary) {
        doricLibraries.add(doricLibrary);
    }

    public DoricRegistry() {
        this.registerNativePlugin(ShaderPlugin.class);
        this.registerNativePlugin(ModalPlugin.class);
        this.registerNativePlugin(NetworkPlugin.class);
        this.registerNativePlugin(StoragePlugin.class);
        this.registerNativePlugin(NavigatorPlugin.class);
        this.registerNativePlugin(NavBarPlugin.class);
        this.registerNativePlugin(PopoverPlugin.class);
        this.registerNativePlugin(AnimatePlugin.class);
        this.registerNativePlugin(NotificationPlugin.class);
        this.registerNativePlugin(StatusBarPlugin.class);
        this.registerNativePlugin(CoordinatorPlugin.class);
        this.registerNativePlugin(NotchPlugin.class);
        this.registerViewNode(RootNode.class);
        this.registerViewNode(TextNode.class);
        this.registerViewNode(ImageNode.class);
        this.registerViewNode(StackNode.class);
        this.registerViewNode(VLayoutNode.class);
        this.registerViewNode(HLayoutNode.class);
        this.registerViewNode(ListNode.class);
        this.registerViewNode(ListItemNode.class);
        this.registerViewNode(ScrollerNode.class);
        this.registerViewNode(SliderNode.class);
        this.registerViewNode(SlideItemNode.class);
        this.registerViewNode(RefreshableNode.class);
        this.registerViewNode(FlowLayoutNode.class);
        this.registerViewNode(FlowLayoutItemNode.class);
        this.registerViewNode(InputNode.class);
        this.registerViewNode(NestedSliderNode.class);
        this.registerViewNode(DraggableNode.class);
        this.registerViewNode(SwitchNode.class);
        this.registerViewNode(FlexNode.class);
        DoricRegistry.initRegistry(this);
    }

    public void registerJSBundle(String name, String bundle) {
        bundles.put(name, bundle);
    }

    public void registerNativePlugin(Class<? extends DoricJavaPlugin> pluginClass) {
        DoricMetaInfo<? extends DoricJavaPlugin> doricMetaInfo = new DoricMetaInfo<DoricJavaPlugin>(pluginClass);
        if (!TextUtils.isEmpty((CharSequence)doricMetaInfo.getName())) {
            this.pluginInfoMap.put(doricMetaInfo.getName(), doricMetaInfo);
        }
    }

    public DoricMetaInfo<DoricJavaPlugin> acquirePluginInfo(String name) {
        return this.pluginInfoMap.get(name);
    }

    public void registerViewNode(Class<? extends ViewNode> pluginClass) {
        DoricMetaInfo<? extends ViewNode> doricMetaInfo = new DoricMetaInfo<ViewNode>(pluginClass);
        if (!TextUtils.isEmpty((CharSequence)doricMetaInfo.getName())) {
            this.nodeInfoMap.put(doricMetaInfo.getName(), doricMetaInfo);
        }
    }

    public DoricMetaInfo<ViewNode> acquireViewNodeInfo(String name) {
        return this.nodeInfoMap.get(name);
    }

    public String acquireJSBundle(String name) {
        return bundles.get(name);
    }

    public void setEnvironmentVariable(String key, Object val) {
        this.extendedEnvValues.put(key, val);
    }

    public Map<String, Object> getEnvironmentVariables() {
        return this.extendedEnvValues;
    }

    public void registerMonitor(IDoricMonitor monitor) {
        this.monitors.add(monitor);
    }

    public void onException(DoricContext context, Exception e) {
        for (IDoricMonitor monitor : this.monitors) {
            monitor.onException(context, e);
        }
    }

    public void onLog(int type, String message) {
        for (IDoricMonitor monitor : this.monitors) {
            monitor.onLog(type, message);
        }
    }

    public Drawable getDefaultPlaceHolderDrawable() {
        return this.defaultPlaceHolderDrawable;
    }

    public void setDefaultPlaceHolderDrawable(Drawable defaultPlaceHolderDrawable) {
        this.defaultPlaceHolderDrawable = defaultPlaceHolderDrawable;
    }

    public Drawable getDefaultErrorDrawable() {
        return this.defaultErrorDrawable;
    }

    public void setDefaultErrorDrawable(Drawable defaultErrorDrawable) {
        this.defaultErrorDrawable = defaultErrorDrawable;
    }
}

