/*
 * Decompiled with CFR 0.152.
 */
package pub.doric;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.DoricPanel;
import pub.doric.R;
import pub.doric.async.AsyncCall;
import pub.doric.async.AsyncResult;
import pub.doric.loader.DoricJSLoaderManager;
import pub.doric.navbar.BaseDoricNavBar;
import pub.doric.navigator.IDoricNavigator;
import pub.doric.utils.DoricLog;

public class DoricPanelFragment
extends Fragment
implements IDoricNavigator {
    private DoricPanel doricPanel;
    private Handler uiHandler = new Handler(Looper.getMainLooper());
    private FrameLayout maskView;

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.doric_framgent_panel, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.maskView = (FrameLayout)this.requireActivity().getWindow().getDecorView().findViewById(R.id.doric_mask);
        if (this.doricPanel == null) {
            this.doricPanel = (DoricPanel)view.findViewById(R.id.doric_panel);
            this.loadJSBundle();
        } else {
            DoricPanel panel = (DoricPanel)view.findViewById(R.id.doric_panel);
            if (this.doricPanel != panel) {
                DoricContext doricContext = this.doricPanel.getDoricContext();
                this.doricPanel = panel;
                if (doricContext == null) {
                    this.loadJSBundle();
                } else {
                    panel.config(doricContext);
                }
            }
        }
        if (this.getContext() instanceof LifecycleOwner) {
            ((LifecycleOwner)this.getContext()).getLifecycle().removeObserver((LifecycleObserver)this.doricPanel);
        }
    }

    @Override
    public void push(String source, String alias, String extra) {
        if (this.getActivity() == null || this.getActivity().isFinishing()) {
            return;
        }
        Bundle argument = new Bundle();
        argument.putString("source", source);
        argument.putString("alias", alias);
        argument.putString("extra", extra);
        NavController navController = this.getNavController();
        if (navController != null) {
            this.getNavController().navigate(R.id.action_doricPanelFragment_to_doricPanelFragment, argument);
        }
    }

    @Override
    public void pop() {
        if (this.getActivity() == null || this.getActivity().isFinishing()) {
            return;
        }
        NavController navController = this.getNavController();
        if (navController != null && !navController.popBackStack()) {
            this.getActivity().finish();
        }
    }

    @Nullable
    private NavController getNavController() {
        if (this.getView() == null) {
            return null;
        }
        return Navigation.findNavController((View)this.getView());
    }

    public void onResume() {
        super.onResume();
        if (this.doricPanel != null) {
            this.doricPanel.onActivityResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.doricPanel != null) {
            this.doricPanel.onActivityPause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.doricPanel != null) {
            this.doricPanel.onActivityDestroy();
        }
    }

    private void hideMask() {
        AsyncCall.ensureRunInHandler(this.uiHandler, new Callable<Object>(){

            @Override
            public Object call() {
                DoricPanelFragment.this.maskView.setVisibility(8);
                return null;
            }
        });
    }

    private void showLoading() {
        AsyncCall.ensureRunInHandler(this.uiHandler, new Callable<Object>(){

            @Override
            public Object call() {
                DoricPanelFragment.this.maskView.setVisibility(0);
                DoricPanelFragment.this.maskView.findViewById(R.id.doric_mask_loading).setVisibility(0);
                DoricPanelFragment.this.maskView.findViewById(R.id.doric_mask_error).setVisibility(8);
                return null;
            }
        });
    }

    private void showError() {
        AsyncCall.ensureRunInHandler(this.uiHandler, new Callable<Object>(){

            @Override
            public Object call() {
                DoricPanelFragment.this.maskView.setVisibility(0);
                DoricPanelFragment.this.maskView.findViewById(R.id.doric_mask_loading).setVisibility(8);
                DoricPanelFragment.this.maskView.findViewById(R.id.doric_mask_error).setVisibility(0);
                View retryView = DoricPanelFragment.this.maskView.findViewById(R.id.doric_mask_error_retry);
                if (retryView != null) {
                    retryView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            DoricPanelFragment.this.loadJSBundle();
                        }
                    });
                }
                return null;
            }
        });
    }

    private void loadJSBundle() {
        Bundle argument = this.getArguments();
        if (argument == null && this.getActivity() != null && this.getActivity().getIntent() != null) {
            argument = this.getActivity().getIntent().getExtras();
        }
        if (argument == null) {
            DoricLog.e("DoricPanelFragment argument is null", new Object[0]);
            return;
        }
        this.showLoading();
        final String alias = argument.getString("alias");
        String source = argument.getString("source");
        final String extra = argument.getString("extra");
        DoricJSLoaderManager.getInstance().loadJSBundle(source).setCallback(new AsyncResult.Callback<String>(){

            @Override
            public void onResult(String result) {
                if (DoricPanelFragment.this.getActivity() == null) {
                    return;
                }
                DoricPanelFragment.this.doricPanel.config(result, alias, extra);
                DoricContext context = DoricPanelFragment.this.doricPanel.getDoricContext();
                context.setDoricNavigator(DoricPanelFragment.this);
                BaseDoricNavBar navBar = (BaseDoricNavBar)DoricPanelFragment.this.requireActivity().getWindow().getDecorView().findViewById(R.id.doric_nav_bar);
                context.setDoricNavBar(navBar);
                DoricPanelFragment.this.hideMask();
            }

            @Override
            public void onError(Throwable t) {
                if (DoricPanelFragment.this.getActivity() == null) {
                    return;
                }
                DoricLog.e("DoricPanelFragment load JS error:" + t.getLocalizedMessage(), new Object[0]);
                DoricPanelFragment.this.showError();
            }

            @Override
            public void onFinish() {
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.doricPanel.onActivityResult(requestCode, resultCode, data);
    }
}

