/*
 * Decompiled with CFR 0.152.
 */
package pub.doric;

import android.os.Handler;
import android.os.Looper;
import com.github.pengfeizhou.jscore.JSDecoder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pub.doric.DoricContextManager;
import pub.doric.DoricRegistry;
import pub.doric.IDoricDriver;
import pub.doric.async.AsyncCall;
import pub.doric.async.AsyncResult;
import pub.doric.engine.DoricJSEngine;
import pub.doric.utils.ThreadMode;

public class DoricNativeDriver
implements IDoricDriver {
    private final DoricJSEngine doricJSEngine = new DoricJSEngine();
    private final ExecutorService mBridgeExecutor = Executors.newCachedThreadPool();
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private final Handler mJSHandler = this.doricJSEngine.getJSHandler();

    private DoricNativeDriver() {
    }

    public static DoricNativeDriver getInstance() {
        return Inner.sInstance;
    }

    @Override
    public AsyncResult<JSDecoder> invokeContextEntityMethod(final String contextId, String method, Object ... args) {
        final AsyncResult<JSDecoder> asyncResult = new AsyncResult<JSDecoder>();
        Object[] nArgs = new Object[args.length + 2];
        nArgs[0] = contextId;
        nArgs[1] = method;
        if (args.length > 0) {
            System.arraycopy(args, 0, nArgs, 2, args.length);
        }
        this.invokeDoricMethod("jsCallEntityMethod", nArgs).setCallback(new AsyncResult.Callback<JSDecoder>(){

            @Override
            public void onResult(JSDecoder result) {
                asyncResult.setResult(result);
            }

            @Override
            public void onError(Throwable t) {
                asyncResult.setError(t);
                DoricNativeDriver.this.getRegistry().onException(DoricContextManager.getContext(contextId), t instanceof Exception ? (Exception)t : new RuntimeException(t));
            }

            @Override
            public void onFinish() {
            }
        });
        return asyncResult;
    }

    @Override
    public AsyncResult<JSDecoder> invokeDoricMethod(final String method, final Object ... args) {
        return AsyncCall.ensureRunInHandler(this.mJSHandler, new Callable<JSDecoder>(){

            @Override
            public JSDecoder call() {
                return DoricNativeDriver.this.doricJSEngine.invokeDoricMethod(method, args);
            }
        });
    }

    @Override
    public <T> AsyncResult<T> asyncCall(Callable<T> callable, ThreadMode threadMode) {
        switch (threadMode) {
            case JS: {
                return AsyncCall.ensureRunInHandler(this.mJSHandler, callable);
            }
            case UI: {
                return AsyncCall.ensureRunInHandler(this.mUIHandler, callable);
            }
        }
        return AsyncCall.ensureRunInExecutor(this.mBridgeExecutor, callable);
    }

    @Override
    public AsyncResult<Boolean> createContext(final String contextId, final String script, final String source) {
        return AsyncCall.ensureRunInHandler(this.mJSHandler, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    DoricNativeDriver.this.doricJSEngine.prepareContext(contextId, script, source);
                    return true;
                }
                catch (Exception e) {
                    DoricNativeDriver.this.doricJSEngine.getRegistry().onException(DoricContextManager.getContext(contextId), e);
                    DoricNativeDriver.this.doricJSEngine.getRegistry().onLog(6, String.format("createContext %s error is %s", source, e.getLocalizedMessage()));
                    return false;
                }
            }
        });
    }

    @Override
    public AsyncResult<Boolean> destroyContext(final String contextId) {
        return AsyncCall.ensureRunInHandler(this.mJSHandler, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    DoricNativeDriver.this.doricJSEngine.destroyContext(contextId);
                    return true;
                }
                catch (Exception e) {
                    DoricNativeDriver.this.doricJSEngine.getRegistry().onException(DoricContextManager.getContext(contextId), e);
                    DoricNativeDriver.this.doricJSEngine.getRegistry().onLog(6, String.format("destroyContext %s error is %s", contextId, e.getLocalizedMessage()));
                    return false;
                }
            }
        });
    }

    @Override
    public DoricRegistry getRegistry() {
        return this.doricJSEngine.getRegistry();
    }

    private static class Inner {
        private static final DoricNativeDriver sInstance = new DoricNativeDriver();

        private Inner() {
        }
    }
}

