/*
 * Decompiled with CFR 0.152.
 */
package pub.doric;

import android.content.Context;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import pub.doric.DoricContext;
import pub.doric.async.AsyncResult;

public class DoricContextManager {
    private final AtomicInteger counter = new AtomicInteger();
    private final Map<String, DoricContext> doricContextMap = new ConcurrentHashMap<String, DoricContext>();

    private DoricContextManager() {
    }

    public static DoricContextManager getInstance() {
        return Inner.sInstance;
    }

    DoricContext createContext(Context context, String script, String source, String extra) {
        String contextId = String.valueOf(this.counter.incrementAndGet());
        DoricContext doricContext = new DoricContext(context, contextId, source, extra);
        this.doricContextMap.put(contextId, doricContext);
        doricContext.getDriver().createContext(contextId, script, source);
        return doricContext;
    }

    AsyncResult<Boolean> destroyContext(final DoricContext context) {
        final AsyncResult<Boolean> result = new AsyncResult<Boolean>();
        context.getDriver().destroyContext(context.getContextId()).setCallback(new AsyncResult.Callback<Boolean>(){

            @Override
            public void onResult(Boolean b) {
                result.setResult(b);
            }

            @Override
            public void onError(Throwable t) {
                result.setError(t);
            }

            @Override
            public void onFinish() {
                DoricContextManager.this.doricContextMap.remove(context.getContextId());
            }
        });
        return result;
    }

    public static DoricContext getContext(String contextId) {
        return DoricContextManager.getInstance().doricContextMap.get(contextId);
    }

    public static Set<String> getKeySet() {
        return DoricContextManager.getInstance().doricContextMap.keySet();
    }

    public static Collection<DoricContext> aliveContexts() {
        return DoricContextManager.getInstance().doricContextMap.values();
    }

    private static class Inner {
        private static final DoricContextManager sInstance = new DoricContextManager();

        private Inner() {
        }
    }
}

